/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.test.DiffRepository;
import mondrian.test.TestContext;
import mondrian.xmla.XmlaHandler;
import mondrian.xmla.XmlaUtil;
import mondrian.xmla.impl.DefaultXmlaRequest;
import mondrian.xmla.impl.DefaultXmlaResponse;
import mondrian.xmla.test.XmlaTestContext;
import org.apache.log4j.Logger;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlaTest
extends TestCase {
    private static final Logger LOGGER = Logger.getLogger(XmlaTest.class);
    private static final XmlaTestContext context;

    public XmlaTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        DiffRepository diffRepos = XmlaTest.getDiffRepos();
        diffRepos.setCurrentTestCaseName(this.getName());
    }

    protected void tearDown() throws Exception {
        DiffRepository diffRepos = XmlaTest.getDiffRepos();
        diffRepos.setCurrentTestCaseName(null);
        super.tearDown();
    }

    private static DiffRepository getDiffRepos() {
        return DiffRepository.lookup(XmlaTest.class);
    }

    protected void runTest() throws Exception {
        if (!MondrianProperties.instance().SsasCompatibleNaming.get() && this.getName().equals("mdschemaLevelsCubeDimRestrictions")) {
            return;
        }
        DiffRepository diffRepos = XmlaTest.getDiffRepos();
        String request = diffRepos.expand(null, "${request}");
        String expectedResponse = diffRepos.expand(null, "${response}");
        Element requestElem = XmlaUtil.text2Element(XmlaTestContext.xmlFromTemplate(request, XmlaTestContext.ENV));
        Element responseElem = this.ignoreLastUpdateDate(XmlaTest.executeRequest(requestElem));
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        StringWriter bufWriter = new StringWriter();
        transformer.transform(new DOMSource(responseElem), new StreamResult(bufWriter));
        bufWriter.write(Util.nl);
        String actualResponse = TestContext.instance().upgradeActual(bufWriter.getBuffer().toString());
        try {
            XMLAssert.assertXMLEqual((String)expectedResponse, (String)actualResponse);
        }
        catch (AssertionFailedError e) {
            diffRepos.assertEquals("response", "${response}", actualResponse);
        }
    }

    private Element ignoreLastUpdateDate(Element element) {
        NodeList elements = element.getElementsByTagName("LAST_SCHEMA_UPDATE");
        for (int i = elements.getLength(); i > 0; --i) {
            this.removeNode(elements.item(i - 1));
        }
        return element;
    }

    private void removeNode(Node node) {
        Node parentNode = node.getParentNode();
        parentNode.removeChild(node);
    }

    private static Element executeRequest(Element requestElem) {
        ByteArrayOutputStream resBuf = new ByteArrayOutputStream();
        XmlaHandler handler = new XmlaHandler(context.dataSources(), XmlaTestContext.CATALOG_LOCATOR, "xmla");
        DefaultXmlaRequest request = new DefaultXmlaRequest(requestElem);
        DefaultXmlaResponse response = new DefaultXmlaResponse(resBuf, "UTF-8");
        handler.process(request, response);
        return XmlaUtil.stream2Element(new ByteArrayInputStream(resBuf.toByteArray()));
    }

    public static TestSuite suite() {
        TestSuite suite = new TestSuite();
        DiffRepository diffRepos = XmlaTest.getDiffRepos();
        MondrianProperties properties = MondrianProperties.instance();
        String filePattern = properties.QueryFilePattern.get();
        Pattern pattern = filePattern == null ? null : Pattern.compile(filePattern);
        List<String> testCaseNames = diffRepos.getTestCaseNames();
        if (pattern != null) {
            Iterator<String> iter = testCaseNames.iterator();
            while (iter.hasNext()) {
                String name = iter.next();
                if (pattern.matcher(name).matches()) continue;
                iter.remove();
            }
        }
        LOGGER.debug((Object)("Found " + testCaseNames.size() + " XML/A test cases"));
        for (String name : testCaseNames) {
            suite.addTest((Test)new XmlaTest(name));
        }
        suite.addTestSuite(OtherTest.class);
        return suite;
    }

    static {
        XMLUnit.setControlParser((String)"org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
        XMLUnit.setTestParser((String)"org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
        XMLUnit.setIgnoreWhitespace((boolean)true);
        context = new XmlaTestContext();
    }

    public static class OtherTest
    extends TestCase {
        public void testEncodeElementName() {
            OtherTest.assertEquals((String)"Foo", (String)XmlaUtil.encodeElementName("Foo"));
            OtherTest.assertEquals((String)"Foo_x0020_Bar", (String)XmlaUtil.encodeElementName("Foo Bar"));
        }
    }
}

