/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URLStreamHandlerFactory;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRAbstractScriptlet;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.base.JRBaseDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactory;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.type.ResetTypeEnum;
import net.sf.jasperreports.engine.util.FileResolver;
import net.sf.jasperreports.engine.util.FormatFactory;
import net.sf.jasperreports.engine.util.JRQueryExecuterUtils;

public class JRDesignDataset
extends JRBaseDataset {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_FIELDS = "fields";
    public static final String PROPERTY_FILTER_EXPRESSION = "filterExpression";
    public static final String PROPERTY_GROUPS = "groups";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_SCRIPTLETS = "scriptlets";
    public static final String PROPERTY_PARAMETERS = "parameters";
    public static final String PROPERTY_QUERY = "query";
    public static final String PROPERTY_RESOURCE_BUNDLE = "resourceBundle";
    public static final String PROPERTY_SCRIPTLET_CLASS = "scriptletClass";
    public static final String PROPERTY_SORT_FIELDS = "sortFields";
    public static final String PROPERTY_VARIABLES = "variables";
    protected Map scriptletsMap = new HashMap();
    protected List scriptletsList = new ArrayList();
    protected Map parametersMap = new HashMap();
    protected List parametersList = new ArrayList();
    protected Map fieldsMap = new HashMap();
    protected List fieldsList = new ArrayList();
    protected Map sortFieldsMap = new HashMap();
    protected List sortFieldsList = new ArrayList();
    protected Map variablesMap = new HashMap();
    protected List variablesList = new ArrayList();
    protected Map groupsMap = new HashMap();
    protected List groupsList = new ArrayList();
    private PropertyChangeListener queryLanguageChangeListener = new QueryLanguageChangeListener();
    private static final Object[] BUILT_IN_PARAMETERS = new Object[]{"REPORT_PARAMETERS_MAP", Map.class, "JASPER_REPORT", JasperReport.class, "REPORT_CONNECTION", Connection.class, "REPORT_MAX_COUNT", Integer.class, "REPORT_DATA_SOURCE", JRDataSource.class, "REPORT_SCRIPTLET", JRAbstractScriptlet.class, "REPORT_LOCALE", Locale.class, "REPORT_RESOURCE_BUNDLE", ResourceBundle.class, "REPORT_TIME_ZONE", TimeZone.class, "REPORT_FORMAT_FACTORY", FormatFactory.class, "REPORT_CLASS_LOADER", ClassLoader.class, "REPORT_URL_HANDLER_FACTORY", URLStreamHandlerFactory.class, "REPORT_FILE_RESOLVER", FileResolver.class, "REPORT_TEMPLATES", Collection.class, "SORT_FIELDS", List.class};
    private static final Object[] BUILT_IN_PARAMETERS_MAIN = new Object[]{"REPORT_VIRTUALIZER", JRVirtualizer.class, "IS_IGNORE_PAGINATION", Boolean.class};

    public JRDesignDataset(boolean isMain) {
        super(isMain);
        this.addBuiltinParameters(BUILT_IN_PARAMETERS);
        if (isMain) {
            this.addBuiltinParameters(BUILT_IN_PARAMETERS_MAIN);
        }
        try {
            this.addVariable(JRDesignDataset.createPageNumberVariable());
            this.addVariable(JRDesignDataset.createColumnNumberVariable());
            this.addVariable(JRDesignDataset.createReportCountVariable());
            this.addVariable(JRDesignDataset.createPageCountVariable());
            this.addVariable(JRDesignDataset.createColumnCountVariable());
        }
        catch (JRException jRException) {
            // empty catch block
        }
    }

    private static JRDesignVariable createPageCountVariable() {
        JRDesignVariable variable = new JRDesignVariable();
        variable.setName("PAGE_COUNT");
        variable.setValueClass(Integer.class);
        variable.setResetType(ResetTypeEnum.PAGE);
        variable.setCalculation(CalculationEnum.COUNT);
        variable.setSystemDefined(true);
        JRDesignExpression expression = new JRDesignExpression();
        expression.setValueClass(Integer.class);
        expression.setText("new java.lang.Integer(1)");
        variable.setExpression(expression);
        expression = new JRDesignExpression();
        expression.setValueClass(Integer.class);
        expression.setText("new java.lang.Integer(0)");
        variable.setInitialValueExpression(expression);
        return variable;
    }

    private static JRDesignVariable createColumnNumberVariable() {
        JRDesignVariable variable = new JRDesignVariable();
        variable.setName("COLUMN_NUMBER");
        variable.setValueClass(Integer.class);
        variable.setResetType(ResetTypeEnum.PAGE);
        variable.setCalculation(CalculationEnum.SYSTEM);
        variable.setSystemDefined(true);
        JRDesignExpression expression = new JRDesignExpression();
        expression.setValueClass(Integer.class);
        expression.setText("new java.lang.Integer(1)");
        variable.setInitialValueExpression(expression);
        return variable;
    }

    private static JRDesignVariable createPageNumberVariable() {
        JRDesignVariable variable = new JRDesignVariable();
        variable.setName("PAGE_NUMBER");
        variable.setValueClass(Integer.class);
        variable.setResetType(ResetTypeEnum.REPORT);
        variable.setCalculation(CalculationEnum.SYSTEM);
        variable.setSystemDefined(true);
        JRDesignExpression expression = new JRDesignExpression();
        expression.setValueClass(Integer.class);
        expression.setText("new java.lang.Integer(1)");
        variable.setInitialValueExpression(expression);
        return variable;
    }

    private static JRDesignVariable createColumnCountVariable() {
        JRDesignVariable variable = new JRDesignVariable();
        variable.setName("COLUMN_COUNT");
        variable.setValueClass(Integer.class);
        variable.setResetType(ResetTypeEnum.COLUMN);
        variable.setCalculation(CalculationEnum.COUNT);
        variable.setSystemDefined(true);
        JRDesignExpression expression = new JRDesignExpression();
        expression.setValueClass(Integer.class);
        expression.setText("new java.lang.Integer(1)");
        variable.setExpression(expression);
        expression = new JRDesignExpression();
        expression.setValueClass(Integer.class);
        expression.setText("new java.lang.Integer(0)");
        variable.setInitialValueExpression(expression);
        return variable;
    }

    private void addBuiltinParameters(Object[] parametersArray) {
        for (int i = 0; i < parametersArray.length; ++i) {
            JRDesignParameter parameter = new JRDesignParameter();
            parameter.setName((String)parametersArray[i++]);
            Object parameterType = parametersArray[i];
            if (parameterType instanceof Class) {
                parameter.setValueClass((Class)parameterType);
            } else if (parameterType instanceof String) {
                parameter.setValueClassName((String)parameterType);
            } else {
                throw new JRRuntimeException("Unknown builtin parameter type " + parameterType + " of class " + parameterType.getClass().getName() + ". Expecint java.lang.Class or java.lang.String");
            }
            parameter.setSystemDefined(true);
            try {
                this.addParameter(parameter);
                continue;
            }
            catch (JRException e) {
                // empty catch block
            }
        }
    }

    private static JRDesignVariable createReportCountVariable() {
        JRDesignVariable variable = new JRDesignVariable();
        variable.setName("REPORT_COUNT");
        variable.setValueClass(Integer.class);
        variable.setResetType(ResetTypeEnum.REPORT);
        variable.setCalculation(CalculationEnum.COUNT);
        variable.setSystemDefined(true);
        JRDesignExpression expression = new JRDesignExpression();
        expression.setValueClass(Integer.class);
        expression.setText("new java.lang.Integer(1)");
        variable.setExpression(expression);
        expression = new JRDesignExpression();
        expression.setValueClass(Integer.class);
        expression.setText("new java.lang.Integer(0)");
        variable.setInitialValueExpression(expression);
        return variable;
    }

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.getEventSupport().firePropertyChange(PROPERTY_NAME, old, this.name);
    }

    public JRScriptlet[] getScriptlets() {
        JRScriptlet[] scriptletsArray = new JRScriptlet[this.scriptletsList.size()];
        this.scriptletsList.toArray(scriptletsArray);
        return scriptletsArray;
    }

    public List getScriptletsList() {
        return this.scriptletsList;
    }

    public Map getScriptletsMap() {
        return this.scriptletsMap;
    }

    public void addScriptlet(JRScriptlet scriptlet) throws JRException {
        this.addScriptlet(this.scriptletsList.size(), scriptlet);
    }

    public void addScriptlet(int index, JRScriptlet scriptlet) throws JRException {
        if (this.scriptletsMap.containsKey(scriptlet.getName())) {
            throw new JRException("Duplicate declaration of scriptlet : " + scriptlet.getName());
        }
        JRDesignParameter scriptletParameter = new JRDesignParameter();
        scriptletParameter.setName(scriptlet.getName() + "_SCRIPTLET");
        scriptletParameter.setValueClassName(scriptlet.getValueClassName());
        scriptletParameter.setSystemDefined(true);
        scriptletParameter.setForPrompting(false);
        this.addParameter(scriptletParameter);
        this.scriptletsList.add(index, scriptlet);
        this.scriptletsMap.put(scriptlet.getName(), scriptlet);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_SCRIPTLETS, scriptlet, index);
    }

    public JRScriptlet removeScriptlet(String scriptletName) {
        return this.removeScriptlet((JRScriptlet)this.scriptletsMap.get(scriptletName));
    }

    public JRScriptlet removeScriptlet(JRScriptlet scriptlet) {
        if (scriptlet != null) {
            this.removeParameter(scriptlet.getName() + "_SCRIPTLET");
            int idx = this.scriptletsList.indexOf(scriptlet);
            if (idx >= 0) {
                this.scriptletsList.remove(idx);
                this.scriptletsMap.remove(scriptlet.getName());
                this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_SCRIPTLETS, scriptlet, idx);
            }
        }
        return scriptlet;
    }

    public JRParameter[] getParameters() {
        JRParameter[] parametersArray = new JRParameter[this.parametersList.size()];
        this.parametersList.toArray(parametersArray);
        return parametersArray;
    }

    public List getParametersList() {
        return this.parametersList;
    }

    public Map getParametersMap() {
        return this.parametersMap;
    }

    public void addParameter(JRParameter parameter) throws JRException {
        this.addParameter(this.parametersList.size(), parameter);
    }

    public void addParameter(int index, JRParameter parameter) throws JRException {
        if (this.parametersMap.containsKey(parameter.getName())) {
            throw new JRException("Duplicate declaration of parameter : " + parameter.getName());
        }
        this.parametersList.add(index, parameter);
        this.parametersMap.put(parameter.getName(), parameter);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PARAMETERS, parameter, index);
    }

    public JRParameter removeParameter(String parameterName) {
        return this.removeParameter((JRParameter)this.parametersMap.get(parameterName));
    }

    public JRParameter removeParameter(JRParameter parameter) {
        int idx;
        if (parameter != null && (idx = this.parametersList.indexOf(parameter)) >= 0) {
            this.parametersList.remove(idx);
            this.parametersMap.remove(parameter.getName());
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_PARAMETERS, parameter, idx);
        }
        return parameter;
    }

    public void setQuery(JRDesignQuery query) {
        JRQuery old = this.query;
        String oldLanguage = null;
        if (this.query != null) {
            ((JRDesignQuery)this.query).removePropertyChangeListener("language", this.queryLanguageChangeListener);
            oldLanguage = this.query.getLanguage();
        }
        this.query = query;
        String newLanguage = null;
        if (query != null) {
            query.addPropertyChangeListener("language", this.queryLanguageChangeListener);
            newLanguage = query.getLanguage();
        }
        this.queryLanguageChanged(oldLanguage, newLanguage);
        this.getEventSupport().firePropertyChange(PROPERTY_QUERY, old, this.query);
    }

    public void setScriptletClass(String scriptletClass) {
        String old = this.scriptletClass;
        this.scriptletClass = scriptletClass;
        if (scriptletClass == null) {
            ((JRDesignParameter)this.parametersMap.get("REPORT_SCRIPTLET")).setValueClass(JRAbstractScriptlet.class);
        } else {
            ((JRDesignParameter)this.parametersMap.get("REPORT_SCRIPTLET")).setValueClassName(scriptletClass);
        }
        this.getEventSupport().firePropertyChange(PROPERTY_SCRIPTLET_CLASS, old, this.scriptletClass);
    }

    public JRField[] getFields() {
        JRField[] fieldsArray = new JRField[this.fieldsList.size()];
        this.fieldsList.toArray(fieldsArray);
        return fieldsArray;
    }

    public List getFieldsList() {
        return this.fieldsList;
    }

    public Map getFieldsMap() {
        return this.fieldsMap;
    }

    public void addField(JRField field) throws JRException {
        this.addField(this.fieldsList.size(), field);
    }

    public void addField(int index, JRField field) throws JRException {
        if (this.fieldsMap.containsKey(field.getName())) {
            throw new JRException("Duplicate declaration of field : " + field.getName());
        }
        this.fieldsList.add(index, field);
        this.fieldsMap.put(field.getName(), field);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_FIELDS, field, index);
    }

    public JRField removeField(String fieldName) {
        return this.removeField((JRField)this.fieldsMap.get(fieldName));
    }

    public JRField removeField(JRField field) {
        int idx;
        if (field != null && (idx = this.fieldsList.indexOf(field)) >= 0) {
            this.fieldsList.remove(idx);
            this.fieldsMap.remove(field.getName());
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_FIELDS, field, idx);
        }
        return field;
    }

    public JRSortField[] getSortFields() {
        JRSortField[] sortFieldsArray = new JRSortField[this.sortFieldsList.size()];
        this.sortFieldsList.toArray(sortFieldsArray);
        return sortFieldsArray;
    }

    public List getSortFieldsList() {
        return this.sortFieldsList;
    }

    public void addSortField(JRSortField sortField) throws JRException {
        this.addSortField(this.sortFieldsList.size(), sortField);
    }

    public void addSortField(int index, JRSortField sortField) throws JRException {
        if (this.sortFieldsMap.containsKey(sortField.getName())) {
            throw new JRException("Duplicate declaration of sort field : " + sortField.getName());
        }
        this.sortFieldsList.add(index, sortField);
        this.sortFieldsMap.put(sortField.getName(), sortField);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_SORT_FIELDS, sortField, index);
    }

    public JRSortField removeSortField(String fieldName) {
        return this.removeSortField((JRSortField)this.sortFieldsMap.get(fieldName));
    }

    public JRSortField removeSortField(JRSortField sortField) {
        int idx;
        if (sortField != null && (idx = this.sortFieldsList.indexOf(sortField)) >= 0) {
            this.sortFieldsList.remove(idx);
            this.sortFieldsMap.remove(sortField.getName());
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_SORT_FIELDS, sortField, idx);
        }
        return sortField;
    }

    public JRVariable[] getVariables() {
        JRVariable[] variablesArray = new JRVariable[this.variablesList.size()];
        this.variablesList.toArray(variablesArray);
        return variablesArray;
    }

    public List getVariablesList() {
        return this.variablesList;
    }

    public Map getVariablesMap() {
        return this.variablesMap;
    }

    public void addVariable(JRDesignVariable variable) throws JRException {
        this.addVariable(this.variablesList.size(), variable, false);
    }

    public void addVariable(int index, JRDesignVariable variable) throws JRException {
        this.addVariable(index, variable, variable.isSystemDefined());
    }

    protected void addVariable(JRDesignVariable variable, boolean system) throws JRException {
        this.addVariable(this.variablesList.size(), variable, system);
    }

    protected void addVariable(int index, JRDesignVariable variable, boolean system) throws JRException {
        if (this.variablesMap.containsKey(variable.getName())) {
            throw new JRException("Duplicate declaration of variable : " + variable.getName());
        }
        if (system) {
            ListIterator<JRDesignVariable> it = this.variablesList.listIterator();
            while (it.hasNext()) {
                JRVariable var = (JRVariable)it.next();
                if (var.isSystemDefined()) continue;
                it.previous();
                break;
            }
            it.add(variable);
            index = it.previousIndex();
        } else {
            this.variablesList.add(index, variable);
        }
        this.variablesMap.put(variable.getName(), variable);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_VARIABLES, variable, index);
    }

    public JRVariable removeVariable(String variableName) {
        return this.removeVariable((JRVariable)this.variablesMap.get(variableName));
    }

    public JRVariable removeVariable(JRVariable variable) {
        int idx;
        if (variable != null && (idx = this.variablesList.indexOf(variable)) >= 0) {
            this.variablesList.remove(idx);
            this.variablesMap.remove(variable.getName());
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_VARIABLES, variable, idx);
        }
        return variable;
    }

    public JRGroup[] getGroups() {
        JRGroup[] groupsArray = new JRGroup[this.groupsList.size()];
        this.groupsList.toArray(groupsArray);
        return groupsArray;
    }

    public List getGroupsList() {
        return this.groupsList;
    }

    public Map getGroupsMap() {
        return this.groupsMap;
    }

    public void addGroup(JRDesignGroup group) throws JRException {
        this.addGroup(this.groupsList.size(), group);
    }

    public void addGroup(int index, JRDesignGroup group) throws JRException {
        if (this.groupsMap.containsKey(group.getName())) {
            throw new JRException("Duplicate declaration of group : " + group.getName());
        }
        JRDesignVariable countVariable = new JRDesignVariable();
        countVariable.setName(group.getName() + "_COUNT");
        countVariable.setValueClass(Integer.class);
        countVariable.setResetType(ResetTypeEnum.GROUP);
        countVariable.setResetGroup(group);
        countVariable.setCalculation(CalculationEnum.COUNT);
        countVariable.setSystemDefined(true);
        JRDesignExpression expression = new JRDesignExpression();
        expression.setValueClass(Integer.class);
        expression.setText("new java.lang.Integer(1)");
        countVariable.setExpression(expression);
        expression = new JRDesignExpression();
        expression.setValueClass(Integer.class);
        expression.setText("new java.lang.Integer(0)");
        countVariable.setInitialValueExpression(expression);
        this.addVariable(countVariable, true);
        group.setCountVariable(countVariable);
        this.groupsList.add(index, group);
        this.groupsMap.put(group.getName(), group);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_GROUPS, group, index);
    }

    public JRGroup removeGroup(String groupName) {
        return this.removeGroup((JRGroup)this.groupsMap.get(groupName));
    }

    public JRGroup removeGroup(JRGroup group) {
        if (group != null) {
            this.removeVariable(group.getCountVariable());
            int idx = this.groupsList.indexOf(group);
            if (idx >= 0) {
                this.groupsList.remove(idx);
                this.groupsMap.remove(group.getName());
                this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_GROUPS, group, idx);
            }
        }
        return group;
    }

    public void setResourceBundle(String resourceBundle) {
        String old = this.resourceBundle;
        this.resourceBundle = resourceBundle;
        this.getEventSupport().firePropertyChange(PROPERTY_RESOURCE_BUNDLE, old, this.resourceBundle);
    }

    protected void queryLanguageChanged(String oldLanguage, String newLanguage) {
        try {
            JRQueryExecuterFactory queryExecuterFactory;
            Object[] builtinParameters;
            if (oldLanguage != null && (builtinParameters = (queryExecuterFactory = JRQueryExecuterUtils.getQueryExecuterFactory(oldLanguage)).getBuiltinParameters()) != null) {
                this.removeBuiltinParameters(builtinParameters);
            }
            if (newLanguage != null && (builtinParameters = (queryExecuterFactory = JRQueryExecuterUtils.getQueryExecuterFactory(newLanguage)).getBuiltinParameters()) != null) {
                this.addBuiltinParameters(builtinParameters);
                this.sortSystemParamsFirst();
            }
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    private void sortSystemParamsFirst() {
        Collections.sort(this.parametersList, new Comparator(){

            public int compare(Object o1, Object o2) {
                JRParameter p1 = (JRParameter)o1;
                JRParameter p2 = (JRParameter)o2;
                boolean s1 = p1.isSystemDefined();
                boolean s2 = p2.isSystemDefined();
                return s1 ? (s2 ? 0 : -1) : (s2 ? 1 : 0);
            }
        });
    }

    private void removeBuiltinParameters(Object[] builtinParameters) {
        for (int i = 0; i < builtinParameters.length; i += 2) {
            String parameterName = (String)builtinParameters[i];
            JRParameter parameter = (JRParameter)this.parametersMap.get(parameterName);
            if (!parameter.isSystemDefined()) continue;
            this.removeParameter(parameter);
        }
    }

    public void setProperty(String propName, String value) {
        this.getPropertiesMap().setProperty(propName, value);
    }

    public void setFilterExpression(JRExpression expression) {
        JRExpression old = this.filterExpression;
        this.filterExpression = expression;
        this.getEventSupport().firePropertyChange(PROPERTY_FILTER_EXPRESSION, old, this.filterExpression);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.sortFieldsMap == null) {
            this.sortFieldsMap = new HashMap();
        }
        if (this.sortFieldsList == null) {
            this.sortFieldsList = new ArrayList();
        }
    }

    public Object clone() {
        int i;
        JRDesignDataset clone = (JRDesignDataset)super.clone();
        if (this.parametersList != null) {
            clone.parametersList = new ArrayList(this.parametersList.size());
            clone.parametersMap = new HashMap(this.parametersList.size());
            for (i = 0; i < this.parametersList.size(); ++i) {
                JRParameter parameter = (JRParameter)((JRParameter)this.parametersList.get(i)).clone();
                clone.parametersList.add(parameter);
                clone.parametersMap.put(parameter.getName(), parameter);
            }
        }
        if (this.fieldsList != null) {
            clone.fieldsList = new ArrayList(this.fieldsList.size());
            clone.fieldsMap = new HashMap(this.fieldsList.size());
            for (i = 0; i < this.fieldsList.size(); ++i) {
                JRField field = (JRField)((JRField)this.fieldsList.get(i)).clone();
                clone.fieldsList.add(field);
                clone.fieldsMap.put(field.getName(), field);
            }
        }
        if (this.sortFieldsList != null) {
            clone.sortFieldsList = new ArrayList(this.sortFieldsList.size());
            clone.sortFieldsMap = new HashMap(this.sortFieldsList.size());
            for (i = 0; i < this.sortFieldsList.size(); ++i) {
                JRSortField sortField = (JRSortField)((JRSortField)this.sortFieldsList.get(i)).clone();
                clone.sortFieldsList.add(sortField);
                clone.sortFieldsMap.put(sortField.getName(), sortField);
            }
        }
        if (this.variablesList != null) {
            clone.variablesList = new ArrayList(this.variablesList.size());
            clone.variablesMap = new HashMap(this.variablesList.size());
            for (i = 0; i < this.variablesList.size(); ++i) {
                JRVariable variable = (JRVariable)((JRVariable)this.variablesList.get(i)).clone();
                clone.variablesList.add(variable);
                clone.variablesMap.put(variable.getName(), variable);
            }
        }
        if (this.groupsList != null) {
            clone.groupsList = new ArrayList(this.groupsList.size());
            clone.groupsMap = new HashMap(this.groupsList.size());
            for (i = 0; i < this.groupsList.size(); ++i) {
                JRGroup group = (JRGroup)((JRGroup)this.groupsList.get(i)).clone();
                clone.groupsList.add(group);
                clone.groupsMap.put(group.getName(), group);
            }
        }
        return clone;
    }

    private class QueryLanguageChangeListener
    implements PropertyChangeListener,
    Serializable {
        private static final long serialVersionUID = 10200L;

        private QueryLanguageChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            JRDesignDataset.this.queryLanguageChanged((String)evt.getOldValue(), (String)evt.getNewValue());
        }
    }
}

