/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import javax.sql.DataSource;
import mondrian.olap.Connection;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.spi.CatalogLocator;

public class DriverManager {
    public static Connection getConnection(String connectString, CatalogLocator locator) {
        Util.PropertyList properties = Util.parseConnectString(connectString);
        return DriverManager.getConnection(properties, locator);
    }

    public static Connection getConnection(Util.PropertyList properties, CatalogLocator locator) {
        return DriverManager.getConnection(properties, locator, null);
    }

    public static Connection getConnection(Util.PropertyList properties, CatalogLocator locator, DataSource dataSource) {
        String provider = properties.get("PROVIDER", "mondrian");
        if (!provider.equalsIgnoreCase("mondrian")) {
            throw Util.newError("Provider not recognized: " + provider);
        }
        if (locator != null) {
            String catalog = properties.get(RolapConnectionProperties.Catalog.name());
            properties.put(RolapConnectionProperties.Catalog.name(), locator.locate(catalog));
        }
        return new RolapConnection(properties, dataSource);
    }
}

