/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.querybuilder;

import java.awt.Dialog;
import java.awt.Frame;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.ListIterator;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import nickyb.sqleonardo.common.util.I18n;
import nickyb.sqleonardo.querybuilder.BrowserItems;
import nickyb.sqleonardo.querybuilder.DiagramEntity;
import nickyb.sqleonardo.querybuilder.DiagramField;
import nickyb.sqleonardo.querybuilder.QueryBuilder;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;

public class DiagramLoader
extends JDialog
implements Runnable {
    public static final int DEFAULT = 0;
    public static final int ALL_FOREIGN_TABLES = 1;
    public static final int ALL_PRIMARY_TABLES = 2;
    private JLabel message;
    private int mode;
    private boolean autoJoinRequested;
    private QueryBuilder builder;
    private QueryTokens.Table table;

    private DiagramLoader(Frame owner) {
        super(owner);
    }

    private DiagramLoader(Dialog owner) {
        super(owner);
    }

    public static void run(int mode, QueryBuilder builder, QueryTokens.Table table, boolean autojoin) {
        DiagramLoader loader = null;
        if (SwingUtilities.getWindowAncestor(builder) instanceof Frame) {
            loader = new DiagramLoader((Frame)SwingUtilities.getWindowAncestor(builder));
        } else if (SwingUtilities.getWindowAncestor(builder) instanceof Dialog) {
            loader = new DiagramLoader((Dialog)SwingUtilities.getWindowAncestor(builder));
        }
        if (loader != null) {
            loader.setModal(true);
            loader.setSize(275, 55);
            loader.setTitle(I18n.getString("querybuilder.message.wait", "wait..."));
            loader.setResizable(false);
            loader.setLocationRelativeTo(builder);
            loader.setDefaultCloseOperation(0);
            loader.message = new JLabel("", 0);
            loader.getContentPane().add(loader.message);
            loader.autoJoinRequested = autojoin;
            loader.builder = builder;
            loader.table = table;
            loader.mode = mode;
            loader.show();
        }
    }

    public void show() {
        new Thread(this).start();
        super.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            switch (this.mode) {
                case 1: {
                    this.addAllForeignTables();
                    return;
                }
                case 2: {
                    this.addAllPrimaryTables();
                    return;
                }
                default: {
                    this.addTable(this.table);
                    return;
                }
            }
        }
        catch (SQLException sqle) {
            System.out.println("[ DiagramLoader::run ]\n" + sqle);
            return;
        }
        finally {
            this.dispose();
        }
    }

    private void addTable(QueryTokens.Table table) throws SQLException {
        this.message.setText(I18n.getFormattedString("querybuilder.message.loading", "Loading: {0}", new Object[]{"" + table.getIdentifier()}));
        this.checkTable(table);
        if ((QueryBuilder.autoAlias || this.builder.browser.getQueryItem() instanceof BrowserItems.DiagramQueryTreeItem) && table.getAlias() == null) {
            table.setAlias(table.getName());
            int i = 0;
            while (this.builder.diagram.getEntity(table) != null) {
                if (this.mode != 0) {
                    return;
                }
                table.setAlias(table.getName() + "_" + (char)(65 + i));
                ++i;
            }
        } else if (this.builder.diagram.getEntity(table) != null) {
            if (this.mode == 0) {
                this.setVisible(false);
                JOptionPane.showMessageDialog(this, I18n.getString("querybuilder.message.tableLoadedAliasDisabled", "Table already loaded and aliasing disabled!"), table.getIdentifier(), 2);
            }
            return;
        }
        DiagramEntity item = this.creatEntity(table);
        this.builder.diagram.addEntity(item);
        if (!this.builder.isLoading() && QueryBuilder.selectAllColumns) {
            item.setColumnSelections(true);
        }
        if (this.autoJoinRequested && QueryBuilder.autoJoin) {
            this.doAutoJoin(item);
        }
    }

    private void addTables(ResultSet rs, int rsSchemaIndex, int rsTableIndex) throws SQLException {
        ArrayList<QueryTokens.Table> list = new ArrayList<QueryTokens.Table>();
        while (rs.next()) {
            String schemaName = rs.getString(rsSchemaIndex);
            String tableName = rs.getString(rsTableIndex).trim();
            if (this.builder.getQueryModel().getSchema() != null) {
                schemaName = null;
            }
            if (schemaName != null) {
                schemaName = schemaName.trim();
            }
            list.add(new QueryTokens.Table(schemaName, tableName));
        }
        rs.close();
        ListIterator iter = list.listIterator();
        while (iter.hasNext()) {
            this.addTable((QueryTokens.Table)iter.next());
        }
    }

    private void addAllForeignTables() throws SQLException {
        DatabaseMetaData dbmd = this.builder.getConnection().getMetaData();
        this.message.setText(I18n.getString("querybuilder.message.reading", "reading..."));
        String schema = this.builder.getQueryModel().getSchema() == null ? this.table.getSchema() : this.builder.getQueryModel().getSchema();
        String catalog = schema == null ? null : dbmd.getConnection().getCatalog();
        this.addTables(dbmd.getExportedKeys(catalog, schema, this.table.getName()), 6, 7);
    }

    private void addAllPrimaryTables() throws SQLException {
        DatabaseMetaData dbmd = this.builder.getConnection().getMetaData();
        this.message.setText(I18n.getString("querybuilder.message.reading", "reading..."));
        String schema = this.builder.getQueryModel().getSchema() == null ? this.table.getSchema() : this.builder.getQueryModel().getSchema();
        String catalog = schema == null ? null : dbmd.getConnection().getCatalog();
        this.addTables(dbmd.getImportedKeys(catalog, schema, this.table.getName()), 2, 3);
    }

    private void checkTable(QueryTokens.Table table) throws SQLException {
        DatabaseMetaData dbmd = this.builder.getConnection().getMetaData();
        String name = table.getName();
        String schema = this.builder.getQueryModel().getSchema() == null ? table.getSchema() : this.builder.getQueryModel().getSchema();
        String catalog = schema == null ? null : dbmd.getConnection().getCatalog();
        ResultSet rs = dbmd.getTables(catalog, schema, name, null);
        boolean exists = rs.next();
        rs.close();
        if (!exists) {
            if (dbmd.storesLowerCaseIdentifiers()) {
                name = name != null ? name.toLowerCase() : null;
                schema = schema != null ? schema.toLowerCase() : null;
                catalog = catalog != null ? catalog.toLowerCase() : null;
            } else if (dbmd.storesUpperCaseIdentifiers()) {
                name = name != null ? name.toUpperCase() : null;
                schema = schema != null ? schema.toUpperCase() : null;
                catalog = catalog != null ? catalog.toUpperCase() : null;
            }
            rs = dbmd.getTables(catalog, schema, name, null);
            exists = rs.next();
            if (exists) {
                table.setName(name);
                if (this.builder.getQueryModel().getSchema() == null) {
                    table.setSchema(schema);
                }
            }
            rs.close();
        }
    }

    private DiagramEntity creatEntity(QueryTokens.Table table) throws SQLException {
        DiagramEntity item = new DiagramEntity(this.builder, table);
        item.setEnabled(this.builder.getConnection() != null);
        if (this.builder.getConnection() != null) {
            DatabaseMetaData dbmetadata = this.builder.getConnection().getMetaData();
            Hashtable primary = this.getPrimaryKeys(dbmetadata, item);
            String name = item.getQueryToken().getName();
            String schema = this.builder.getQueryModel().getSchema() == null ? item.getQueryToken().getSchema() : this.builder.getQueryModel().getSchema();
            String catalog = schema == null ? null : dbmetadata.getConnection().getCatalog();
            ResultSet rsColumns = dbmetadata.getColumns(catalog, schema, name, "%");
            while (rsColumns.next()) {
                String columnName = rsColumns.getString(4).trim();
                String typeName = rsColumns.getString(6);
                int size = rsColumns.getInt(7);
                int pos = rsColumns.getInt(17);
                DiagramField field = item.addField(pos, columnName, primary.get(columnName));
                field.setToolTipText(columnName + " : " + typeName + "(" + size + ")");
            }
            rsColumns.close();
        }
        item.pack();
        return item;
    }

    private Hashtable getPrimaryKeys(DatabaseMetaData dbmetadata, DiagramEntity item) {
        Hashtable<String, String> primary = new Hashtable<String, String>();
        try {
            String name = item.getQueryToken().getName();
            String schema = this.builder.getQueryModel().getSchema() == null ? item.getQueryToken().getSchema() : this.builder.getQueryModel().getSchema();
            String catalog = schema == null ? null : dbmetadata.getConnection().getCatalog();
            ResultSet rsPK = dbmetadata.getPrimaryKeys(catalog, schema, name);
            while (rsPK.next()) {
                primary.put(rsPK.getString(4).trim(), rsPK.getString(6));
            }
            rsPK.close();
        }
        catch (SQLException sqle) {
            System.out.println("[ DiagramLoader::getPrimaryKeys ]\n" + sqle);
        }
        return primary;
    }

    private void doAutoJoin(DiagramEntity source) throws SQLException {
        if (this.builder.diagram.getEntities().length > 1) {
            DatabaseMetaData dbmetadata = this.builder.getConnection().getMetaData();
            String name = source.getQueryToken().getName();
            String schema = this.builder.getQueryModel().getSchema() == null ? source.getQueryToken().getSchema() : this.builder.getQueryModel().getSchema();
            String catalog = schema == null ? null : dbmetadata.getConnection().getCatalog();
            this.message.setText(I18n.getFormattedString("querybuilder.message.loading.relations", "check {0}'s relations ", new Object[]{"" + this.table.getIdentifier()}));
            this.join(dbmetadata.getImportedKeys(catalog, schema, name), source, false);
            this.join(dbmetadata.getExportedKeys(catalog, schema, name), source, true);
        }
    }

    private void join(ResultSet rs, DiagramEntity source, boolean ispk) throws SQLException {
        while (rs.next()) {
            DiagramEntity itemF;
            String pkschema = rs.getString(2);
            String pktable = rs.getString(3).trim();
            String pkcolumn = rs.getString(4).trim();
            String fkschema = rs.getString(6);
            String fktable = rs.getString(7).trim();
            String fkcolumn = rs.getString(8).trim();
            String fkname = rs.getString(12);
            if (this.builder.getQueryModel().getSchema() != null) {
                fkschema = null;
                pkschema = null;
            }
            if (pkschema != null) {
                pkschema = pkschema.trim();
            }
            if (fkschema != null) {
                fkschema = fkschema.trim();
            }
            DiagramEntity itemP = ispk ? source : this.builder.diagram.getEntity(pkschema, pktable);
            DiagramEntity diagramEntity = itemF = ispk ? this.builder.diagram.getEntity(fkschema, fktable) : source;
            if (itemP == null || itemF == null || itemP.getQueryToken().toString().equalsIgnoreCase(itemF.getQueryToken().toString())) continue;
            DiagramField fP = itemP.getField(pkcolumn, true);
            DiagramField fF = itemF.getField(fkcolumn, true);
            this.builder.diagram.join(itemP, fP, itemF, fF);
            this.builder.diagram.getRelations()[this.builder.diagram.getRelationCount() - 1].setName(fkname);
        }
        rs.close();
    }
}

