/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.querybuilder;

import java.awt.Dialog;
import java.awt.Frame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import nickyb.sqleonardo.common.gui.BorderLayoutPanel;
import nickyb.sqleonardo.querybuilder.BaseMask;
import nickyb.sqleonardo.querybuilder.BrowserItems;
import nickyb.sqleonardo.querybuilder.QueryBuilder;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;

public class MaskExpression
extends BaseMask {
    private QueryTokens.DefaultExpression querytoken;
    private JTextArea value;
    private JTextField alias;

    public MaskExpression(QueryTokens.DefaultExpression token, QueryBuilder builder) {
        super("expression.edit", builder);
        this.querytoken = token;
        BorderLayoutPanel north = new BorderLayoutPanel(2, 2);
        north.setComponentWest(new JLabel("Alias:"));
        this.alias = new JTextField();
        north.setComponentCenter(this.alias);
        this.setComponentNorth(north);
        this.value = new JTextArea();
        this.setComponentCenter(new JScrollPane(this.value));
        this.value.setWrapStyleWord(true);
        this.value.setLineWrap(true);
        this.value.setColumns(45);
        this.value.setRows(10);
    }

    protected boolean onConfirm() {
        if (this.builder.browser.getQueryItem() instanceof BrowserItems.DiagramQueryTreeItem && (this.alias.getText() == null || this.alias.getText().trim().length() == 0)) {
            String message = "Please, set a valid alias.";
            if (SwingUtilities.getWindowAncestor(this.builder) instanceof Frame) {
                JOptionPane.showMessageDialog((Frame)SwingUtilities.getWindowAncestor(this.builder), message, "SQLeonardo", 2);
            } else if (SwingUtilities.getWindowAncestor(this.builder) instanceof Dialog) {
                JOptionPane.showMessageDialog((Dialog)SwingUtilities.getWindowAncestor(this.builder), message, "SQLeonardo", 2);
            }
            return false;
        }
        this.querytoken.setValue(this.value.getText());
        this.querytoken.setAlias(this.alias.getText());
        return true;
    }

    protected void onShow() {
        if (!this.querytoken.isEmpty()) {
            this.value.setText(this.querytoken.getValue());
        }
        if (this.querytoken.isAliasSet()) {
            this.alias.setText(this.querytoken.getAlias());
        }
    }
}

