/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import org.jfree.chart.plot.PlotOrientation;

public abstract class JRBaseChartPlot
implements JRChartPlot,
Serializable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_BACKCOLOR = "backcolor";
    public static final String PROPERTY_BACKGROUND_ALPHA = "backgroundAlpha";
    public static final String PROPERTY_FOREGROUND_ALPHA = "foregroundAlpha";
    public static final String PROPERTY_LABEL_ROTATION = "labelRotation";
    public static final String PROPERTY_ORIENTATION = "orientation";
    public static final String PROPERTY_SERIES_COLORS = "seriesColors";
    protected JRChart chart;
    protected Color backcolor;
    protected PlotOrientation orientation = PlotOrientation.VERTICAL;
    protected Float backgroundAlphaFloat;
    protected Float foregroundAlphaFloat;
    protected Double labelRotationDouble;
    protected SortedSet seriesColors;
    private transient JRPropertyChangeSupport eventSupport;
    private int PSEUDO_SERIAL_VERSION_UID = 40002;
    private float backgroundAlpha = 1.0f;
    private float foregroundAlpha = 1.0f;
    private double labelRotation = 0.0;

    protected JRBaseChartPlot(JRChartPlot plot, JRChart chart) {
        this.chart = chart;
        if (plot != null) {
            this.backcolor = plot.getOwnBackcolor();
            this.orientation = plot.getOrientation();
            this.backgroundAlphaFloat = plot.getBackgroundAlphaFloat();
            this.foregroundAlphaFloat = plot.getForegroundAlphaFloat();
            this.labelRotationDouble = plot.getLabelRotationDouble();
            this.seriesColors = new TreeSet(plot.getSeriesColors());
        } else {
            this.seriesColors = new TreeSet();
        }
    }

    protected JRBaseChartPlot(JRChartPlot plot, JRBaseObjectFactory factory) {
        factory.put(plot, this);
        this.chart = (JRChart)factory.getVisitResult(plot.getChart());
        this.backcolor = plot.getOwnBackcolor();
        this.orientation = plot.getOrientation();
        this.backgroundAlphaFloat = plot.getBackgroundAlphaFloat();
        this.foregroundAlphaFloat = plot.getForegroundAlphaFloat();
        this.labelRotationDouble = plot.getLabelRotationDouble();
        this.seriesColors = new TreeSet(plot.getSeriesColors());
    }

    public JRChart getChart() {
        return this.chart;
    }

    public Color getBackcolor() {
        return JRStyleResolver.getBackcolor(this);
    }

    public Color getOwnBackcolor() {
        return this.backcolor;
    }

    public void setBackcolor(Color backcolor) {
        Color old = this.backcolor;
        this.backcolor = backcolor;
        this.getEventSupport().firePropertyChange(PROPERTY_BACKCOLOR, old, this.backcolor);
    }

    public PlotOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(PlotOrientation orientation) {
        PlotOrientation old = this.orientation;
        this.orientation = orientation;
        this.getEventSupport().firePropertyChange(PROPERTY_ORIENTATION, old, this.orientation);
    }

    public float getBackgroundAlpha() {
        return this.backgroundAlphaFloat == null ? 1.0f : this.backgroundAlphaFloat.floatValue();
    }

    public void setBackgroundAlpha(float backgroundAlpha) {
        this.setBackgroundAlpha(new Float(backgroundAlpha));
    }

    public float getForegroundAlpha() {
        return this.foregroundAlphaFloat == null ? 1.0f : this.foregroundAlphaFloat.floatValue();
    }

    public void setForegroundAlpha(float foregroundAlpha) {
        this.setForegroundAlpha(new Float(foregroundAlpha));
    }

    public double getLabelRotation() {
        return this.labelRotationDouble == null ? 0.0 : this.labelRotationDouble;
    }

    public void setLabelRotation(double labelRotation) {
        this.setLabelRotation(new Double(labelRotation));
    }

    public Float getBackgroundAlphaFloat() {
        return this.backgroundAlphaFloat;
    }

    public void setBackgroundAlpha(Float backgroundAlpha) {
        Float old = this.backgroundAlphaFloat;
        this.backgroundAlphaFloat = backgroundAlpha;
        this.getEventSupport().firePropertyChange(PROPERTY_BACKGROUND_ALPHA, old, this.backgroundAlphaFloat);
    }

    public Float getForegroundAlphaFloat() {
        return this.foregroundAlphaFloat;
    }

    public void setForegroundAlpha(Float foregroundAlpha) {
        Float old = this.foregroundAlphaFloat;
        this.foregroundAlphaFloat = foregroundAlpha;
        this.getEventSupport().firePropertyChange(PROPERTY_FOREGROUND_ALPHA, old, this.foregroundAlphaFloat);
    }

    public Double getLabelRotationDouble() {
        return this.labelRotationDouble;
    }

    public void setLabelRotation(Double labelRotation) {
        Double old = this.labelRotationDouble;
        this.labelRotationDouble = labelRotation;
        this.getEventSupport().firePropertyChange(PROPERTY_LABEL_ROTATION, old, this.labelRotationDouble);
    }

    public SortedSet getSeriesColors() {
        return this.seriesColors;
    }

    public void clearSeriesColors() {
        this.setSeriesColors(null);
    }

    public void addSeriesColor(JRChartPlot.JRSeriesColor seriesColor) {
        this.seriesColors.add(seriesColor);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_SERIES_COLORS, seriesColor, this.seriesColors.size() - 1);
    }

    public void setSeriesColors(Collection colors) {
        TreeSet old = new TreeSet(this.seriesColors);
        this.seriesColors.clear();
        if (colors != null) {
            this.seriesColors.addAll(colors);
        }
        this.getEventSupport().firePropertyChange(PROPERTY_SERIES_COLORS, old, this.seriesColors);
    }

    public Object clone() {
        JRBaseChartPlot clone = null;
        try {
            clone = (JRBaseChartPlot)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        if (this.seriesColors != null) {
            clone.seriesColors = new TreeSet();
            Iterator it = this.seriesColors.iterator();
            while (it.hasNext()) {
                clone.seriesColors.add(((JRChartPlot.JRSeriesColor)it.next()).clone());
            }
        }
        return clone;
    }

    public Object clone(JRChart parentChart) {
        JRBaseChartPlot clone = (JRBaseChartPlot)this.clone();
        clone.chart = parentChart;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRBaseChartPlot jRBaseChartPlot = this;
        synchronized (jRBaseChartPlot) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30103) {
            this.backgroundAlphaFloat = new Float(this.backgroundAlpha);
            this.foregroundAlphaFloat = new Float(this.foregroundAlpha);
            this.labelRotationDouble = new Double(this.labelRotation);
        }
    }

    public static class JRBaseSeriesColor
    implements JRChartPlot.JRSeriesColor,
    Serializable,
    Comparable {
        private static final long serialVersionUID = 10200L;
        protected int seriesOrder = -1;
        protected Color color;

        public JRBaseSeriesColor(int seriesOrder, Color color) {
            this.seriesOrder = seriesOrder;
            this.color = color;
        }

        public int getSeriesOrder() {
            return this.seriesOrder;
        }

        public Color getColor() {
            return this.color;
        }

        public int compareTo(Object obj) {
            if (obj == null) {
                throw new IllegalArgumentException();
            }
            return this.seriesOrder - ((JRBaseSeriesColor)obj).getSeriesOrder();
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new JRRuntimeException(e);
            }
        }
    }
}

