/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.design.JRDesignGraphicElement;
import net.sf.jasperreports.engine.type.LineDirectionEnum;

public class JRDesignLine
extends JRDesignGraphicElement
implements JRLine {
    private static final long serialVersionUID = 10200L;
    protected LineDirectionEnum directionValue = LineDirectionEnum.TOP_DOWN;
    private int PSEUDO_SERIAL_VERSION_UID = 40002;
    private byte direction;

    public JRDesignLine() {
        super(null);
    }

    public JRDesignLine(JRDefaultStyleProvider defaultStyleProvider) {
        super(defaultStyleProvider);
    }

    public void setWidth(int width) {
        if (width == 0) {
            width = 1;
        }
        super.setWidth(width);
    }

    public void setHeight(int height) {
        if (height == 0) {
            height = 1;
        }
        super.setHeight(height);
    }

    public byte getDirection() {
        return this.getDirectionValue().getValue();
    }

    public void setDirection(byte direction) {
        this.setDirection(LineDirectionEnum.getByValue(direction));
    }

    public LineDirectionEnum getDirectionValue() {
        return this.directionValue;
    }

    public void setDirection(LineDirectionEnum directionValue) {
        LineDirectionEnum old = this.directionValue;
        this.directionValue = directionValue;
        this.getEventSupport().firePropertyChange("direction", old, this.directionValue);
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public void visit(JRVisitor visitor) {
        visitor.visitLine(this);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.directionValue = LineDirectionEnum.getByValue(this.direction);
        }
    }
}

