/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.resgen;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import org.apache.tools.ant.BuildException;
import org.eigenbase.resgen.AbstractJavaGenerator;
import org.eigenbase.resgen.Generator;
import org.eigenbase.resgen.JavaBaseGenerator;
import org.eigenbase.resgen.JavaFunctorBaseGenerator;
import org.eigenbase.resgen.JavaLocaleGenerator;
import org.eigenbase.resgen.ResourceDef;
import org.eigenbase.resgen.ResourceGen;
import org.eigenbase.resgen.ResourceGenTask;
import org.eigenbase.resgen.Util;

abstract class FileTask {
    ResourceGenTask.Include include;
    String className;
    String fileName;
    String cppClassName;
    boolean outputJava;
    boolean outputCpp;

    FileTask() {
    }

    abstract void process(ResourceGen var1) throws IOException;

    File getFile() {
        return new File(this.include.root.src, this.fileName);
    }

    String getFileForComments() {
        int n;
        String string = this.getFile().toString().replace('\\', '/');
        if (this.include.root.commentStyle == 2 && (n = string.lastIndexOf(47)) > 0) {
            string = "..." + string.substring(n);
        }
        return string;
    }

    boolean checkUpToDate(ResourceGen resourceGen, File file) {
        if (file.exists() && file.lastModified() >= this.getFile().lastModified()) {
            resourceGen.comment(file + " is up to date");
            return true;
        }
        return false;
    }

    void makeParentDirs(File file) {
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
    }

    private String getPackageName() {
        int n = this.className.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        return this.className.substring(0, n);
    }

    private File getPackageDirectory(File file) {
        String string = this.getPackageName();
        if (string == null) {
            return file;
        }
        return new File(file, string.replace('.', Util.fileSep));
    }

    File getSrcDirectory() {
        return this.getPackageDirectory(this.include.root.src);
    }

    File getDestDirectory() {
        return this.getPackageDirectory(this.include.root.dest);
    }

    File getResourceDirectory() {
        return this.getPackageDirectory(this.include.root.res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void generateJava(ResourceGen resourceGen, ResourceDef.ResourceBundle resourceBundle, Locale locale) {
        FileOutputStream fileOutputStream;
        String string = Util.getClassNameSansPackage(this.className, locale) + ".java";
        File file = new File(this.getDestDirectory(), string);
        if (!this.include.root.force && this.checkUpToDate(resourceGen, file)) {
            return;
        }
        resourceGen.comment("Generating " + file);
        try {
            this.makeParentDirs(file);
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new BuildException("Error while writing " + file, (Throwable)fileNotFoundException);
        }
        PrintWriter printWriter = new PrintWriter(fileOutputStream);
        try {
            AbstractJavaGenerator abstractJavaGenerator;
            block13: {
                block12: {
                    if (locale != null) break block12;
                    String string2 = this.include.baseClassName;
                    if (string2 == null) {
                        string2 = "org.eigenbase.resgen.ShadowResourceBundle";
                    }
                    switch (this.include.root.style) {
                        case 1: {
                            abstractJavaGenerator = new JavaBaseGenerator(this.getFile(), file, this.className, string2, resourceBundle);
                            break block13;
                        }
                        case 2: {
                            abstractJavaGenerator = new JavaFunctorBaseGenerator(this.getFile(), file, this.className, string2, resourceBundle);
                            break block13;
                        }
                        default: {
                            throw new AssertionError((Object)("unexpected style " + this.include.root.style));
                        }
                    }
                }
                String string3 = this.className + "_" + locale.toString();
                String string4 = this.className;
                abstractJavaGenerator = new JavaLocaleGenerator(this.getFile(), file, string3, resourceBundle, locale, string4);
            }
            this.configureCommentStyle(abstractJavaGenerator);
            abstractJavaGenerator.generateModule(resourceGen, resourceBundle, printWriter);
        }
        finally {
            printWriter.close();
        }
    }

    protected void configureCommentStyle(Generator generator) {
        switch (this.include.root.commentStyle) {
            case 1: {
                generator.setScmSafeComments(false);
                break;
            }
            case 2: {
                generator.setScmSafeComments(true);
                break;
            }
            default: {
                throw new AssertionError((Object)("unexpected comment style " + this.include.root.commentStyle));
            }
        }
    }
}

