/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.util.List;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataViewPageContext {
    private int pageSize = 10;
    private int totalRows = -1;
    private int currentPos = 1;
    private List<Object[]> rows;

    DataViewPageContext(int n) {
        this.pageSize = n;
    }

    int getPageSize() {
        return this.pageSize;
    }

    int getCurrentPos() {
        return this.currentPos;
    }

    List<Object[]> getCurrentRows() {
        return this.rows;
    }

    int getTotalRows() {
        return this.totalRows;
    }

    boolean hasRows() {
        return this.totalRows != 0 && this.pageSize != 0;
    }

    boolean hasNext() {
        return this.currentPos + this.pageSize <= this.totalRows && this.hasRows();
    }

    boolean hasOnePageOnly() {
        return this.currentPos - this.pageSize <= 0;
    }

    boolean hasPrevious() {
        return this.currentPos - this.pageSize >= 0 && this.hasRows();
    }

    void first() {
        this.currentPos = 1;
    }

    void previous() {
        this.currentPos -= this.pageSize;
    }

    void next() {
        this.currentPos += this.pageSize;
    }

    void last() {
        if (this.pageSize < 1) {
            return;
        }
        int n = this.totalRows % this.pageSize;
        this.currentPos = this.totalRows - (n == 0 ? this.pageSize : n) + 1;
    }

    boolean isLastPage() {
        return this.currentPos + this.pageSize > this.totalRows;
    }

    boolean refreshRequiredOnInsert() {
        return this.isLastPage() && this.rows.size() <= this.pageSize;
    }

    boolean hasDataRows() {
        return this.rows != null && !this.rows.isEmpty();
    }

    String pageOf() {
        if (this.pageSize < 1 || this.totalRows < 1) {
            return "";
        }
        Integer n = this.currentPos / this.pageSize + (this.pageSize == 1 ? 0 : 1);
        Integer n2 = this.totalRows / this.pageSize + (this.totalRows % this.pageSize > 0 ? 1 : 0);
        return NbBundle.getMessage(DataViewPageContext.class, (String)"LBL_page_of", (Object)n, (Object)n2);
    }

    synchronized void setPageSize(int n) {
        this.pageSize = n;
    }

    synchronized void setTotalRows(int n) {
        this.totalRows = n;
    }

    synchronized void decrementRowSize(int n) {
        this.totalRows -= n;
        if (this.totalRows <= this.pageSize) {
            this.first();
        } else if (this.currentPos > this.totalRows) {
            this.previous();
        }
    }

    synchronized void setCurrentRows(List<Object[]> list) {
        this.rows = list;
    }
}

