/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.PrintWriter;
import java.io.StringWriter;
import mondrian.mdx.QueryPrintWriter;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.AxisOrdinal;
import mondrian.olap.Connection;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.Id;
import mondrian.olap.Parser;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.QueryPart;
import mondrian.olap.Util;
import mondrian.olap.fun.BuiltinFunTable;
import mondrian.test.FoodMartTestCase;
import mondrian.test.TestContext;

public class ParserTest
extends FoodMartTestCase {
    static final BuiltinFunTable funTable = BuiltinFunTable.instance();

    public ParserTest(String name) {
        super(name);
    }

    public void testAxisParsing() throws Exception {
        this.checkAxisAllWays(0, "COLUMNS");
        this.checkAxisAllWays(1, "ROWS");
        this.checkAxisAllWays(2, "PAGES");
        this.checkAxisAllWays(3, "CHAPTERS");
        this.checkAxisAllWays(4, "SECTIONS");
    }

    private void checkAxisAllWays(int axisOrdinal, String axisName) {
        this.checkAxis(axisOrdinal + "", axisName);
        this.checkAxis("AXIS(" + axisOrdinal + ")", axisName);
        this.checkAxis(axisName, axisName);
    }

    private void checkAxis(String s, String expectedName) {
        TestParser p = new TestParser();
        String q = "select [member] on " + s + " from [cube]";
        Query query = p.parseInternal(null, q, false, funTable, false, false);
        ParserTest.assertNull((String)"Test parser should return null query", (Object)query);
        QueryAxis[] axes = p.getAxes();
        ParserTest.assertEquals((String)"Number of axes must be 1", (int)1, (int)axes.length);
        ParserTest.assertEquals((String)"Axis index name must be correct", (String)expectedName, (String)axes[0].getAxisName());
    }

    public void testNegativeCases() throws Exception {
        this.assertParseQueryFails("select [member] on axis(1.7) from sales", "Invalid axis specification. The axis number must be non-negative integer, but it was 1.7.");
        this.assertParseQueryFails("select [member] on axis(-1) from sales", "Syntax error at line");
        this.assertParseQuery("select [member] on axis(5) from sales", ParserTest.fold("select [member] ON AXIS(5)\nfrom [sales]\n"));
        this.assertParseQueryFails("select [member] on axes(0) from sales", "Syntax error at line");
        this.assertParseQueryFails("select [member] on 0.5 from sales", "Invalid axis specification. The axis number must be non-negative integer, but it was 0.5.");
        this.assertParseQuery("select [member] on 555 from sales", ParserTest.fold("select [member] ON AXIS(555)\nfrom [sales]\n"));
    }

    public void testScannerPunc() {
        this.assertParseQuery("select [measures].[$foo] on columns from sales", TestContext.fold("select [measures].[$foo] ON COLUMNS\nfrom [sales]\n"));
        this.assertParseQueryFails("select [measures].$foo on columns from sales", "Unexpected character '$'");
        this.assertParseQueryFails("select { Customers].Children } on columns from [Sales]", "Unexpected character ']'");
    }

    public void testUnparse() {
        this.checkUnparse(TestContext.fold("with member [Measures].[Foo] as ' 123 '\nselect {[Measures].members} on columns,\n CrossJoin([Product].members, {[Gender].Children}) on rows\nfrom [Sales]\nwhere [Marital Status].[S]"), TestContext.fold("with member [Measures].[Foo] as '123.0'\nselect {[Measures].Members} ON COLUMNS,\n  Crossjoin([Product].Members, {[Gender].Children}) ON ROWS\nfrom [Sales]\nwhere [Marital Status].[All Marital Status].[S]\n"));
    }

    private void checkUnparse(String queryString, String expected) {
        TestContext testContext = TestContext.instance();
        Query query = testContext.getConnection().parseQuery(queryString);
        String unparsedQueryString = Util.unparse(query);
        TestContext.assertEqualsVerbose(expected, unparsedQueryString);
    }

    private void assertParseQueryFails(String query, String expected) {
        this.checkFails(new TestParser(), query, expected);
    }

    private void assertParseExprFails(String expr, String expected) {
        this.checkFails(new TestParser(), this.wrapExpr(expr), expected);
    }

    private void checkFails(Parser p, String query, String expected) {
        block2: {
            try {
                p.parseInternal(null, query, false, funTable, false, false);
                ParserTest.fail((String)"Must return an error");
            }
            catch (Exception e) {
                Exception nested = (Exception)e.getCause();
                String message = nested.getMessage();
                if (message.indexOf(expected) >= 0) break block2;
                ParserTest.fail((String)("Actual result [" + message + "] did not contain [" + expected + "]"));
            }
        }
    }

    public void testMultipleAxes() throws Exception {
        TestParser p = new TestParser();
        String query = "select {[axis0mbr]} on axis(0), {[axis1mbr]} on axis(1) from cube";
        ParserTest.assertNull((String)"Test parser should return null query", (Object)p.parseInternal(null, query, false, funTable, false, false));
        QueryAxis[] axes = p.getAxes();
        ParserTest.assertEquals((String)"Number of axes", (int)2, (int)axes.length);
        ParserTest.assertEquals((String)"Axis index name must be correct", (String)AxisOrdinal.StandardAxisOrdinal.forLogicalOrdinal(0).name(), (String)axes[0].getAxisName());
        ParserTest.assertEquals((String)"Axis index name must be correct", (String)AxisOrdinal.StandardAxisOrdinal.forLogicalOrdinal(1).name(), (String)axes[1].getAxisName());
        query = "select {[axis1mbr]} on aXiS(1), {[axis0mbr]} on AxIs(0) from cube";
        ParserTest.assertNull((String)"Test parser should return null query", (Object)p.parseInternal(null, query, false, funTable, false, false));
        ParserTest.assertEquals((String)"Number of axes", (int)2, (int)axes.length);
        ParserTest.assertEquals((String)"Axis index name must be correct", (String)AxisOrdinal.StandardAxisOrdinal.forLogicalOrdinal(0).name(), (String)axes[0].getAxisName());
        ParserTest.assertEquals((String)"Axis index name must be correct", (String)AxisOrdinal.StandardAxisOrdinal.forLogicalOrdinal(1).name(), (String)axes[1].getAxisName());
        Exp colsSetExpr = axes[0].getSet();
        ParserTest.assertNotNull((String)"Column tuples", (Object)colsSetExpr);
        UnresolvedFunCall fun = (UnresolvedFunCall)colsSetExpr;
        Id.Segment id = ((Id)fun.getArgs()[0]).getElement(0);
        ParserTest.assertEquals((String)"Correct member on axis", (String)"axis0mbr", (String)id.name);
        Exp rowsSetExpr = axes[1].getSet();
        ParserTest.assertNotNull((String)"Row tuples", (Object)rowsSetExpr);
        fun = (UnresolvedFunCall)rowsSetExpr;
        id = ((Id)fun.getArgs()[0]).getElement(0);
        ParserTest.assertEquals((String)"Correct member on axis", (String)"axis1mbr", (String)id.name);
    }

    public void testMemberOnAxis() {
        this.assertParseQuery("select [Measures].[Sales Count] on 0, non empty [Store].[Store State].members on 1 from [Sales]", TestContext.fold("select [Measures].[Sales Count] ON COLUMNS,\n  NON EMPTY [Store].[Store State].members ON ROWS\nfrom [Sales]\n"));
    }

    public void testCaseTest() {
        this.assertParseQuery("with member [Measures].[Foo] as  ' case when x = y then \"eq\" when x < y then \"lt\" else \"gt\" end 'select {[foo]} on axis(0) from cube", TestContext.fold("with member [Measures].[Foo] as 'CASE WHEN (x = y) THEN \"eq\" WHEN (x < y) THEN \"lt\" ELSE \"gt\" END'\nselect {[foo]} ON COLUMNS\nfrom [cube]\n"));
    }

    public void testCaseSwitch() {
        this.assertParseQuery("with member [Measures].[Foo] as  ' case x when 1 then 2 when 3 then 4 else 5 end 'select {[foo]} on axis(0) from cube", TestContext.fold("with member [Measures].[Foo] as 'CASE x WHEN 1.0 THEN 2.0 WHEN 3.0 THEN 4.0 ELSE 5.0 END'\nselect {[foo]} ON COLUMNS\nfrom [cube]\n"));
    }

    public void testSetExpr() {
        this.assertParseQuery("with set [Set1] as '[Product].[Drink]:[Product].[Food]' \nselect [Set1] on columns, {[Measures].defaultMember} on rows \nfrom Sales", TestContext.fold("with set [Set1] as '([Product].[Drink] : [Product].[Food])'\nselect [Set1] ON COLUMNS,\n  {[Measures].defaultMember} ON ROWS\nfrom [Sales]\n"));
        this.assertParseQuery("select [Product].[Drink]:[Product].[Food] on columns,\n {[Measures].defaultMember} on rows \nfrom Sales", TestContext.fold("select ([Product].[Drink] : [Product].[Food]) ON COLUMNS,\n  {[Measures].defaultMember} ON ROWS\nfrom [Sales]\n"));
    }

    public void testDimensionProperties() {
        this.assertParseQuery("select {[foo]} properties p1,   p2 on columns from [cube]", TestContext.fold("select {[foo]} DIMENSION PROPERTIES p1, p2 ON COLUMNS\nfrom [cube]\n"));
    }

    public void testCellProperties() {
        this.assertParseQuery("select {[foo]} on columns from [cube] CELL PROPERTIES FORMATTED_VALUE", TestContext.fold("select {[foo]} ON COLUMNS\nfrom [cube]\n[FORMATTED_VALUE]"));
    }

    public void testIsEmpty() {
        this.assertParseExpr("[Measures].[Unit Sales] IS EMPTY", "([Measures].[Unit Sales] IS EMPTY)");
        this.assertParseExpr("[Measures].[Unit Sales] IS EMPTY AND 1 IS NULL", "(([Measures].[Unit Sales] IS EMPTY) AND (1.0 IS NULL))");
        this.assertParseExpr("- x * 5 is empty is empty is null + 56", "(((((- x) * 5.0) IS EMPTY) IS EMPTY) IS (NULL + 56.0))");
    }

    public void testIs() {
        this.assertParseExpr("[Measures].[Unit Sales] IS [Measures].[Unit Sales] AND [Measures].[Unit Sales] IS NULL", "(([Measures].[Unit Sales] IS [Measures].[Unit Sales]) AND ([Measures].[Unit Sales] IS NULL))");
    }

    public void testIsNull() {
        this.assertParseExpr("[Measures].[Unit Sales] IS NULL", "([Measures].[Unit Sales] IS NULL)");
        this.assertParseExpr("[Measures].[Unit Sales] IS NULL AND 1 <> 2", "(([Measures].[Unit Sales] IS NULL) AND (1.0 <> 2.0))");
        this.assertParseExpr("x is null or y is null and z = 5", "((x IS NULL) OR ((y IS NULL) AND (z = 5.0)))");
        this.assertParseExpr("(x is null) + 56 > 6", "((((x IS NULL)) + 56.0) > 6.0)");
        this.assertParseExpr("x is null and a = b or c = d + 5 is null + 5", "(((x IS NULL) AND (a = b)) OR ((c = (d + 5.0)) IS (NULL + 5.0)))");
    }

    public void testNull() {
        this.assertParseExpr("Filter({[Measures].[Foo]}, Iif(1 = 2, NULL, 'X'))", "Filter({[Measures].[Foo]}, Iif((1.0 = 2.0), NULL, \"X\"))");
    }

    public void testCast() {
        this.assertParseExpr("Cast([Measures].[Unit Sales] AS Numeric)", "CAST([Measures].[Unit Sales] AS Numeric)");
        this.assertParseExpr("Cast(1 + 2 AS String)", "CAST((1.0 + 2.0) AS String)");
    }

    public void testMultiplication() {
        Parser p = new Parser();
        String mdx = this.wrapExpr("([Measures].[Unit Sales] * [Measures].[Store Cost] * [Measures].[Store Sales])");
        try {
            Query query = p.parseInternal(this.getConnection(), mdx, false, funTable, false, false);
            query.resolve();
        }
        catch (Throwable e) {
            ParserTest.fail((String)e.getMessage());
        }
    }

    public void testBangFunction() {
        this.assertParseExpr("foo!bar!Exp(2.0)", "Exp(2.0)");
        this.assertParseExpr("1 + VBA!Exp(2.0 + 3)", "(1.0 + Exp((2.0 + 3.0)))");
    }

    public void testId() {
        this.assertParseExpr("foo", "foo");
        this.assertParseExpr("fOo", "fOo");
        this.assertParseExpr("[Foo].[Bar Baz]", "[Foo].[Bar Baz]");
        this.assertParseExpr("[Foo].&[Bar]", "[Foo].&[Bar]");
    }

    public void testCloneQuery() {
        Connection connection = TestContext.instance().getFoodMartConnection();
        Query query = connection.parseQuery("select {[Measures].Members} on columns,\n {[Store].Members} on rows\nfrom [Sales]\nwhere ([Gender].[M])");
        Object queryClone = query.clone();
        ParserTest.assertTrue((boolean)(queryClone instanceof Query));
        ParserTest.assertEquals((String)query.toString(), (String)queryClone.toString());
    }

    public void testNumbers() {
        this.assertParseExpr("2", "2.0");
        this.assertParseExpr("-3", "(- 3.0)");
        this.assertParseExpr("+45", "45.0");
        this.assertParseExprFails("4 5", "Syntax error at line 1, column 35, token '5.0'");
        this.assertParseExpr("3.14", "3.14");
        this.assertParseExpr(".12345", "0.12345");
        this.assertParseExpr("31415926535.89793", "3.141592653589793E10");
        this.assertParseExpr("31415926535897.9314159265358979", "3.141592653589793E13");
        this.assertParseExpr("3.141592653589793", "3.141592653589793");
        this.assertParseExpr("-3141592653589793.14159265358979", "(- 3.141592653589793E15)");
        this.assertParseExpr("1e2", "100.0");
        this.assertParseExprFails("1e2e3", "Syntax error at line 1, column 37, token 'e3'");
        this.assertParseExpr("1.2e3", "1200.0");
        this.assertParseExpr("-1.2345e3", "(- 1234.5)");
        this.assertParseExprFails("1.2e3.4", "Syntax error at line 1, column 39, token '0.4'");
        this.assertParseExpr(".00234e0003", "2.34");
        this.assertParseExpr(".00234e-0067", "2.34E-70");
    }

    public void testLargePrecision() {
        this.assertParseQuery("with member [Measures].[Small Number] as '[Measures].[Store Sales] / 9000'\nselect\n{[Measures].[Small Number]} on columns,\n{Filter([Product].[Product Department].members, [Measures].[Small Number] >= 0.3\nand [Measures].[Small Number] <= 0.5000001234)} on rows\nfrom Sales\nwhere ([Time].[1997].[Q2].[4])", TestContext.fold("with member [Measures].[Small Number] as '([Measures].[Store Sales] / 9000.0)'\nselect {[Measures].[Small Number]} ON COLUMNS,\n  {Filter([Product].[Product Department].members, (([Measures].[Small Number] >= 0.3) AND ([Measures].[Small Number] <= 0.5000001234)))} ON ROWS\nfrom [Sales]\nwhere ([Time].[1997].[Q2].[4])\n"));
    }

    public void testEmptyExpr() {
        this.assertParseQuery("SELECT NON EMPTY HIERARCHIZE({DrillDownLevelTop({[Product].[All Products]},\n3, , [Measures].[Unit Sales])}) on columns from [Sales]", TestContext.fold("select NON EMPTY HIERARCHIZE({DrillDownLevelTop({[Product].[All Products]}, 3.0, , [Measures].[Unit Sales])}) ON COLUMNS\nfrom [Sales]\n"));
    }

    private void assertParseQuery(String mdx, String expected) {
        TestParser p = new TestParser();
        Query query = p.parseInternal(null, mdx, false, funTable, false, false);
        ParserTest.assertNull((String)"Test parser should return null query", (Object)query);
        String actual = p.toMdxString();
        TestContext.assertEqualsVerbose(expected, actual);
    }

    private void assertParseExpr(String expr, String expected) {
        TestParser p = new TestParser();
        String mdx = this.wrapExpr(expr);
        Query query = p.parseInternal(null, mdx, false, funTable, false, false);
        ParserTest.assertNull((String)"Test parser should return null query", (Object)query);
        String actual = Util.unparse(p.formulas[0].getExpression());
        TestContext.assertEqualsVerbose(expected, actual);
    }

    private String wrapExpr(String expr) {
        return "with member [Measures].[Foo] as " + expr + "\n select from [Sales]";
    }

    public static class TestParser
    extends Parser {
        private Formula[] formulas;
        private QueryAxis[] axes;
        private String cube;
        private Exp slicer;
        private QueryPart[] cellProps;

        protected Query makeQuery(Formula[] formulae, QueryAxis[] axes, String cube, Exp slicer, QueryPart[] cellProps) {
            this.setFormulas(formulae);
            this.setAxes(axes);
            this.setCube(cube);
            this.setSlicer(slicer);
            this.setCellProps(cellProps);
            return null;
        }

        public QueryAxis[] getAxes() {
            return this.axes;
        }

        public void setAxes(QueryAxis[] axes) {
            this.axes = axes;
        }

        public QueryPart[] getCellProps() {
            return this.cellProps;
        }

        public void setCellProps(QueryPart[] cellProps) {
            this.cellProps = cellProps;
        }

        public String getCube() {
            return this.cube;
        }

        public void setCube(String cube) {
            this.cube = cube;
        }

        public Formula[] getFormulas() {
            return this.formulas;
        }

        public void setFormulas(Formula[] formulas) {
            this.formulas = formulas;
        }

        public Exp getSlicer() {
            return this.slicer;
        }

        public void setSlicer(Exp slicer) {
            this.slicer = slicer;
        }

        public String toMdxString() {
            StringWriter sw = new StringWriter();
            QueryPrintWriter pw = new QueryPrintWriter(sw);
            this.unparse(pw);
            return sw.toString();
        }

        private void unparse(PrintWriter pw) {
            int i;
            if (this.formulas != null) {
                for (i = 0; i < this.formulas.length; ++i) {
                    if (i == 0) {
                        pw.print("with ");
                    } else {
                        pw.print("  ");
                    }
                    this.formulas[i].unparse(pw);
                    pw.println();
                }
            }
            pw.print("select ");
            if (this.axes != null) {
                for (i = 0; i < this.axes.length; ++i) {
                    this.axes[i].unparse(pw);
                    if (i < this.axes.length - 1) {
                        pw.println(",");
                        pw.print("  ");
                        continue;
                    }
                    pw.println();
                }
            }
            if (this.cube != null) {
                pw.println("from [" + this.cube + "]");
            }
            if (this.slicer != null) {
                pw.print("where ");
                this.slicer.unparse(pw);
                pw.println();
            }
            if (this.cellProps != null) {
                for (QueryPart cellProp : this.cellProps) {
                    cellProp.unparse(pw);
                }
            }
        }
    }
}

