/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.test.FoodMartTestCase;
import mondrian.test.TestContext;

public class SolveOrderScopeIsolationTest
extends FoodMartTestCase {
    private static final String memberDefs = "<CalculatedMember\n    name=\"maleMinusFemale\"\n    dimension=\"gender\"\n    visible=\"false\"\n    formula=\"gender.m - gender.f\">\n  <CalculatedMemberProperty name=\"FORMAT_STRING\" value=\"#.##\"/>\n  <CalculatedMemberProperty name=\"SOLVE_ORDER\" value=\"3000\"/>\n</CalculatedMember><CalculatedMember\n    name=\"ratio\"\n    dimension=\"measures\"\n    visible=\"false\"\n    formula=\"measures.[unit sales] / measures.[sales count]\">\n  <CalculatedMemberProperty name=\"FORMAT_STRING\" value=\"#.##\"/>\n  <CalculatedMemberProperty name=\"SOLVE_ORDER\" value=\"10\"/>\n</CalculatedMember><CalculatedMember\n    name=\"Total\"\n    dimension=\"Time\"\n    visible=\"false\"\n    formula=\"AGGREGATE({[Time].[1997].[Q1],[Time].[1997].[Q2]})\">\n  <CalculatedMemberProperty name=\"FORMAT_STRING\" value=\"#.##\"/>\n  <CalculatedMemberProperty name=\"SOLVE_ORDER\" value=\"20\"/>\n</CalculatedMember>";
    private final MondrianProperties.SolveOrderModeEnum solveOrderMode;

    public SolveOrderScopeIsolationTest() {
        this.solveOrderMode = Util.lookup(MondrianProperties.SolveOrderModeEnum.class, MondrianProperties.instance().SolveOrderMode.get().toUpperCase(), MondrianProperties.SolveOrderModeEnum.ABSOLUTE);
    }

    public TestContext getTestContext() {
        return TestContext.createSubstitutingCube("Sales", null, memberDefs);
    }

    public void testOverrideOverCubeMemberDoesNotHappen() {
        String mdx = "with\nmember gender.override as 'gender.maleMinusFemale', SOLVE_ORDER=5, FORMAT_STRING='#.##'\nselect {measures.[ratio], measures.[unit sales], measures.[sales count]} on 0,\n{gender.override,gender.maleMinusFemale} on 1\nfrom sales";
        switch (this.solveOrderMode) {
            case ABSOLUTE: {
                this.assertQueryReturns("with\nmember gender.override as 'gender.maleMinusFemale', SOLVE_ORDER=5, FORMAT_STRING='#.##'\nselect {measures.[ratio], measures.[unit sales], measures.[sales count]} on 0,\n{gender.override,gender.maleMinusFemale} on 1\nfrom sales", SolveOrderScopeIsolationTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[ratio]}\n{[Measures].[Unit Sales]}\n{[Measures].[Sales Count]}\nAxis #2:\n{[Gender].[override]}\n{[Gender].[maleMinusFemale]}\nRow #0: 3.11\nRow #0: 3657\nRow #0: 1175\nRow #1: \nRow #1: 3657\nRow #1: 1175\n"));
                break;
            }
            default: {
                this.assertQueryReturns("with\nmember gender.override as 'gender.maleMinusFemale', SOLVE_ORDER=5, FORMAT_STRING='#.##'\nselect {measures.[ratio], measures.[unit sales], measures.[sales count]} on 0,\n{gender.override,gender.maleMinusFemale} on 1\nfrom sales", SolveOrderScopeIsolationTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[ratio]}\n{[Measures].[Unit Sales]}\n{[Measures].[Sales Count]}\nAxis #2:\n{[Gender].[override]}\n{[Gender].[maleMinusFemale]}\nRow #0: \nRow #0: 3657\nRow #0: 1175\nRow #1: \nRow #1: 3657\nRow #1: 1175\n"));
            }
        }
    }

    public void _testOverrideOverCubeMemberHappensWithScopeIsolation() {
        if (this.solveOrderMode == MondrianProperties.SolveOrderModeEnum.ABSOLUTE) {
            return;
        }
        if (MondrianProperties.instance().CaseSensitive.get()) {
            return;
        }
        this.assertQueryReturns("with\nmember gender.maleMinusFemale as 'Gender.M - gender.f', SOLVE_ORDER=3000, FORMAT_STRING='#.##'\nmember gender.override as 'gender.maleMinusFemale', SOLVE_ORDER=5, FORMAT_STRING='#.##', SCOPE_ISOLATION=CUBE \nmember measures.[ratio] as 'measures.[unit sales] / measures.[sales count]', SOLVE_ORDER=10\nselect {measures.[ratio],\nmeasures.[unit sales],\nmeasures.[sales count]} on 0,\n{gender.override, gender.maleMinusFemale} on 1\nfrom sales", SolveOrderScopeIsolationTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[ratio]}\n{[Measures].[Unit Sales]}\n{[Measures].[Sales Count]}\nAxis #2:\n{[Gender].[override]}\n{[Gender].[maleMinusFemale]}\nRow #0: 3.11Row #0: 3657\nRow #0: 1175\nRow #1: \nRow #1: 3657\nRow #1: 1175\n"));
    }

    public void testCubeMemberIsEvaluatedBeforeQueryMember() {
        String mdx = "WITH MEMBER [Customers].USAByWA AS\n'[Customers].[Country].[USA] / [Customers].[State Province].[WA]', SOLVE_ORDER=5\nSELECT {[Country].[USA],[State Province].[WA], [Customers].USAByWA} ON 0 FROM SALES\nWHERE Profit";
        switch (this.solveOrderMode) {
            case ABSOLUTE: {
                this.assertQueryReturns("WITH MEMBER [Customers].USAByWA AS\n'[Customers].[Country].[USA] / [Customers].[State Province].[WA]', SOLVE_ORDER=5\nSELECT {[Country].[USA],[State Province].[WA], [Customers].USAByWA} ON 0 FROM SALES\nWHERE Profit", SolveOrderScopeIsolationTest.fold("Axis #0:\n{[Measures].[Profit]}\nAxis #1:\n{[Customers].[All Customers].[USA]}\n{[Customers].[All Customers].[USA].[WA]}\n{[Customers].[USAByWA]}\nRow #0: $339,610.90\nRow #0: $158,468.91\nRow #0: $2.14\n"));
                break;
            }
            default: {
                this.assertQueryReturns("WITH MEMBER [Customers].USAByWA AS\n'[Customers].[Country].[USA] / [Customers].[State Province].[WA]', SOLVE_ORDER=5\nSELECT {[Country].[USA],[State Province].[WA], [Customers].USAByWA} ON 0 FROM SALES\nWHERE Profit", SolveOrderScopeIsolationTest.fold("Axis #0:\n{[Measures].[Profit]}\nAxis #1:\n{[Customers].[All Customers].[USA]}\n{[Customers].[All Customers].[USA].[WA]}\n{[Customers].[USAByWA]}\nRow #0: $339,610.90\nRow #0: $158,468.91\nRow #0: $2.14\n"));
            }
        }
    }

    public void testOverrideOverCubeMemberInTupleDoesNotHappen() {
        String mdx = "with\nmember gender.override as '([Gender].[maleMinusFemale], [Product].[Food])', SOLVE_ORDER=5,\nFORMAT_STRING='#.##'\nselect {measures.[ratio],\nmeasures.[unit sales],\nmeasures.[sales count]} on 0,\n{gender.override, gender.maleMinusFemale} on 1\nfrom sales";
        switch (this.solveOrderMode) {
            case ABSOLUTE: {
                this.assertQueryReturns("with\nmember gender.override as '([Gender].[maleMinusFemale], [Product].[Food])', SOLVE_ORDER=5,\nFORMAT_STRING='#.##'\nselect {measures.[ratio],\nmeasures.[unit sales],\nmeasures.[sales count]} on 0,\n{gender.override, gender.maleMinusFemale} on 1\nfrom sales", SolveOrderScopeIsolationTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[ratio]}\n{[Measures].[Unit Sales]}\n{[Measures].[Sales Count]}\nAxis #2:\n{[Gender].[override]}\n{[Gender].[maleMinusFemale]}\nRow #0: 3.09\nRow #0: 2312\nRow #0: 749\nRow #1: \nRow #1: 3657\nRow #1: 1175\n"));
                break;
            }
            default: {
                this.assertQueryReturns("with\nmember gender.override as '([Gender].[maleMinusFemale], [Product].[Food])', SOLVE_ORDER=5,\nFORMAT_STRING='#.##'\nselect {measures.[ratio],\nmeasures.[unit sales],\nmeasures.[sales count]} on 0,\n{gender.override, gender.maleMinusFemale} on 1\nfrom sales", SolveOrderScopeIsolationTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[ratio]}\n{[Measures].[Unit Sales]}\n{[Measures].[Sales Count]}\nAxis #2:\n{[Gender].[override]}\n{[Gender].[maleMinusFemale]}\nRow #0: \nRow #0: 2312\nRow #0: 749\nRow #1: \nRow #1: 3657\nRow #1: 1175\n"));
            }
        }
    }

    public void testConditionalCubeMemberGetsEvaluatedBeforeOtherMembers() {
        String mdx = "with\nmember gender.override as 'iif(1=0,[gender].[all gender].[m], [Gender].[maleMinusFemale])', SOLVE_ORDER=5, FORMAT_STRING='#.##'\nselect {measures.[ratio],\nmeasures.[unit sales],\nmeasures.[sales count]} on 0,\n{[Gender].[override], gender.maleMinusFemale} on 1\nfrom sales";
        switch (this.solveOrderMode) {
            case ABSOLUTE: {
                this.assertQueryReturns("with\nmember gender.override as 'iif(1=0,[gender].[all gender].[m], [Gender].[maleMinusFemale])', SOLVE_ORDER=5, FORMAT_STRING='#.##'\nselect {measures.[ratio],\nmeasures.[unit sales],\nmeasures.[sales count]} on 0,\n{[Gender].[override], gender.maleMinusFemale} on 1\nfrom sales", SolveOrderScopeIsolationTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[ratio]}\n{[Measures].[Unit Sales]}\n{[Measures].[Sales Count]}\nAxis #2:\n{[Gender].[override]}\n{[Gender].[maleMinusFemale]}\nRow #0: 3.11\nRow #0: 3657\nRow #0: 1175\nRow #1: \nRow #1: 3657\nRow #1: 1175\n"));
                break;
            }
            default: {
                this.assertQueryReturns("with\nmember gender.override as 'iif(1=0,[gender].[all gender].[m], [Gender].[maleMinusFemale])', SOLVE_ORDER=5, FORMAT_STRING='#.##'\nselect {measures.[ratio],\nmeasures.[unit sales],\nmeasures.[sales count]} on 0,\n{[Gender].[override], gender.maleMinusFemale} on 1\nfrom sales", SolveOrderScopeIsolationTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[ratio]}\n{[Measures].[Unit Sales]}\n{[Measures].[Sales Count]}\nAxis #2:\n{[Gender].[override]}\n{[Gender].[maleMinusFemale]}\nRow #0: \nRow #0: 3657\nRow #0: 1175\nRow #1: \nRow #1: 3657\nRow #1: 1175\n"));
            }
        }
    }

    public void testOverrideOverCubeMemberUsingStrToMemberDoesNotHappen() {
        String mdx = "with\nmember gender.override as 'iif(1=0,[gender].[all gender].[m], StrToMember(\"[Gender].[maleMinusFemale]\"))', SOLVE_ORDER=5, FORMAT_STRING='#.##'\nselect {measures.[ratio],\nmeasures.[unit sales],\nmeasures.[sales count]} on 0,\n{[Gender].[override], gender.maleMinusFemale} on 1\nfrom sales";
        switch (this.solveOrderMode) {
            case ABSOLUTE: {
                this.assertQueryReturns("with\nmember gender.override as 'iif(1=0,[gender].[all gender].[m], StrToMember(\"[Gender].[maleMinusFemale]\"))', SOLVE_ORDER=5, FORMAT_STRING='#.##'\nselect {measures.[ratio],\nmeasures.[unit sales],\nmeasures.[sales count]} on 0,\n{[Gender].[override], gender.maleMinusFemale} on 1\nfrom sales", SolveOrderScopeIsolationTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[ratio]}\n{[Measures].[Unit Sales]}\n{[Measures].[Sales Count]}\nAxis #2:\n{[Gender].[override]}\n{[Gender].[maleMinusFemale]}\nRow #0: 3.11\nRow #0: 3657\nRow #0: 1175\nRow #1: \nRow #1: 3657\nRow #1: 1175\n"));
                break;
            }
            default: {
                this.assertQueryReturns("with\nmember gender.override as 'iif(1=0,[gender].[all gender].[m], StrToMember(\"[Gender].[maleMinusFemale]\"))', SOLVE_ORDER=5, FORMAT_STRING='#.##'\nselect {measures.[ratio],\nmeasures.[unit sales],\nmeasures.[sales count]} on 0,\n{[Gender].[override], gender.maleMinusFemale} on 1\nfrom sales", SolveOrderScopeIsolationTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[ratio]}\n{[Measures].[Unit Sales]}\n{[Measures].[Sales Count]}\nAxis #2:\n{[Gender].[override]}\n{[Gender].[maleMinusFemale]}\nRow #0: \nRow #0: 3657\nRow #0: 1175\nRow #1: \nRow #1: 3657\nRow #1: 1175\n"));
            }
        }
    }

    public void testAggregateMemberIsEvaluatedAfterOtherMembers() {
        String mdx = "With\nmember Time.Total1 as 'AGGREGATE({[Time].[1997].[Q1],[Time].[1997].[Q2]})' , SOLVE_ORDER=20 \n, FORMAT_STRING='#.##'\nmember measures.[ratio1] as 'measures.[unit sales] / measures.[sales count]', SOLVE_ORDER=10 , FORMAT_STRING='#.##'\nselect {measures.[ratio1],\nmeasures.[unit sales],\nmeasures.[sales count]} on 0,\n{Time.Total, Time.Total1, [Time].[1997].[Q1], [Time].[1997].[Q2]} on 1\nfrom sales";
        switch (this.solveOrderMode) {
            case ABSOLUTE: {
                this.assertQueryReturns("With\nmember Time.Total1 as 'AGGREGATE({[Time].[1997].[Q1],[Time].[1997].[Q2]})' , SOLVE_ORDER=20 \n, FORMAT_STRING='#.##'\nmember measures.[ratio1] as 'measures.[unit sales] / measures.[sales count]', SOLVE_ORDER=10 , FORMAT_STRING='#.##'\nselect {measures.[ratio1],\nmeasures.[unit sales],\nmeasures.[sales count]} on 0,\n{Time.Total, Time.Total1, [Time].[1997].[Q1], [Time].[1997].[Q2]} on 1\nfrom sales", SolveOrderScopeIsolationTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[ratio1]}\n{[Measures].[Unit Sales]}\n{[Measures].[Sales Count]}\nAxis #2:\n{[Time].[Total]}\n{[Time].[Total1]}\n{[Time].[1997].[Q1]}\n{[Time].[1997].[Q2]}\nRow #0: #ERR: mondrian.olap.fun.MondrianEvaluationException: Could not find an aggregator in the current evaluation context\nRow #0: 128901\nRow #0: 41956\nRow #1: #ERR: mondrian.olap.fun.MondrianEvaluationException: Could not find an aggregator in the current evaluation context\nRow #1: 128901\nRow #1: 41956\nRow #2: 3.07\nRow #2: 66,291\nRow #2: 21,588\nRow #3: 3.07\nRow #3: 62,610\nRow #3: 20,368\n"));
                break;
            }
            default: {
                this.assertQueryReturns("With\nmember Time.Total1 as 'AGGREGATE({[Time].[1997].[Q1],[Time].[1997].[Q2]})' , SOLVE_ORDER=20 \n, FORMAT_STRING='#.##'\nmember measures.[ratio1] as 'measures.[unit sales] / measures.[sales count]', SOLVE_ORDER=10 , FORMAT_STRING='#.##'\nselect {measures.[ratio1],\nmeasures.[unit sales],\nmeasures.[sales count]} on 0,\n{Time.Total, Time.Total1, [Time].[1997].[Q1], [Time].[1997].[Q2]} on 1\nfrom sales", SolveOrderScopeIsolationTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[ratio1]}\n{[Measures].[Unit Sales]}\n{[Measures].[Sales Count]}\nAxis #2:\n{[Time].[Total]}\n{[Time].[Total1]}\n{[Time].[1997].[Q1]}\n{[Time].[1997].[Q2]}\nRow #0: 3.07\nRow #0: 128901\nRow #0: 41956\nRow #1: 3.07\nRow #1: 128901\nRow #1: 41956\nRow #2: 3.07\nRow #2: 66,291\nRow #2: 21,588\nRow #3: 3.07\nRow #3: 62,610\nRow #3: 20,368\n"));
            }
        }
    }

    public void testConditionalAggregateMemberIsEvaluatedAfterOtherMembers() {
        String mdx = "With\nmember Time.Total1 as 'IIF(Measures.CURRENTMEMBER IS Measures.Profit, 1, AGGREGATE({[Time].[1997].[Q1],[Time].[1997].[Q2]}))' , SOLVE_ORDER=20 \n, FORMAT_STRING='#.##'\nmember measures.[ratio1] as 'measures.[unit sales] / measures.[sales count]', SOLVE_ORDER=10, FORMAT_STRING='#.##'\nselect {measures.[ratio1],\nmeasures.[unit sales],\nmeasures.[sales count]} on 0,\n{Time.Total, Time.Total1, [Time].[1997].[Q1], [Time].[1997].[Q2]} on 1\nfrom sales";
        switch (this.solveOrderMode) {
            case ABSOLUTE: {
                this.assertQueryReturns("With\nmember Time.Total1 as 'IIF(Measures.CURRENTMEMBER IS Measures.Profit, 1, AGGREGATE({[Time].[1997].[Q1],[Time].[1997].[Q2]}))' , SOLVE_ORDER=20 \n, FORMAT_STRING='#.##'\nmember measures.[ratio1] as 'measures.[unit sales] / measures.[sales count]', SOLVE_ORDER=10, FORMAT_STRING='#.##'\nselect {measures.[ratio1],\nmeasures.[unit sales],\nmeasures.[sales count]} on 0,\n{Time.Total, Time.Total1, [Time].[1997].[Q1], [Time].[1997].[Q2]} on 1\nfrom sales", SolveOrderScopeIsolationTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[ratio1]}\n{[Measures].[Unit Sales]}\n{[Measures].[Sales Count]}\nAxis #2:\n{[Time].[Total]}\n{[Time].[Total1]}\n{[Time].[1997].[Q1]}\n{[Time].[1997].[Q2]}\nRow #0: #ERR: mondrian.olap.fun.MondrianEvaluationException: Could not find an aggregator in the current evaluation context\nRow #0: 128901\nRow #0: 41956\nRow #1: #ERR: mondrian.olap.fun.MondrianEvaluationException: Could not find an aggregator in the current evaluation context\nRow #1: 128901\nRow #1: 41956\nRow #2: 3.07\nRow #2: 66,291\nRow #2: 21,588\nRow #3: 3.07\nRow #3: 62,610\nRow #3: 20,368\n"));
                break;
            }
            default: {
                this.assertQueryReturns("With\nmember Time.Total1 as 'IIF(Measures.CURRENTMEMBER IS Measures.Profit, 1, AGGREGATE({[Time].[1997].[Q1],[Time].[1997].[Q2]}))' , SOLVE_ORDER=20 \n, FORMAT_STRING='#.##'\nmember measures.[ratio1] as 'measures.[unit sales] / measures.[sales count]', SOLVE_ORDER=10, FORMAT_STRING='#.##'\nselect {measures.[ratio1],\nmeasures.[unit sales],\nmeasures.[sales count]} on 0,\n{Time.Total, Time.Total1, [Time].[1997].[Q1], [Time].[1997].[Q2]} on 1\nfrom sales", SolveOrderScopeIsolationTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[ratio1]}\n{[Measures].[Unit Sales]}\n{[Measures].[Sales Count]}\nAxis #2:\n{[Time].[Total]}\n{[Time].[Total1]}\n{[Time].[1997].[Q1]}\n{[Time].[1997].[Q2]}\nRow #0: 3.07\nRow #0: 128901\nRow #0: 41956\nRow #1: 3.07\nRow #1: 128901\nRow #1: 41956\nRow #2: 3.07\nRow #2: 66,291\nRow #2: 21,588\nRow #3: 3.07\nRow #3: 62,610\nRow #3: 20,368\n"));
            }
        }
    }

    public void testStrToMemberReturningAggregateIsEvaluatedAfterOtherMembers() {
        String mdx = "With\nmember Time.StrTotal as 'AGGREGATE({[Time].[1997].[Q1],[Time].[1997].[Q2]})', SOLVE_ORDER=100, FORMAT_STRING='#.##'\nmember Time.Total as 'IIF(Measures.CURRENTMEMBER IS Measures.Profit, 1, \nStrToMember(\"[Time].[StrTotal]\"))' , SOLVE_ORDER=20 \n, FORMAT_STRING='#.##'\nmember measures.[ratio1] as 'measures.[unit sales] / measures.[sales count]', SOLVE_ORDER=10, FORMAT_STRING='#.##'\nselect {measures.[ratio1],\nmeasures.[unit sales],\nmeasures.[sales count]} on 0,\n{Time.Total, [Time].[1997].[Q1], [Time].[1997].[Q2]} on 1\nfrom sales";
        switch (this.solveOrderMode) {
            case ABSOLUTE: {
                this.assertQueryReturns("With\nmember Time.StrTotal as 'AGGREGATE({[Time].[1997].[Q1],[Time].[1997].[Q2]})', SOLVE_ORDER=100, FORMAT_STRING='#.##'\nmember Time.Total as 'IIF(Measures.CURRENTMEMBER IS Measures.Profit, 1, \nStrToMember(\"[Time].[StrTotal]\"))' , SOLVE_ORDER=20 \n, FORMAT_STRING='#.##'\nmember measures.[ratio1] as 'measures.[unit sales] / measures.[sales count]', SOLVE_ORDER=10, FORMAT_STRING='#.##'\nselect {measures.[ratio1],\nmeasures.[unit sales],\nmeasures.[sales count]} on 0,\n{Time.Total, [Time].[1997].[Q1], [Time].[1997].[Q2]} on 1\nfrom sales", SolveOrderScopeIsolationTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[ratio1]}\n{[Measures].[Unit Sales]}\n{[Measures].[Sales Count]}\nAxis #2:\n{[Time].[Total]}\n{[Time].[1997].[Q1]}\n{[Time].[1997].[Q2]}\nRow #0: #ERR: mondrian.olap.fun.MondrianEvaluationException: Could not find an aggregator in the current evaluation context\nRow #0: 128901\nRow #0: 41956\nRow #1: 3.07\nRow #1: 66,291\nRow #1: 21,588\nRow #2: 3.07\nRow #2: 62,610\nRow #2: 20,368\n"));
                break;
            }
            default: {
                this.assertQueryReturns("With\nmember Time.StrTotal as 'AGGREGATE({[Time].[1997].[Q1],[Time].[1997].[Q2]})', SOLVE_ORDER=100, FORMAT_STRING='#.##'\nmember Time.Total as 'IIF(Measures.CURRENTMEMBER IS Measures.Profit, 1, \nStrToMember(\"[Time].[StrTotal]\"))' , SOLVE_ORDER=20 \n, FORMAT_STRING='#.##'\nmember measures.[ratio1] as 'measures.[unit sales] / measures.[sales count]', SOLVE_ORDER=10, FORMAT_STRING='#.##'\nselect {measures.[ratio1],\nmeasures.[unit sales],\nmeasures.[sales count]} on 0,\n{Time.Total, [Time].[1997].[Q1], [Time].[1997].[Q2]} on 1\nfrom sales", SolveOrderScopeIsolationTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[ratio1]}\n{[Measures].[Unit Sales]}\n{[Measures].[Sales Count]}\nAxis #2:\n{[Time].[Total]}\n{[Time].[1997].[Q1]}\n{[Time].[1997].[Q2]}\nRow #0: 3.07\nRow #0: 128901\nRow #0: 41956\nRow #1: 3.07\nRow #1: 66,291\nRow #1: 21,588\nRow #2: 3.07\nRow #2: 62,610\nRow #2: 20,368\n"));
            }
        }
    }

    public void test2LevelOfOverrideOverCubeMemberDoesNotHappen() {
        String mdx = "With member gender.override1 as 'gender.maleMinusFemale',\nSOLVE_ORDER=20, FORMAT_STRING='#.##'\nmember gender.override2 as 'gender.override1', SOLVE_ORDER=2,\nFORMAT_STRING='#.##'\nmember measures.[ratio1] as 'measures.[unit sales] / measures.[sales count]', SOLVE_ORDER=50, FORMAT_STRING='#.##'\nselect {measures.[ratio], measures.[ratio1],\nmeasures.[unit sales],\nmeasures.[sales count]} on 0,\n{gender.override1, gender.override2, gender.maleMinusFemale} on 1\nfrom sales";
        switch (this.solveOrderMode) {
            case ABSOLUTE: {
                this.assertQueryReturns("With member gender.override1 as 'gender.maleMinusFemale',\nSOLVE_ORDER=20, FORMAT_STRING='#.##'\nmember gender.override2 as 'gender.override1', SOLVE_ORDER=2,\nFORMAT_STRING='#.##'\nmember measures.[ratio1] as 'measures.[unit sales] / measures.[sales count]', SOLVE_ORDER=50, FORMAT_STRING='#.##'\nselect {measures.[ratio], measures.[ratio1],\nmeasures.[unit sales],\nmeasures.[sales count]} on 0,\n{gender.override1, gender.override2, gender.maleMinusFemale} on 1\nfrom sales", SolveOrderScopeIsolationTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[ratio]}\n{[Measures].[ratio1]}\n{[Measures].[Unit Sales]}\n{[Measures].[Sales Count]}\nAxis #2:\n{[Gender].[override1]}\n{[Gender].[override2]}\n{[Gender].[maleMinusFemale]}\nRow #0: \nRow #0: 3.11\nRow #0: 3657\nRow #0: 1175\nRow #1: 3.11\nRow #1: 3.11\nRow #1: 3657\nRow #1: 1175\nRow #2: \nRow #2: \nRow #2: 3657\nRow #2: 1175\n"));
                break;
            }
            default: {
                this.assertQueryReturns("With member gender.override1 as 'gender.maleMinusFemale',\nSOLVE_ORDER=20, FORMAT_STRING='#.##'\nmember gender.override2 as 'gender.override1', SOLVE_ORDER=2,\nFORMAT_STRING='#.##'\nmember measures.[ratio1] as 'measures.[unit sales] / measures.[sales count]', SOLVE_ORDER=50, FORMAT_STRING='#.##'\nselect {measures.[ratio], measures.[ratio1],\nmeasures.[unit sales],\nmeasures.[sales count]} on 0,\n{gender.override1, gender.override2, gender.maleMinusFemale} on 1\nfrom sales", SolveOrderScopeIsolationTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[ratio]}\n{[Measures].[ratio1]}\n{[Measures].[Unit Sales]}\n{[Measures].[Sales Count]}\nAxis #2:\n{[Gender].[override1]}\n{[Gender].[override2]}\n{[Gender].[maleMinusFemale]}\nRow #0: \nRow #0: 3.11\nRow #0: 3657\nRow #0: 1175\nRow #1: \nRow #1: 3.11\nRow #1: 3657\nRow #1: 1175\nRow #2: \nRow #2: 3.11\nRow #2: 3657\nRow #2: 1175\n"));
            }
        }
    }
}

