/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.inc;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.LexerInputOperation;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.inc.JoinTokenListChange;
import org.netbeans.lib.lexer.inc.MutableJoinLexerInputOperation;
import org.netbeans.lib.lexer.inc.MutableJoinTokenList;
import org.netbeans.lib.lexer.inc.MutableTokenList;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.lib.lexer.inc.TokenListChange;
import org.netbeans.lib.lexer.inc.TokenListListUpdate;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.JoinToken;
import org.netbeans.lib.lexer.token.PartToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenListUpdater {
    private static final Logger LOG = Logger.getLogger(TokenListUpdater.class.getName());

    static <T extends TokenId> void updateRegular(TokenListChange<T> tokenListChange, TokenHierarchyEventInfo tokenHierarchyEventInfo) {
        Object object;
        int n;
        boolean bl;
        MutableTokenList<T> mutableTokenList = tokenListChange.tokenList();
        int n2 = mutableTokenList.tokenCountCurrent();
        boolean bl2 = LOG.isLoggable(Level.FINE);
        if (bl2) {
            TokenListUpdater.logModification(mutableTokenList, tokenHierarchyEventInfo, false);
        }
        int[] nArray = LexerUtilsConstants.tokenIndexBinSearch(mutableTokenList, tokenHierarchyEventInfo.modOffset(), n2);
        int n3 = nArray[0];
        int n4 = nArray[1];
        if (n3 == -1) {
            n3 = 0;
            n4 = mutableTokenList.startOffset();
        }
        int n5 = n3;
        int n6 = n4;
        if (n3 == n2) {
            if (!mutableTokenList.isFullyLexed() && tokenHierarchyEventInfo.modOffset() >= n4 + (n3 > 0 ? mutableTokenList.lookahead(n3 - 1) : 0)) {
                if (bl2) {
                    LOG.log(Level.FINE, "UPDATE-REGULAR FINISHED: Not fully lexed yet. rOff=" + n4 + ", modOff=" + tokenHierarchyEventInfo.modOffset() + "\n");
                }
                tokenListChange.setIndex(n3);
                tokenListChange.setOffset(n4);
                tokenListChange.setMatchIndex(n5);
                tokenListChange.setMatchOffset(n6);
                mutableTokenList.replaceTokens(tokenListChange, tokenHierarchyEventInfo, true);
                return;
            }
            if (mutableTokenList.isFullyLexed()) {
                n6 = Integer.MAX_VALUE;
            }
        } else {
            if (tokenHierarchyEventInfo.removedLength() > 0) {
                n6 += mutableTokenList.tokenOrEmbeddingUnsync(n5++).token().length();
                int n7 = tokenHierarchyEventInfo.modOffset() + tokenHierarchyEventInfo.removedLength();
                while (n6 < n7 && n5 < n2) {
                    n6 += mutableTokenList.tokenOrEmbeddingUnsync(n5++).token().length();
                }
            } else if (n6 < tokenHierarchyEventInfo.modOffset()) {
                n6 += mutableTokenList.tokenOrEmbeddingUnsync(n5++).token().length();
            }
            n6 += tokenHierarchyEventInfo.diffLength();
        }
        while (n3 > 0 && n4 + mutableTokenList.lookahead(n3 - 1) > tokenHierarchyEventInfo.modOffset()) {
            --n3;
            if (bl2) {
                LOG.log(Level.FINE, "    Token at reInd=" + n3 + " affected (la=" + mutableTokenList.lookahead(n3) + ") => relex it\n");
            }
            AbstractToken<T> abstractToken = mutableTokenList.tokenOrEmbeddingUnsync(n3).token();
            n4 -= abstractToken.length();
        }
        Object object2 = n3 > 0 ? mutableTokenList.state(n3 - 1) : null;
        tokenListChange.setIndex(n3);
        tokenListChange.setOffset(n4);
        tokenListChange.setMatchIndex(n5);
        tokenListChange.setMatchOffset(n6);
        boolean bl3 = bl = n4 != n6 || tokenHierarchyEventInfo.insertedLength() > 0 || n5 == 0 || !LexerUtilsConstants.statesEqual(object2, mutableTokenList.state(n5 - 1));
        if (!bl && (n = mutableTokenList.lookahead(n5 - 1)) > 1 && n5 < n2) {
            boolean bl4 = bl = n > mutableTokenList.tokenOrEmbeddingUnsync(n5).token().length();
        }
        if (bl2) {
            object = new StringBuilder(200);
            ((StringBuilder)object).append("  BEFORE-RELEX:\n");
            ((StringBuilder)object).append("  relex=").append(bl);
            ((StringBuilder)object).append(", reInd=").append(n3).append(", reOff=").append(n4);
            ((StringBuilder)object).append(", reSta=").append(object2).append('\n');
            ((StringBuilder)object).append("  maInd=").append(n5).append(", maOff=").append(n6);
            ((StringBuilder)object).append('\n');
            LOG.log(Level.FINE, ((StringBuilder)object).toString());
        }
        assert (n3 >= 0);
        if (bl) {
            if (n4 < 0) {
                TokenListUpdater.logModification(mutableTokenList, tokenHierarchyEventInfo, false);
                LOG.info("relexIndex=" + n3 + ", relexOffset=" + n4 + ", relexState=" + object2 + ", indexAndTokenOffset: [" + nArray[0] + ", " + nArray[1] + "]\n");
                LOG.info("\n\n" + tokenHierarchyEventInfo.modificationDescription(true) + "\n");
            }
            object = mutableTokenList.createLexerInputOperation(n3, n4, object2);
            TokenListUpdater.relex(tokenListChange, object, n2);
        }
        mutableTokenList.replaceTokens(tokenListChange, tokenHierarchyEventInfo, true);
        if (bl2) {
            LOG.log(Level.FINE, "\nchange:" + tokenListChange + "\nMods:" + tokenListChange.toStringMods(4) + "UPDATE-REGULAR FINISHED\n");
        }
    }

    static <T extends TokenId> void updateJoined(JoinTokenListChange<T> joinTokenListChange, TokenHierarchyEventInfo tokenHierarchyEventInfo) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl;
        int n6;
        int n7;
        int n8;
        int n9;
        MutableJoinTokenList mutableJoinTokenList = (MutableJoinTokenList)joinTokenListChange.tokenList();
        TokenListListUpdate<T> tokenListListUpdate = joinTokenListChange.tokenListListUpdate();
        int n10 = mutableJoinTokenList.tokenCountCurrent();
        boolean bl2 = LOG.isLoggable(Level.FINE);
        if (bl2) {
            TokenListUpdater.logModification(mutableJoinTokenList, tokenHierarchyEventInfo, true);
        }
        int n11 = tokenHierarchyEventInfo.modOffset();
        boolean bl3 = true;
        int n12 = tokenListListUpdate.modTokenListIndex;
        if (tokenListListUpdate.isTokenListsMod()) {
            n9 = 0;
            mutableJoinTokenList.setActiveTokenListIndex(n12);
            n8 = mutableJoinTokenList.activeStartJoinIndex();
            n7 = 0;
            n6 = n12;
            bl = true;
            n5 = n12 + tokenListListUpdate.removedTokenListCount;
            boolean bl4 = false;
            if (n5 > 0) {
                mutableJoinTokenList.setActiveTokenListIndex(n5 - 1);
                n4 = mutableJoinTokenList.activeEndJoinIndex();
                n3 = mutableJoinTokenList.activeTokenList().endOffset();
                if (n3 > n11) {
                    n3 = Math.max(n3 - tokenHierarchyEventInfo.removedLength(), n11);
                }
                if (mutableJoinTokenList.activeTokenList().joinInfo.joinTokenLastPartShift() > 0) {
                    n3 = ((JoinToken)mutableJoinTokenList.tokenOrEmbeddingUnsync(n4).token()).endOffset();
                    ++n4;
                    bl4 = true;
                }
            } else {
                n4 = 0;
                n3 = -1;
            }
            if (!bl4 && tokenListListUpdate.addedTokenListCount() > 0) {
                n3 = tokenListListUpdate.afterUpdateTokenList(mutableJoinTokenList, n12 + tokenListListUpdate.addedTokenListCount() - 1).endOffset();
            }
            if (n6 < (n2 = tokenListListUpdate.afterUpdateTokenListCount(mutableJoinTokenList))) {
                n = tokenListListUpdate.afterUpdateTokenList(mutableJoinTokenList, n12).startOffset();
            } else {
                bl3 = false;
                n = Integer.MAX_VALUE;
            }
            if (n3 < n && n6 > 0) {
                bl3 = false;
            }
        } else {
            mutableJoinTokenList.setActiveTokenListIndex(n12);
            EmbeddedTokenList embeddedTokenList = mutableJoinTokenList.activeTokenList();
            assert (tokenHierarchyEventInfo.insertedLength() > 0 || tokenHierarchyEventInfo.removedLength() > 0) : "No modification";
            assert (n11 >= embeddedTokenList.startOffset()) : "modOffset=" + n11 + " < etlStartOffset=" + embeddedTokenList.startOffset();
            assert (n11 + tokenHierarchyEventInfo.diffLengthOrZero() <= embeddedTokenList.endOffset()) : "modOffset=" + n11 + " + diffLength=" + tokenHierarchyEventInfo.diffLength() + " > etlEndOffset=" + embeddedTokenList.endOffset();
            joinTokenListChange.charModTokenList = embeddedTokenList;
            int[] nArray = embeddedTokenList.tokenIndex(n11);
            n6 = n12;
            n7 = nArray[0];
            n = nArray[1];
            if (n7 == -1) {
                n7 = 0;
                n = embeddedTokenList.startOffset();
            }
            n9 = n11 - n;
            n4 = n8 = mutableJoinTokenList.activeStartJoinIndex() + n7;
            n3 = n;
            n2 = n7;
            bl = false;
            int n13 = embeddedTokenList.tokenCountCurrent();
            if (tokenHierarchyEventInfo.removedLength() > 0) {
                ++n4;
                n3 += embeddedTokenList.tokenOrEmbeddingUnsync(n2++).token().length();
                int n14 = tokenHierarchyEventInfo.modOffset() + tokenHierarchyEventInfo.removedLength();
                while (n3 < n14 && n2 < n13) {
                    ++n4;
                    n3 += embeddedTokenList.tokenOrEmbeddingUnsync(n2++).token().length();
                }
            } else if (n3 < n11) {
                ++n4;
                n3 += embeddedTokenList.tokenOrEmbeddingUnsync(n2++).token().length();
            }
            n3 += tokenHierarchyEventInfo.diffLength();
            assert (n7 <= n2);
            assert (n2 <= n13);
            if (n2 == n13 && embeddedTokenList.joinInfo.joinTokenLastPartShift() > 0) {
                n4 = mutableJoinTokenList.activeEndJoinIndex() + 1;
                JoinToken joinToken = (JoinToken)mutableJoinTokenList.tokenOrEmbeddingUnsync(n4 - 1).token();
                mutableJoinTokenList.setActiveTokenListIndex(n12);
                n3 = joinToken.endOffset();
            }
            if (n7 == 0) {
                bl = true;
            }
            if (n7 == n2 && n7 == n13 && embeddedTokenList.joinInfo.joinTokenLastPartShift() > 0) {
                assert (tokenHierarchyEventInfo.removedLength() == 0) : "Insert only expected";
                if (n13 > 0) {
                    assert (n8 == mutableJoinTokenList.activeEndJoinIndex() + 1);
                    --n8;
                    n = embeddedTokenList.tokenOffset(--n7);
                }
                if (n7 == 0) {
                    bl = true;
                }
            }
        }
        if (bl && n6 > 0) {
            mutableJoinTokenList.setActiveTokenListIndex(n6 - 1);
            while ((n5 = mutableJoinTokenList.activeTokenList().joinInfo.joinTokenLastPartShift()) > 0) {
                if (mutableJoinTokenList.activeTokenList().tokenCountCurrent() > 0) {
                    n7 = mutableJoinTokenList.activeTokenList().tokenCountCurrent() - 1;
                    n6 = mutableJoinTokenList.activeTokenListIndex();
                    PartToken partToken = (PartToken)mutableJoinTokenList.activeTokenList().tokenOrEmbeddingUnsync(n7).token();
                    n9 = partToken.partTextEndOffset();
                    n = ((JoinToken)partToken.joinToken()).offset(null);
                    if (partToken.partTokenIndex() != 0) {
                        n7 = mutableJoinTokenList.tokenStartLocalIndex(n8);
                        n6 = mutableJoinTokenList.activeTokenListIndex();
                    }
                    bl3 = true;
                    if (n8 != n4) break;
                    ++n4;
                    n3 = ((JoinToken)partToken.joinToken()).endOffset();
                    n5 = mutableJoinTokenList.activeTokenList().joinInfo.joinTokenLastPartShift();
                    if (mutableJoinTokenList.activeTokenListIndex() + n5 != n12) break;
                    n3 += tokenHierarchyEventInfo.diffLength();
                    break;
                }
                if (mutableJoinTokenList.activeTokenListIndex() <= 0) break;
                mutableJoinTokenList.setPrevActiveTokenListIndex();
            }
        }
        n5 = n8;
        while (n8 > 0 && mutableJoinTokenList.lookahead(n8 - 1) > n9) {
            AbstractToken abstractToken = mutableJoinTokenList.tokenOrEmbeddingUnsync(--n8).token();
            n9 += abstractToken.length();
            if (!bl2) continue;
            LOG.log(Level.FINE, "    Token at reInd=" + n8 + " affected (la=" + mutableJoinTokenList.lookahead(n8) + ") => relex it\n");
        }
        if (n8 != n5) {
            n = mutableJoinTokenList.tokenOffset(n8);
            n7 = mutableJoinTokenList.tokenStartLocalIndex(n8);
            n6 = mutableJoinTokenList.activeTokenListIndex();
            bl3 = true;
        }
        joinTokenListChange.setMatchIndex(n4);
        joinTokenListChange.setMatchOffset(n3);
        Object object = n8 > 0 ? mutableJoinTokenList.state(n8 - 1) : null;
        MutableJoinLexerInputOperation<T> mutableJoinLexerInputOperation = null;
        if (bl2) {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append("  BEFORE-RELEX:\n");
            stringBuilder.append("  relex=").append(bl3);
            stringBuilder.append(", reInd=").append(n8).append(", reOff=").append(n);
            stringBuilder.append(", reSta=").append(object).append('\n');
            stringBuilder.append(", maInd=").append(n4).append(", maOff=").append(n3);
            stringBuilder.append('\n');
            LOG.log(Level.FINE, stringBuilder.toString());
        }
        if (bl3) {
            mutableJoinLexerInputOperation = new MutableJoinLexerInputOperation<T>(mutableJoinTokenList, n8, object, n6, n, tokenListListUpdate);
            mutableJoinLexerInputOperation.init();
            joinTokenListChange.setIndex(n8);
            joinTokenListChange.setOffset(n);
            joinTokenListChange.setStartInfo(mutableJoinLexerInputOperation, n7);
            TokenListUpdater.relex(joinTokenListChange, mutableJoinLexerInputOperation, n10);
        } else {
            joinTokenListChange.setNoRelexStartInfo();
        }
        mutableJoinTokenList.replaceTokens(joinTokenListChange, tokenHierarchyEventInfo, true);
        if (bl2) {
            LOG.log(Level.FINE, "\nchange:" + joinTokenListChange + "\nMods:" + joinTokenListChange.toStringMods(4) + "UPDATE-JOINED FINISHED\n");
        }
    }

    private static <T extends TokenId> void relex(TokenListChange<T> tokenListChange, LexerInputOperation<T> lexerInputOperation, int n) {
        Object object;
        Object object2;
        int n2;
        AbstractToken<T> abstractToken;
        boolean bl = LOG.isLoggable(Level.FINE);
        MutableTokenList<T> mutableTokenList = tokenListChange.tokenList();
        int n3 = tokenListChange.matchIndex;
        int n4 = lexerInputOperation.lastTokenEndOffset();
        while ((abstractToken = lexerInputOperation.nextToken()) != null) {
            int n5;
            int n6;
            int n7;
            n2 = lexerInputOperation.lookahead();
            object2 = lexerInputOperation.lexerState();
            if (bl) {
                object = new StringBuilder(100);
                ((StringBuilder)object).append("    LEXED-TOKEN: ");
                n7 = lexerInputOperation.lastTokenEndOffset();
                CharSequence charSequence = mutableTokenList.inputSourceText();
                if (n7 > charSequence.length()) {
                    ((StringBuilder)object).append(n7).append("!! => ");
                    n7 = charSequence.length();
                    ((StringBuilder)object).append(n7);
                }
                ((StringBuilder)object).append('\"');
                abstractToken.dumpText((StringBuilder)object, charSequence);
                ((StringBuilder)object).append('\"');
                abstractToken.dumpInfo((StringBuilder)object, null, false, false, 0);
                ((StringBuilder)object).append("\n");
                LOG.log(Level.FINE, ((StringBuilder)object).toString());
            }
            tokenListChange.addToken(abstractToken, n2, object2);
            n4 = lexerInputOperation.lastTokenEndOffset();
            if (n4 > tokenListChange.matchOffset) {
                do {
                    if (tokenListChange.matchIndex == n) {
                        if (mutableTokenList.isFullyLexed()) {
                            tokenListChange.matchOffset = Integer.MAX_VALUE;
                            break;
                        }
                        tokenListChange.matchOffset = n4;
                        object2 = mutableTokenList.state(tokenListChange.matchIndex - 1);
                        break;
                    }
                    tokenListChange.increaseMatchIndex();
                } while (n4 > tokenListChange.matchOffset);
            }
            if (n4 != tokenListChange.matchOffset || !LexerUtilsConstants.statesEqual(object2, tokenListChange.matchIndex > 0 ? mutableTokenList.state(tokenListChange.matchIndex - 1) : null)) continue;
            if (tokenListChange.matchIndex == n) break;
            int n8 = n6 = tokenListChange.matchIndex > 0 ? mutableTokenList.lookahead(tokenListChange.matchIndex - 1) : 0;
            if (n2 == n6 || n6 <= 1 && n2 <= 1 || n6 <= (n7 = mutableTokenList.tokenOrEmbeddingUnsync(tokenListChange.matchIndex).token().length()) && n2 <= n7 || n2 - n7 <= (n5 = mutableTokenList.lookahead(tokenListChange.matchIndex)) && (n6 <= n7 || n2 >= n6)) break;
            if (bl) {
                LOG.log(Level.FINE, "    EXTRA-RELEX: maInd=" + tokenListChange.matchIndex + ", LA=" + n2 + "\n");
            }
            tokenListChange.increaseMatchIndex();
        }
        lexerInputOperation.release();
        if (tokenListChange.matchOffset != Integer.MAX_VALUE) {
            for (n2 = tokenListChange.addedTokenOrEmbeddingsCount() - 1; n2 >= 1 && tokenListChange.matchIndex > n3; --n2) {
                object2 = tokenListChange.addedTokenOrEmbeddings().get(n2).token();
                object = mutableTokenList.tokenOrEmbeddingUnsync(tokenListChange.matchIndex - 1).token();
                if (((AbstractToken)object2).id() == ((AbstractToken)object).id() && ((Token)object2).length() == ((Token)object).length() && tokenListChange.laState().lookahead(n2) == mutableTokenList.lookahead(tokenListChange.matchIndex - 1) && LexerUtilsConstants.statesEqual(tokenListChange.laState().state(n2), mutableTokenList.state(tokenListChange.matchIndex - 1))) {
                    if (bl) {
                        LOG.log(Level.FINE, "    RETAIN-ORIGINAL at (maInd-1)=" + (tokenListChange.matchIndex - 1) + ", id=" + ((AbstractToken)object).id() + "\n");
                    }
                    tokenListChange.removeLastAddedToken();
                    n4 = tokenListChange.addedEndOffset;
                    continue;
                }
                break;
            }
        } else {
            tokenListChange.setMatchOffset(mutableTokenList.endOffset());
        }
    }

    private static <T extends TokenId> void logModification(MutableTokenList<T> mutableTokenList, TokenHierarchyEventInfo tokenHierarchyEventInfo, boolean bl) {
        int n = tokenHierarchyEventInfo.modOffset();
        int n2 = tokenHierarchyEventInfo.removedLength();
        int n3 = tokenHierarchyEventInfo.insertedLength();
        CharSequence charSequence = mutableTokenList.inputSourceText();
        String string = "";
        if (n3 > 0) {
            string = ", insTxt:\"" + CharSequenceUtilities.debugText((CharSequence)charSequence.subSequence(n, n + n3)) + '\"';
        }
        int n4 = n + n3;
        CharSequence charSequence2 = charSequence.subSequence(Math.max(n4 - 5, 0), n4);
        CharSequence charSequence3 = charSequence.subSequence(n4, Math.min(n4 + 5, charSequence.length()));
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(bl ? "JOINED" : "REGULAR");
        stringBuilder.append("-UPDATE: \"");
        stringBuilder.append(mutableTokenList.languagePath().mimePath()).append("\"\n");
        stringBuilder.append("  modOff=").append(n);
        stringBuilder.append(", text-around:\"").append(charSequence2).append('|');
        stringBuilder.append(charSequence3).append("\", insLen=");
        stringBuilder.append(n3).append(string);
        stringBuilder.append(", remLen=").append(n2);
        stringBuilder.append(", tCnt=").append(mutableTokenList.tokenCountCurrent()).append('\n');
        LOG.log(Level.INFO, stringBuilder.toString());
    }
}

