/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.token;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.lexer.token.PartToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JoinTokenText<T extends TokenId>
implements CharSequence {
    private static final Logger LOG = Logger.getLogger(JoinTokenText.class.getName());
    private List<PartToken<T>> joinedParts;
    private int activePartIndex;
    private CharSequence activeInputText;
    private int activeStartCharIndex;
    private int activeEndCharIndex;
    private int length;

    public JoinTokenText(List<PartToken<T>> list, int n) {
        this.joinedParts = list;
        this.activeInputText = list.get(0).text();
        this.activeEndCharIndex = this.activeInputText.length();
        this.length = n;
    }

    @Override
    public synchronized char charAt(int n) {
        if (n < this.activeStartCharIndex) {
            if (n < 0) {
                throw new IndexOutOfBoundsException("index=" + n + " < 0");
            }
            do {
                --this.activePartIndex;
                if (this.activePartIndex < 0) {
                    LOG.log(Level.WARNING, "Internal error: index=" + n + ", " + this.dumpState());
                }
                this.activeInputText = this.joinedParts.get(this.activePartIndex).text();
                int n2 = this.activeInputText.length();
                this.activeEndCharIndex = this.activeStartCharIndex;
                this.activeStartCharIndex -= n2;
            } while (n < this.activeStartCharIndex);
        } else if (n >= this.activeEndCharIndex) {
            if (n >= this.length) {
                throw new IndexOutOfBoundsException("index=" + n + " >= length()=" + this.length);
            }
            do {
                ++this.activePartIndex;
                this.activeInputText = this.joinedParts.get(this.activePartIndex).text();
                int n3 = this.activeInputText.length();
                this.activeStartCharIndex = this.activeEndCharIndex;
                this.activeEndCharIndex += n3;
            } while (n >= this.activeEndCharIndex);
        }
        return this.activeInputText.charAt(n - this.activeStartCharIndex);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return CharSequenceUtilities.toString((CharSequence)this, (int)n, (int)n2);
    }

    @Override
    public synchronized String toString() {
        return CharSequenceUtilities.toString((CharSequence)this);
    }

    private String dumpState() {
        return "activeTokenListIndex=" + this.activePartIndex + ", activeStartCharIndex=" + this.activeStartCharIndex + ", activeEndCharIndex=" + this.activeEndCharIndex + ", length=" + this.length;
    }
}

