/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public final class ConstantPoolReader
extends FilterInputStream
implements DataInput {
    private char[] lineBuffer;
    static char[] str = new char[1024];
    byte[] bytearr = new byte[1024];

    public ConstantPoolReader(InputStream inputStream) {
        super(inputStream);
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        InputStream inputStream = this.in;
        for (int i = 0; i < n2; i += n3) {
            n3 = inputStream.read(byArray, n + i, n2 - i);
            if (n3 >= 0) continue;
            throw new EOFException();
        }
    }

    public int skipBytes(int n) throws IOException {
        int n2;
        InputStream inputStream = this.in;
        int n3 = 0;
        for (n2 = 0; n2 < n && (n3 = (int)inputStream.skip(n - n2)) > 0; n2 += n3) {
        }
        return n2;
    }

    public boolean readBoolean() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public byte readByte() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public int readUnsignedByte() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public short readShort() throws IOException {
        int n;
        InputStream inputStream = this.in;
        int n2 = inputStream.read();
        if ((n2 | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + n);
    }

    public int readUnsignedShort() throws IOException {
        int n;
        InputStream inputStream = this.in;
        int n2 = inputStream.read();
        if ((n2 | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + n;
    }

    public char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    public int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        InputStream inputStream = this.in;
        int n4 = inputStream.read();
        if ((n4 | (n3 = inputStream.read()) | (n2 = inputStream.read()) | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() throws IOException {
        int n;
        InputStream inputStream = this.in;
        char[] cArray = this.lineBuffer;
        if (cArray == null) {
            cArray = this.lineBuffer = new char[128];
        }
        int n2 = cArray.length;
        int n3 = 0;
        block4: while (true) {
            n = inputStream.read();
            switch (n) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int n4 = inputStream.read();
                    if (n4 == 10 || n4 == -1) break block4;
                    if (!(inputStream instanceof PushbackInputStream)) {
                        inputStream = this.in = new PushbackInputStream(inputStream);
                    }
                    ((PushbackInputStream)inputStream).unread(n4);
                    break block4;
                }
                default: {
                    if (--n2 < 0) {
                        cArray = new char[n3 + 128];
                        n2 = cArray.length - n3 - 1;
                        System.arraycopy(this.lineBuffer, 0, cArray, 0, n3);
                        this.lineBuffer = cArray;
                    }
                    cArray[n3++] = (char)n;
                    continue block4;
                }
            }
            break;
        }
        if (n == -1 && n3 == 0) {
            return null;
        }
        return String.copyValueOf(cArray, 0, n3);
    }

    public String readUTF() throws IOException {
        int n = this.readUnsignedShort();
        if (n > this.bytearr.length) {
            this.bytearr = new byte[n];
        }
        this.readFully(this.bytearr, 0, n);
        return ConstantPoolReader.readUTF(this.bytearr, n);
    }

    byte[] readRawUTF() throws IOException {
        int n = this.readUnsignedShort();
        byte[] byArray = new byte[n];
        this.readFully(byArray, 0, n);
        return byArray;
    }

    static synchronized String readUTF(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        if (n > str.length) {
            str = new char[n];
        }
        while (n2 < n) {
            int n4;
            if ((n4 = byArray[n2++] & 0xFF) >= 224) {
                n4 = (n4 & 0xF) << 12;
                n4 |= (byArray[n2++] & 0x3F) << 6;
                n4 |= byArray[n2++] & 0x3F;
            } else if (n4 >= 192) {
                n4 = (n4 & 0x1F) << 6;
                n4 |= byArray[n2++] & 0x3F;
            }
            ConstantPoolReader.str[n3++] = (char)n4;
        }
        return new String(str, 0, n3);
    }
}

