/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.BracesMatcherFactory;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;
import org.netbeans.spi.editor.bracesmatching.support.BracesMatcherSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BraceHighlighting
implements BracesMatcher,
BracesMatcherFactory {
    private static final Logger LOG = Logger.getLogger(BraceHighlighting.class.getName());
    private static final Map<Language, Map<String, Set<String>>[]> PAIRS = new WeakHashMap<Language, Map<String, Set<String>>[]>();
    private final MatcherContext context;
    private final String topLevelMimeType;
    private TokenSequence<?> seq;
    private int seqStart;
    private int seqEnd;
    private String originText;
    private Map<String, Set<String>> pairsMap;
    private boolean backwards;
    private BracesMatcher defaultMatcher;

    public BraceHighlighting(String string) {
        this(string, null);
    }

    public BraceHighlighting(String string, MatcherContext matcherContext) {
        this.topLevelMimeType = string;
        this.context = matcherContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findOrigin() throws InterruptedException, BadLocationException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            Object object;
            Object object2;
            Language language = null;
            try {
                language = LanguagesManager.getDefault().getLanguage(this.topLevelMimeType);
            }
            catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
                // empty catch block
            }
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.context.getDocument());
            if (language == null || tokenHierarchy == null) {
                int[] nArray = this.defaultFindOrigin(this.context);
                return nArray;
            }
            int n = this.context.getSearchOffset();
            boolean bl = this.context.isSearchingBackward();
            List list = tokenHierarchy.embeddedTokenSequences(n, bl);
            for (int i = list.size() - 1; i >= 0; --i) {
                object2 = (TokenSequence)list.get(i);
                if (!object2.language().mimeType().equals(language.getMimeType())) continue;
                this.seq = object2;
                if (i > 0) {
                    object = (TokenSequence)list.get(i - 1);
                    this.seqStart = object.offset();
                    this.seqEnd = object.offset() + object.token().length();
                    break;
                }
                this.seqStart = 0;
                this.seqEnd = this.context.getDocument().getLength();
                break;
            }
            if (this.seq == null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("TokenSequence with wrong language " + language);
                }
                int[] nArray = null;
                return nArray;
            }
            Map<String, Set<String>>[] mapArray = BraceHighlighting.getPairsMap(language);
            if (mapArray == null) {
                object2 = this.defaultFindOrigin(this.context);
                return object2;
            }
            this.seq.move(n);
            if (this.seq.moveNext()) {
                object2 = new boolean[1];
                object = ((Object)this.seq.token().text()).toString();
                String string = ((String)object).trim();
                if (BraceHighlighting.isOrigin(mapArray, string, (boolean[])object2) && (this.seq.offset() < n || !bl)) {
                    this.originText = string;
                    this.backwards = object2[0];
                    this.pairsMap = this.backwards ? mapArray[1] : mapArray[0];
                    int n2 = this.seq.offset() + ((String)object).indexOf(string);
                    int n3 = string.length();
                    int[] nArray = new int[]{n2, n2 + n3};
                    return nArray;
                }
                while (BraceHighlighting.moveTheSequence(this.seq, bl, this.context.getLimitOffset())) {
                    object = ((Object)this.seq.token().text()).toString();
                    string = ((String)object).trim();
                    if (!BraceHighlighting.isOrigin(mapArray, string, (boolean[])object2)) continue;
                    this.originText = string;
                    this.backwards = object2[0];
                    this.pairsMap = this.backwards ? mapArray[1] : mapArray[0];
                    int n4 = this.seq.offset() + ((String)object).indexOf(string);
                    int n5 = string.length();
                    int[] nArray = new int[]{n4, n4 + n5};
                    return nArray;
                }
            }
            object2 = null;
            return object2;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findMatches() throws InterruptedException, BadLocationException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            String string;
            if (this.defaultMatcher != null) {
                int[] nArray = this.defaultMatcher.findMatches();
                return nArray;
            }
            assert (this.seq != null) : "No token sequence";
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.originText);
            while (BraceHighlighting.moveTheSequence(this.seq, this.backwards, -1)) {
                string = ((Object)this.seq.token().text()).toString();
                String string2 = string.trim();
                int n = arrayList.size() - 1;
                String string3 = (String)arrayList.get(n);
                Set<String> set = this.pairsMap.get(string3);
                if (set != null && set.contains(string2)) {
                    arrayList.remove(n);
                    if (arrayList.size() != 0) continue;
                    int n2 = this.seq.offset() + string.indexOf(string2);
                    int n3 = string2.length();
                    int[] nArray = new int[]{n2, n2 + n3};
                    return nArray;
                }
                if (!this.pairsMap.containsKey(string2)) continue;
                arrayList.add(string2);
            }
            string = null;
            return string;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    public BracesMatcher createMatcher(MatcherContext matcherContext) {
        return new BraceHighlighting(this.topLevelMimeType, matcherContext);
    }

    private static Map<String, Set<String>>[] getPairsMap(Language language) {
        if (!PAIRS.containsKey(language)) {
            HashMap<String, HashSet<String>> hashMap = new HashMap<String, HashSet<String>>();
            HashMap<String, HashSet<String>> hashMap2 = new HashMap<String, HashSet<String>>();
            List<Feature> list = language.getFeatureList().getFeatures("BRACE");
            for (Feature mapArray2 : list) {
                String string = (String)mapArray2.getValue();
                int n = string.indexOf(58);
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                HashSet<String> hashSet = (HashSet<String>)hashMap.get(string2);
                if (hashSet == null) {
                    hashSet = new HashSet<String>();
                    hashMap.put(string2, hashSet);
                }
                hashSet.add(string3);
                HashSet<String> hashSet2 = (HashSet<String>)hashMap2.get(string3);
                if (hashSet2 == null) {
                    hashSet2 = new HashSet<String>();
                    hashMap2.put(string3, hashSet2);
                }
                hashSet2.add(string2);
            }
            Map[] mapArray = new Map[]{hashMap, hashMap2};
            PAIRS.put(language, mapArray);
        }
        return PAIRS.get(language);
    }

    private static boolean moveTheSequence(TokenSequence<?> tokenSequence, boolean bl, int n) {
        if (bl) {
            if (tokenSequence.movePrevious()) {
                int n2 = tokenSequence.offset() + tokenSequence.token().length();
                return n == -1 ? true : n2 > n;
            }
        } else if (tokenSequence.moveNext()) {
            int n3 = tokenSequence.offset();
            return n == -1 ? true : n3 < n;
        }
        return false;
    }

    private static boolean isOrigin(Map<String, Set<String>>[] mapArray, String string, boolean[] blArray) {
        Set<String> set = mapArray[0].get(string);
        if (set != null && set.size() > 0) {
            blArray[0] = false;
            return true;
        }
        set = mapArray[1].get(string);
        if (set != null && set.size() > 0) {
            blArray[0] = true;
            return true;
        }
        return false;
    }

    private int[] defaultFindOrigin(MatcherContext matcherContext) throws InterruptedException, BadLocationException {
        this.defaultMatcher = BracesMatcherSupport.defaultMatcher((MatcherContext)matcherContext, (int)-1, (int)-1);
        return this.defaultMatcher.findOrigin();
    }
}

