/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.dlg.AddIndexDialog;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.IndexListNodeInfo;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class AddIndexAction
extends DatabaseAction {
    private static final Logger LOGGER = Logger.getLogger(AddIndexAction.class.getName());

    public void performAction(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length <= 0) {
            return;
        }
        Node node = nodeArray[0];
        try {
            DatabaseNodeInfo databaseNodeInfo = (DatabaseNodeInfo)node.getCookie(DatabaseNodeInfo.class);
            final IndexListNodeInfo indexListNodeInfo = (IndexListNodeInfo)databaseNodeInfo.getParent(this.nodename);
            String string = (String)indexListNodeInfo.get("table");
            String string2 = (String)indexListNodeInfo.get("column");
            Specification specification = (Specification)indexListNodeInfo.getSpecification();
            String string3 = (String)indexListNodeInfo.get("index");
            DriverSpecification driverSpecification = databaseNodeInfo.getDriverSpecification();
            Vector<String> vector = new Vector<String>(5);
            driverSpecification.getColumns(string, "%");
            ResultSet resultSet = driverSpecification.getResultSet();
            HashMap hashMap = new HashMap();
            while (resultSet.next()) {
                hashMap = driverSpecification.getRow();
                vector.add((String)hashMap.get(new Integer(4)));
                hashMap.clear();
            }
            resultSet.close();
            if (vector.size() == 0) {
                throw new Exception(AddIndexAction.bundle().getString("EXC_NoUsableColumnInPlace"));
            }
            final AddIndexDialog addIndexDialog = new AddIndexDialog(vector, specification, databaseNodeInfo);
            addIndexDialog.setIndexName(string + "_idx");
            if (addIndexDialog.run()) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        try {
                            indexListNodeInfo.addIndex(addIndexDialog.getIndexName());
                            indexListNodeInfo.refreshChildren();
                        }
                        catch (DatabaseException databaseException) {
                            LOGGER.log(Level.INFO, databaseException.getMessage(), databaseException);
                            DbUtilities.reportError(DatabaseAction.bundle().getString("ERR_UnableToAddIndex"), databaseException.getMessage());
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.INFO, exception.getMessage(), exception);
            DbUtilities.reportError(AddIndexAction.bundle().getString("ERR_UnableToAddIndex"), exception.getMessage());
        }
    }
}

