/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.table.actions;

import com.jaspersoft.ireport.components.table.TableCell;
import com.jaspersoft.ireport.components.table.TableMatrix;
import com.jaspersoft.ireport.components.table.TableModelUtils;
import com.jaspersoft.ireport.components.table.TableObjectScene;
import com.jaspersoft.ireport.components.table.undo.TableCellResizeUndoableEdit;
import com.jaspersoft.ireport.components.table.widgets.TableCellSeparatorWidget;
import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.IReportManager;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.UndoableEdit;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.widget.SeparatorWidget;
import org.netbeans.api.visual.widget.Widget;

public class TableCellSeparatorMoveProvider
implements MoveProvider {
    int startY = 0;
    int startX = 0;
    boolean reversOrder = false;

    public TableCellSeparatorMoveProvider() {
        this(false);
    }

    public TableCellSeparatorMoveProvider(boolean reversOrder) {
        this.reversOrder = reversOrder;
    }

    public void movementStarted(Widget w) {
        this.startY = w.getPreferredLocation().y;
        this.startX = w.getPreferredLocation().x;
        w.setForeground(AbstractReportObjectScene.EDITING_DESIGN_LINE_COLOR);
    }

    public void movementFinished(Widget w) {
        w.setForeground(new Color(0, 0, 0, 0));
        if (!(w instanceof TableCellSeparatorWidget)) {
            return;
        }
        TableCellSeparatorWidget separator = (TableCellSeparatorWidget)w;
        TableObjectScene scene = (TableObjectScene)w.getScene();
        int delta = 0;
        ArrayList<TableCellResizeUndoableEdit> undos = new ArrayList<TableCellResizeUndoableEdit>();
        int currentPosition = 0;
        if (separator.getOrientation() == SeparatorWidget.Orientation.HORIZONTAL) {
            currentPosition = this.startY;
            delta = w.getPreferredLocation().y - this.startY;
            List<TableCell> cells = ((TableObjectScene)w.getScene()).getTableMatrix().getCells();
            TableMatrix matrix = ((TableObjectScene)w.getScene()).getTableMatrix();
            DesignCell firstNotNullCell = null;
            for (TableCell cell : cells) {
                if (cell.getRow() + cell.getRowSpan() != separator.getIndex() || cell.getCell() == null) continue;
                firstNotNullCell = cell.getCell();
                int oldHeight = matrix.getHorizontalSeparators().get(separator.getIndex()) - matrix.getHorizontalSeparators().get(cell.getRow());
                int newHeight = oldHeight + delta;
                oldHeight = cell.getCell().getHeight();
                cell.getCell().setHeight(Integer.valueOf(newHeight));
                undos.add(new TableCellResizeUndoableEdit(scene.getTable(), scene.getJasperDesign(), cell.getCell(), "Height", Integer.class, oldHeight, newHeight));
            }
            if (firstNotNullCell != null) {
                firstNotNullCell.getEventSupport().firePropertyChange("ROW_HEIGHT", null, (Object)0);
            }
        } else {
            currentPosition = this.startX;
            delta = w.getPreferredLocation().x - this.startX;
            TableMatrix matrix = ((TableObjectScene)w.getScene()).getTableMatrix();
            List<TableCell> cells = matrix.getCells();
            StandardBaseColumn firstNotNullColumn = null;
            for (TableCell cell : cells) {
                if (cell.getType() != 0 || cell.getCol() + cell.getColSpan() != separator.getIndex()) continue;
                int oldWidth = matrix.getVerticalSeparators().get(separator.getIndex()) - matrix.getVerticalSeparators().get(cell.getCol());
                int newWidth = oldWidth + delta;
                oldWidth = cell.getColumn().getWidth();
                ((StandardBaseColumn)cell.getColumn()).setWidth(Integer.valueOf(newWidth));
                firstNotNullColumn = (StandardBaseColumn)cell.getColumn();
                undos.add(new TableCellResizeUndoableEdit(scene.getTable(), scene.getJasperDesign(), (StandardBaseColumn)cell.getColumn(), "Width", Integer.class, oldWidth, newWidth));
            }
            if (firstNotNullColumn != null) {
                firstNotNullColumn.getEventSupport().firePropertyChange("COLUMN_WIDTH", null, (Object)0);
            }
        }
        if (delta != 0 && undos.size() > 0) {
            TableCellResizeUndoableEdit mainUndo = (TableCellResizeUndoableEdit)((Object)undos.get(0));
            mainUndo.setMain(true);
            for (int i = 1; i < undos.size(); ++i) {
                TableCellResizeUndoableEdit undo = (TableCellResizeUndoableEdit)((Object)undos.get(i));
                mainUndo.concatenate((UndoableEdit)((Object)undo));
            }
            IReportManager.getInstance().addUndoableEdit((UndoableEdit)((Object)mainUndo), false);
            TableModelUtils.fixTableLayout(scene.getTable(), scene.getJasperDesign());
        }
    }

    public Point getOriginalLocation(Widget widget) {
        return widget.getPreferredLocation();
    }

    public void setNewLocation(Widget widget, Point newLocation) {
        widget.setPreferredLocation(newLocation);
    }
}

