/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.ObjectSceneSelectionManager;
import com.jaspersoft.ireport.designer.ReportObjectSelectProvider;
import com.jaspersoft.ireport.designer.actions.ElementF2Action;
import com.jaspersoft.ireport.designer.actions.ReportElementPopupMenuProvider;
import com.jaspersoft.ireport.designer.actions.ReportPopupMenuProvider;
import com.jaspersoft.ireport.designer.actions.ReportTextElementInplaceEditorProvider;
import com.jaspersoft.ireport.designer.actions.SelectAction;
import com.jaspersoft.ireport.designer.ruler.GuideLine;
import com.jaspersoft.ireport.designer.ruler.GuideLineChangedListener;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.designer.widgets.GuideLineWidget;
import com.jaspersoft.ireport.designer.widgets.JRDesignElementWidget;
import com.jaspersoft.ireport.designer.widgets.SelectionWidget;
import com.jaspersoft.ireport.designer.widgets.UnscaledDecoratorWidget;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.draw.DrawVisitor;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.AlignWithMoveDecorator;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public abstract class AbstractReportObjectScene
extends ObjectScene
implements GuideLineChangedListener {
    public static Color DESIGN_LINE_COLOR = new Color(170, 170, 255);
    public static Color EDITING_DESIGN_LINE_COLOR = Color.DARK_GRAY;
    public static Color GRID_LINE_COLOR = new Color(230, 230, 230);
    private ObjectSceneSelectionManager selectionManager = null;
    private WidgetAction reportSelectAction = null;
    protected LayerWidget elementsLayer = null;
    protected LayerWidget selectionLayer = null;
    protected LayerWidget guideLinesLayer = null;
    protected boolean gridVisible = false;
    protected boolean snapToGrid = false;
    protected static final BasicStroke STROKE = new BasicStroke(1.0f, 2, 0, 5.0f, new float[]{6.0f, 3.0f}, 0.0f);
    protected static final AlignWithMoveDecorator ALIGN_WITH_MOVE_DECORATOR_DEFAULT = new AlignWithMoveDecorator(){

        public ConnectionWidget createLineWidget(Scene scene) {
            UnscaledDecoratorWidget widget = new UnscaledDecoratorWidget(scene);
            widget.setStroke(STROKE);
            widget.setForeground(Color.BLUE);
            return widget;
        }
    };
    protected static final WidgetAction elementPopupMenuAction = ActionFactory.createPopupMenuAction((PopupMenuProvider)new ReportElementPopupMenuProvider());
    protected static final WidgetAction reportPopupMenuAction = ActionFactory.createPopupMenuAction((PopupMenuProvider)new ReportPopupMenuProvider());
    protected static final InputMap elementInputMap = new InputMap();
    protected static final ActionMap elementActionMap = new ActionMap();
    protected final WidgetAction inplaceEditorAction = ActionFactory.createInplaceEditorAction((InplaceEditorProvider)new ReportTextElementInplaceEditorProvider(new TextFieldInplaceEditor(){

        public boolean isEnabled(Widget widget) {
            JRDesignElement element = this.getElement(widget);
            return element != null && element instanceof JRDesignTextElement;
        }

        public String getText(Widget widget) {
            JRDesignElement element = this.getElement(widget);
            if (element != null && element instanceof JRDesignStaticText) {
                return ((JRDesignStaticText)element).getText();
            }
            if (element != null && element instanceof JRDesignTextField) {
                return Misc.getExpressionText(((JRDesignTextField)element).getExpression());
            }
            return "";
        }

        public void setText(Widget widget, String text) {
            JRDesignElement element = this.getElement(widget);
            if (element != null && element instanceof JRDesignStaticText) {
                this.setValue((JRDesignStaticText)element, (Object)text);
            } else if (element != null && element instanceof JRDesignTextField) {
                this.setValue((JRDesignTextField)element, (Object)text);
            }
        }

        public JRDesignElement getElement(Widget widget) {
            if (widget instanceof JRDesignElementWidget) {
                return ((JRDesignElementWidget)widget).getElement();
            }
            if (widget instanceof SelectionWidget) {
                return this.getElement(((SelectionWidget)widget).getRealWidget());
            }
            return null;
        }

        public void setValue(JRDesignTextField element, Object val) {
            JRDesignExpression oldExp = (JRDesignExpression)element.getExpression();
            JRDesignExpression newExp = null;
            if ((val == null || val.equals("")) && (oldExp == null || oldExp.getValueClassName() == null || oldExp.getValueClassName().equals("java.lang.String"))) {
                element.setExpression(null);
            } else {
                String s = val != null ? val + "" : "";
                newExp = new JRDesignExpression();
                newExp.setText(s);
                newExp.setValueClassName(oldExp != null ? oldExp.getValueClassName() : null);
                element.setExpression((JRExpression)newExp);
            }
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(element, "Expression", JRExpression.class, oldExp, newExp);
            IReportManager.getInstance().addUndoableEdit(urob);
        }

        public void setValue(JRDesignStaticText element, Object val) {
            String oldValue = element.getText();
            String newValue = val + "";
            if (val == null) {
                newValue = "";
            }
            element.setText(newValue);
            ObjectPropertyUndoableEdit opue = new ObjectPropertyUndoableEdit(element, "Text", String.class, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(opue);
        }
    }));
    private HashMap guides_widgets = new HashMap();
    protected JComponent jComponent = null;
    protected HashMap elementGroupListeners = new HashMap();
    private boolean updatingView = false;

    public AbstractReportObjectScene() {
        this.selectionManager = new ObjectSceneSelectionManager(this);
        this.reportSelectAction = this.createReportSelectAction();
        elementInputMap.put(KeyStroke.getKeyStroke("F2"), "ElementF2Action");
        elementActionMap.put("ElementF2Action", new ElementF2Action());
    }

    public void assureVisible(Object object) {
        Widget w = this.findWidget(object);
        if (w != null) {
            JComponent view = this.getView();
            Rectangle visibleRect = view.getVisibleRect();
            Rectangle bounds = w.getBounds();
            bounds.x = w.getLocation().x;
            bounds.y = w.getLocation().y;
            Rectangle newRect = this.convertLocalToScene(bounds);
            newRect = this.convertSceneToView(newRect);
            if (visibleRect.width < newRect.width) {
                newRect.width = visibleRect.width;
            }
            if (visibleRect.height < newRect.height) {
                newRect.height = visibleRect.height;
            }
            view.scrollRectToVisible(newRect);
        }
    }

    public abstract JasperDesign getJasperDesign();

    public abstract void refreshElementGroup(JRElementGroup var1);

    public abstract DrawVisitor getDrawVisitor();

    public LayerWidget getElementsLayer() {
        return this.elementsLayer;
    }

    public LayerWidget getSelectionLayer() {
        return this.selectionLayer;
    }

    public LayerWidget getGuideLinesLayer() {
        return this.guideLinesLayer;
    }

    public boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    public void setSnapToGrid(boolean snapToGrid) {
        if (this.snapToGrid != snapToGrid) {
            this.snapToGrid = snapToGrid;
        }
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public void setGridVisible(boolean gridVisible) {
        if (this.gridVisible != gridVisible) {
            this.gridVisible = gridVisible;
        }
    }

    public void guideLineAdded(GuideLine guideLine) {
        JComponent view = this.getView();
        GuideLineWidget guideLineWidget = new GuideLineWidget((Scene)this, guideLine);
        if (guideLine.isVertical()) {
            int y0 = 0;
            if (this.getJasperDesign() != null) {
                y0 = this.getJasperDesign().getTopMargin();
            }
            guideLineWidget.setPreferredLocation(new Point(-10, guideLine.getPosition() + y0));
            guideLineWidget.setPreferredBounds(new Rectangle(0, 0, this.getJasperDesign().getPageWidth() + 10, 1));
        } else {
            int x0 = 0;
            if (this.getJasperDesign() != null) {
                x0 = this.getJasperDesign().getLeftMargin();
            }
            guideLineWidget.setPreferredLocation(new Point(guideLine.getPosition() + x0, -10));
            guideLineWidget.setPreferredBounds(new Rectangle(0, 0, 1, ModelUtils.getDesignHeight(this.getJasperDesign()) + 10));
        }
        this.guideLinesLayer.addChild((Widget)guideLineWidget);
        this.guides_widgets.put(guideLine, guideLineWidget);
        guideLineWidget.repaint();
        this.validate();
    }

    public void guideLineRemoved(GuideLine guideLine) {
        GuideLineWidget w = (GuideLineWidget)((Object)this.guides_widgets.get(guideLine));
        if (w != null) {
            w.removeFromParent();
            this.validate();
        }
    }

    public void guideLineMoved(GuideLine guideLine) {
        GuideLineWidget w = (GuideLineWidget)((Object)this.guides_widgets.get(guideLine));
        if (w != null) {
            if (guideLine.isVertical()) {
                int y0 = 0;
                if (this.getJasperDesign() != null) {
                    y0 = this.getJasperDesign().getTopMargin();
                }
                w.setPreferredLocation(new Point(-10, guideLine.getPosition() + y0));
            } else {
                int x0 = 0;
                if (this.getJasperDesign() != null) {
                    x0 = this.getJasperDesign().getLeftMargin();
                }
                w.setPreferredLocation(new Point(guideLine.getPosition() + x0, -10));
            }
            this.validate();
        }
    }

    public JComponent getJComponent() {
        if (this.jComponent == null) {
            this.jComponent = this.createView();
        }
        return this.jComponent;
    }

    public ObjectSceneSelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public WidgetAction getReportSelectAction() {
        return this.reportSelectAction;
    }

    public void setReportSelectAction(WidgetAction reportSelectAction) {
        this.reportSelectAction = reportSelectAction;
    }

    public boolean isUpdatingView() {
        return this.updatingView;
    }

    public void setUpdatingView(boolean updatingView) {
        this.updatingView = updatingView;
    }

    public WidgetAction createReportSelectAction() {
        return new SelectAction(new ReportObjectSelectProvider(this));
    }

    public Point getParentLocation(JasperDesign jd, JRDesignElement element, JRDesignElementWidget widget) {
        Point p = ModelUtils.getParentLocationImpl(jd, element, widget);
        return p;
    }

    public Rectangle getParentBounds(JasperDesign jd, JRDesignElement element, JRDesignElementWidget widget) {
        return ModelUtils.getParentBoundsImpl(jd, element, widget);
    }

    public JRDesignElementWidget findCustomComponentOwner(JRDesignElement element) {
        while (element.getElementGroup() != null && element.getElementGroup() instanceof JRDesignFrame) {
            element = (JRDesignFrame)element.getElementGroup();
        }
        List widgets = this.elementsLayer.getChildren();
        for (Widget widget : widgets) {
            JRDesignElementWidget dew;
            if (!(widget instanceof JRDesignElementWidget) || !((dew = (JRDesignElementWidget)widget).getElement() instanceof JRDesignComponentElement) || dew.getChildrenElements() == null || !dew.getChildrenElements().contains(element)) continue;
            return dew;
        }
        return null;
    }

    public Object dropElementAt(JRDesignElement element, Point location) {
        return null;
    }

    public abstract boolean acceptDropAt(Point var1);

    public boolean isValidPosition(JRDesignElementWidget elementWidget) {
        Rectangle bounds = this.getParentBounds(this.getJasperDesign(), elementWidget.getElement(), elementWidget);
        if (elementWidget.getElement().getElementGroup() instanceof JRBand) {
            return bounds.height >= elementWidget.getElement().getY() + elementWidget.getElement().getHeight();
        }
        return bounds.height >= elementWidget.getElement().getY() + elementWidget.getElement().getHeight() && elementWidget.getElement().getX() >= 0 && elementWidget.getElement().getY() >= 0 && bounds.width >= elementWidget.getElement().getX() + elementWidget.getElement().getWidth();
    }

    protected final class GroupChangeListener
    implements PropertyChangeListener {
        WeakReference<JRDesignElementGroup> group = null;

        public GroupChangeListener(JRDesignElementGroup group) {
            this.group = new WeakReference<JRDesignElementGroup>(group);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (this.group.get() != null) {
                AbstractReportObjectScene.this.refreshElementGroup((JRElementGroup)this.group.get());
            }
        }
    }
}

