/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.connection;

import com.jaspersoft.ireport.designer.connection.JDBCConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.connection.ConnectionProvider;

public class HibernateConnectionProvider
implements ConnectionProvider {
    Connection conn = null;
    int useCounter = 0;
    JDBCConnection irConnection = null;

    public void configure(Properties props) throws HibernateException {
        this.irConnection = new JDBCConnection();
        this.irConnection.setJDBCDriver(props.getProperty("hibernate.connection.driver_class"));
        this.irConnection.setUsername(props.getProperty("hibernate.connection.username"));
        this.irConnection.setPassword(props.getProperty("hibernate.connection.password"));
        this.irConnection.setUrl(props.getProperty("hibernate.connection.url"));
    }

    public Connection getConnection() throws SQLException {
        try {
            if (this.conn == null || this.conn.isClosed()) {
                this.conn = this.irConnection.getConnection();
                this.useCounter = 1;
            }
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
        catch (Exception ex) {
            throw new SQLException(ex.getMessage());
        }
        return this.conn;
    }

    public void closeConnection(Connection c) throws SQLException {
        if (this.conn != null && this.useCounter == 1) {
            this.conn.close();
        }
        --this.useCounter;
    }

    public void close() throws HibernateException {
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }
}

