/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.connection;

import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.connection.JRHibernateConnection;
import com.jaspersoft.ireport.designer.connection.gui.JRSpringLoadedHibernateConnectionEditor;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.hibernate.type.Type;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class JRSpringLoadedHibernateConnection
extends JRHibernateConnection {
    private static final String PROP_KEY_SPRING_CONFIG = "spring.loaded.hibernate.spring.config";
    private static final String PROP_KEY_SESSION_FACTORY_ID = "spring.loaded.hibernate.session.factory.id";
    private String springConfig = null;
    private String sessionFactoryBeanId = null;

    public ApplicationContext getApplicationContext() {
        StringTokenizer parser = new StringTokenizer(this.getSpringConfig(), ",");
        String[] configs = new String[parser.countTokens()];
        int iCount = 0;
        while (parser.hasMoreTokens()) {
            configs[iCount++] = parser.nextToken();
        }
        return new ClassPathXmlApplicationContext(configs);
    }

    public String getSessionFactoryBeanId() {
        return this.sessionFactoryBeanId;
    }

    public void setSessionFactoryBeanId(String sessionFactoryBeanId) {
        this.sessionFactoryBeanId = sessionFactoryBeanId;
    }

    public String getSpringConfig() {
        return this.springConfig;
    }

    public void setSpringConfig(String springConfig) {
        this.springConfig = springConfig;
    }

    public SessionFactory getSessionFactory() {
        return (SessionFactory)this.getApplicationContext().getBean(this.getSessionFactoryBeanId());
    }

    public HashMap getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PROP_KEY_SESSION_FACTORY_ID, this.getSessionFactoryBeanId());
        map.put(PROP_KEY_SPRING_CONFIG, this.getSpringConfig());
        return map;
    }

    public void loadProperties(HashMap map) {
        this.setSessionFactoryBeanId((String)map.get(PROP_KEY_SESSION_FACTORY_ID));
        this.setSpringConfig((String)map.get(PROP_KEY_SPRING_CONFIG));
    }

    public String getDescription() {
        return "Spring loaded Hibernate connection";
    }

    public IReportConnectionEditor getIReportConnectionEditor() {
        return new JRSpringLoadedHibernateConnectionEditor();
    }

    public void test() throws Exception {
        try {
            Thread thread = Thread.currentThread();
            IReportManager.getInstance();
            thread.setContextClassLoader(IReportManager.getReportClassLoader());
            SessionFactory sf = this.getSessionFactory();
            if (sf == null) {
                JOptionPane.showMessageDialog(Misc.getMainWindow(), "No session factory returned.  Check your session factory bean id against the spring configuration.", "Error", 0);
            } else {
                Session hb_session = sf.openSession();
                Transaction transaction = hb_session.beginTransaction();
                Query q = hb_session.createQuery("select address as address Address as address");
                q.setFetchSize(1);
                Iterator iterator = q.iterate();
                String[] aliases = q.getReturnAliases();
                Type[] types = q.getReturnTypes();
                JOptionPane.showMessageDialog(Misc.getMainWindow(), "iReport successfully created a Hibernate session factory from your Spring configuration.", "", 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(Misc.getMainWindow(), e.getMessage(), "Error", 0);
        }
    }
}

