/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.jrctx;

import com.jaspersoft.ireport.designer.jrctx.JRCTXDataObject;
import com.jaspersoft.ireport.designer.jrctx.JRCTXEditorSupport;
import com.jaspersoft.ireport.designer.jrctx.JRCTXVisualView;
import com.jaspersoft.ireport.designer.utils.Misc;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import net.sf.jasperreports.chartthemes.simple.ChartThemeSettings;
import net.sf.jasperreports.chartthemes.simple.XmlChartTheme;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class JRCTXSourceEditor
extends CloneableEditor
implements MultiViewElement,
Runnable {
    private JComponent toolbar;
    private MultiViewElementCallback callback;

    public JRCTXSourceEditor() {
    }

    JRCTXSourceEditor(JRCTXEditorSupport ed) {
        super((CloneableEditorSupport)ed);
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public void componentShowing() {
        super.componentShowing();
        ChartThemeSettings template = ((JRCTXEditorSupport)this.cloneableEditorSupport()).getCurrentModel();
        if (template != null && ((JRCTXEditorSupport)this.cloneableEditorSupport()).isModified()) {
            try {
                String content = null;
                try {
                    content = XmlChartTheme.saveSettings((ChartThemeSettings)template);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(Misc.getMainWindow(), "Error saving the JRCTX: " + ex.getMessage() + "\nSee the log file for more details.", "Error saving", 0);
                    ex.printStackTrace();
                    return;
                }
                if (content != null) {
                    this.getEditorPane().setText(content);
                    this.getEditorPane().setCaretPosition(0);
                }
                ((JRCTXVisualView)((JRCTXEditorSupport)this.cloneableEditorSupport()).descriptions[0]).setNeedModelRefresh(false);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        ((JRCTXEditorSupport)this.cloneableEditorSupport()).setCurrentModel(null);
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolbar == null) {
            Document doc;
            JEditorPane pane = this.pane;
            if (pane != null && (doc = pane.getDocument()) instanceof NbDocument.CustomToolbar) {
                this.toolbar = ((NbDocument.CustomToolbar)doc).createToolbar(pane);
            }
            if (this.toolbar == null) {
                this.toolbar = new JPanel();
            }
        }
        return this.toolbar;
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
        this.callback = callback;
    }

    public void componentOpened() {
        super.componentOpened();
    }

    public void componentClosed() {
        super.componentClosed();
    }

    public void componentHidden() {
        super.componentHidden();
    }

    public void componentActivated() {
        super.componentActivated();
    }

    public void componentDeactivated() {
        super.componentDeactivated();
    }

    public CloseOperationState canCloseElement() {
        return CloseOperationState.STATE_OK;
    }

    public void updateName() {
        Runnable run = new Runnable(){

            public void run() {
                MultiViewElementCallback c = JRCTXSourceEditor.this.callback;
                if (c == null) {
                    return;
                }
                TopComponent tc = c.getTopComponent();
                if (tc == null) {
                    return;
                }
                Node nd = ((JRCTXDataObject)((JRCTXEditorSupport)JRCTXSourceEditor.this.cloneableEditorSupport()).getDataObject()).getNodeDelegate();
                tc.setName(nd.getName());
                tc.setDisplayName(nd.getDisplayName());
                tc.setHtmlDisplayName(nd.getHtmlDisplayName());
                tc.setIcon(nd.getIcon(1));
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    public void run() {
        MultiViewElementCallback c = this.callback;
        if (c == null) {
            return;
        }
        TopComponent tc = c.getTopComponent();
        if (tc == null) {
            return;
        }
        super.updateName();
        Node nd = ((JRCTXDataObject)((JRCTXEditorSupport)this.cloneableEditorSupport()).getDataObject()).getNodeDelegate();
        tc.setName(nd.getName());
        tc.setDisplayName(nd.getDisplayName());
        tc.setHtmlDisplayName(nd.getHtmlDisplayName());
    }

    public Lookup getLookup() {
        return ((JRCTXDataObject)((JRCTXEditorSupport)this.cloneableEditorSupport()).getDataObject()).getNodeDelegate().getLookup();
    }
}

