/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.dnd.DnDUtilities;
import com.jaspersoft.ireport.designer.menu.SortParametersAction;
import com.jaspersoft.ireport.designer.outline.NewTypesUtils;
import com.jaspersoft.ireport.designer.outline.nodes.IRIndexedNode;
import com.jaspersoft.ireport.designer.outline.nodes.ParameterNode;
import com.jaspersoft.ireport.designer.outline.nodes.ParametersChildren;
import com.jaspersoft.ireport.designer.outline.nodes.SortableParametersNode;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.actions.NewAction;
import org.openide.actions.PasteAction;
import org.openide.actions.ReorderAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class ParametersNode
extends IRIndexedNode
implements PropertyChangeListener,
SortableParametersNode {
    private JasperDesign jd = null;
    private JRDesignDataset dataset = null;
    private boolean sort = false;
    private boolean sorting = false;

    public ParametersNode(JasperDesign jd, Lookup doLkp) {
        this(jd, (JRDesignDataset)jd.getMainDataset(), doLkp);
    }

    public ParametersNode(JasperDesign jd, JRDesignDataset dataset, Lookup doLkp) {
        this(new ParametersChildren(jd, dataset, doLkp), jd, dataset, doLkp);
    }

    public ParametersNode(ParametersChildren pc, JasperDesign jd, JRDesignDataset dataset, Lookup doLkp) {
        super((Children)pc, pc.getIndex(), (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.fixed((Object[])new Object[]{jd, dataset})}));
        this.addNodeListener(new NodeListener(){

            public void childrenAdded(NodeMemberEvent ev) {
            }

            public void childrenRemoved(NodeMemberEvent ev) {
            }

            public void childrenReordered(NodeReorderEvent ev) {
                if (ParametersNode.this.isSorting() || ParametersNode.this.isSort()) {
                    return;
                }
                List list = ParametersNode.this.getDataset().getParametersList();
                ArrayList<JRDesignParameter> newList = new ArrayList<JRDesignParameter>();
                for (int i = 0; i < list.size(); ++i) {
                    JRDesignParameter p = (JRDesignParameter)list.get(i);
                    if (!p.isSystemDefined()) continue;
                    newList.add(p);
                }
                Node[] nodes = ParametersNode.this.getChildren().getNodes();
                for (int i = 0; i < nodes.length; ++i) {
                    JRDesignParameter p = ((ParameterNode)nodes[i]).getParameter();
                    if (p.isSystemDefined()) continue;
                    newList.add(p);
                }
                list.clear();
                list.addAll(newList);
                ParametersNode.this.getDataset().getEventSupport().firePropertyChange(new PropertyChangeEvent(ParametersNode.this.getDataset(), "parameters", null, null));
            }

            public void nodeDestroyed(NodeEvent ev) {
            }

            public void propertyChange(PropertyChangeEvent evt) {
            }
        });
        this.jd = jd;
        if (dataset == null) {
            dataset = jd.getMainDesignDataset();
        }
        this.dataset = dataset;
        dataset.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        this.setDisplayName(I18n.getString("ParameterNode.Property.Parameters"));
        this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/parameters-16.png");
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        JRDesignParameter parameter;
        final Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        final int dropAction = DnDUtilities.getTransferAction(t);
        if (null != dropNode && null != (parameter = (JRDesignParameter)dropNode.getLookup().lookup(JRDesignParameter.class))) {
            if (this.isSort() && this.getDataset().getParametersList().contains(parameter)) {
                return null;
            }
            return new PasteType(){

                public Transferable paste() throws IOException {
                    if (parameter.isSystemDefined()) {
                        return null;
                    }
                    List list = ParametersNode.this.getDataset().getParametersList();
                    int currentIndex = -1;
                    int lastSystemDefinedParameterIndex = -1;
                    for (int i = 0; i < list.size(); ++i) {
                        JRDesignParameter p = (JRDesignParameter)list.get(i);
                        if (p == parameter) {
                            currentIndex = i;
                        }
                        if (!p.isSystemDefined()) continue;
                        lastSystemDefinedParameterIndex = i;
                    }
                    if ((dropAction & 6) != 0) {
                        int newIndex = -1;
                        if (currentIndex != -1) {
                            Node[] nodes = ParametersNode.this.getChildren().getNodes();
                            for (int i = 0; i < nodes.length; ++i) {
                                if (((ParameterNode)nodes[i]).getParameter() != parameter) continue;
                                newIndex = i;
                                break;
                            }
                            list.remove(parameter);
                            if (newIndex == -1) {
                                list.add(parameter);
                            } else {
                                list.add(Math.max(newIndex, lastSystemDefinedParameterIndex + 1), parameter);
                            }
                        } else {
                            try {
                                JRDesignParameter newParam = ModelUtils.cloneParameter(parameter);
                                Map map = ParametersNode.this.getDataset().getParametersMap();
                                int k = 1;
                                while (map.containsKey(newParam.getName())) {
                                    newParam.setName(parameter.getName() + "_" + k);
                                    ++k;
                                }
                                ParametersNode.this.getDataset().addParameter((JRParameter)newParam);
                                if (dropNode.getParentNode() instanceof ParametersNode) {
                                    ParametersNode pn = (ParametersNode)dropNode.getParentNode();
                                    pn.getDataset().removeParameter((JRParameter)parameter);
                                }
                            }
                            catch (JRException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    } else {
                        try {
                            JRDesignParameter newParam = ModelUtils.cloneParameter(parameter);
                            Map map = ParametersNode.this.getDataset().getParametersMap();
                            int k = 1;
                            while (map.containsKey(newParam.getName())) {
                                newParam.setName(parameter.getName() + "_" + k);
                                ++k;
                            }
                            ParametersNode.this.getDataset().addParameter((JRParameter)newParam);
                        }
                        catch (JRException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    return null;
                }
            };
        }
        return null;
    }

    protected void createPasteTypes(Transferable t, List s) {
        super.createPasteTypes(t, s);
        PasteType paste = this.getDropType(t, 2, -1);
        if (null != paste) {
            s.add(paste);
        }
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(NewAction.class), SystemAction.get(PasteAction.class), SystemAction.get(ReorderAction.class), SystemAction.get(SortParametersAction.class)};
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean hasCustomizer() {
        return true;
    }

    public JasperDesign getJasperDesign() {
        return this.jd;
    }

    public JRDesignDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(JRDesignDataset dataset) {
        this.dataset = dataset;
    }

    public NewType[] getNewTypes() {
        return NewTypesUtils.getNewType((Node)this, 1);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        IReportManager.getInstance().notifyReportChange();
        if (evt.getPropertyName().equals("parameters")) {
            ((ParametersChildren)this.getChildren()).recalculateKeys();
        }
    }

    public boolean isSort() {
        return this.sort;
    }

    public void setSort(boolean sort) {
        this.sort = sort;
        if (sort) {
            this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/parameters-sort-16.png");
        } else {
            this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/parameters-16.png");
        }
        this.fireIconChange();
        if (this.getChildren() != null && this.getChildren() instanceof ParametersChildren) {
            this.setSorting(true);
            ((ParametersChildren)this.getChildren()).recalculateKeys();
            this.setSorting(false);
        }
    }

    public boolean isSorting() {
        return this.sorting;
    }

    public void setSorting(boolean sorting) {
        this.sorting = sorting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSorting() {
        if (!this.isSort()) {
            return;
        }
        this.setSorting(true);
        try {
            Node[] nodes = this.getChildren().getNodes();
            ArrayList<Node> nodesList = new ArrayList<Node>(Arrays.asList(nodes));
            Arrays.sort(nodes, new Comparator<Node>(){

                @Override
                public int compare(Node o1, Node o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            int[] ints = new int[nodes.length];
            for (int i = 0; i < ints.length; ++i) {
                ints[nodesList.indexOf((Object)nodes[i])] = i;
            }
            ((ParametersChildren)this.getChildren()).forceReorder(ints);
        }
        finally {
            this.setSorting(false);
        }
    }
}

