/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.properties;

import com.jaspersoft.ireport.designer.sheet.properties.FloatProperty;
import com.jaspersoft.ireport.locale.I18n;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.type.LineSpacingEnum;

public class LineSpacingSizeProperty
extends FloatProperty {
    private JRDesignTextElement element = null;

    public LineSpacingSizeProperty(JRDesignTextElement element) {
        super(element);
        this.element = element;
    }

    public String getName() {
        return "lineSpacingSize";
    }

    public String getDisplayName() {
        return I18n.getString("Global.Property.LineSpacingSize");
    }

    public String getShortDescription() {
        return I18n.getString("Global.Property.LineSpacingSize.desc");
    }

    public Float getFloat() {
        return this.element.getParagraph().getLineSpacingSize() == null ? new Float(0.0f) : this.element.getParagraph().getLineSpacingSize();
    }

    public Float getOwnFloat() {
        return this.element.getParagraph().getOwnLineSpacingSize() == null ? new Float(0.0f) : this.element.getParagraph().getOwnLineSpacingSize();
    }

    public Float getDefaultFloat() {
        return new Float(0.0f);
    }

    public void setFloat(Float num) {
        if (num == null || num.intValue() == 0) {
            this.element.getParagraph().setLineSpacingSize(null);
        } else {
            this.element.getParagraph().setLineSpacingSize(num);
        }
    }

    public void validateFloat(Float value) {
    }

    public boolean canWrite() {
        LineSpacingEnum val = this.element.getParagraph().getLineSpacing();
        return val != null && val != LineSpacingEnum.DOUBLE && val != LineSpacingEnum.ONE_AND_HALF && val != LineSpacingEnum.SINGLE;
    }
}

