/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.locale;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.openide.util.NbBundle;

public class I18n {
    private static List<ResourceBundle> bundleLocations = new ArrayList<ResourceBundle>();
    public static Map<String, ResourceBundle> cachedBundles = new HashMap<String, ResourceBundle>();
    static final String DEFAULT_PACKAGE = "com/jaspersoft/ireport/locale";

    public static void addBundleLocation(ResourceBundle bundle) {
        if (!bundleLocations.contains(bundle)) {
            bundleLocations.add(bundle);
        }
    }

    private static void printMissingResourceMessage(String key) {
        System.out.println("Missing resouce key: " + key);
    }

    public static String getString(String key) {
        return I18n.getString(I18n.class, key);
    }

    public static String getString(String key, Object[] params) {
        return I18n.getString(I18n.class, key, params);
    }

    public static String getString(String key, Object param) {
        return I18n.getString(I18n.class, key, new Object[]{param});
    }

    public static String getString(String key, Object param1, Object param2) {
        return I18n.getString(I18n.class, key, new Object[]{param1, param2});
    }

    public static String getString(String key, Object param1, Object param2, Object param3) {
        return I18n.getString(I18n.class, key, new Object[]{param1, param2, param3});
    }

    public static String getString(Class clazz, String key) {
        ResourceBundle rb;
        String bundleName = I18n.findName(clazz);
        if (!cachedBundles.containsKey(bundleName)) {
            try {
                cachedBundles.put(bundleName, NbBundle.getBundle((Class)clazz));
            }
            catch (Exception ex) {
                System.out.println("Bundle: " + bundleName + " not found...");
            }
        }
        if ((rb = cachedBundles.get(bundleName)) != null) {
            try {
                return rb.getString(key);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        for (ResourceBundle bundle : bundleLocations) {
            try {
                return bundle.getString(key);
            }
            catch (Exception ex) {
            }
        }
        I18n.printMissingResourceMessage(key);
        return key;
    }

    public static String getString(Class clazz, String key, Object[] params) {
        try {
            String s = I18n.getString(clazz, key);
            return MessageFormat.format(s, params);
        }
        catch (Exception exception) {
            return key;
        }
    }

    private static String findName(Class clazz) {
        String pref = clazz.getName();
        int last = pref.lastIndexOf(46);
        if (last >= 0) {
            pref = pref.substring(0, last + 1);
            return pref + "Bundle";
        }
        return "Bundle";
    }
}

