/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.groups;

import java.awt.EventQueue;
import java.io.IOException;
import java.net.URL;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.project.ui.ProjectTab;
import org.netbeans.modules.project.ui.groups.AdHocGroup;
import org.netbeans.modules.project.ui.groups.DirectoryGroup;
import org.netbeans.modules.project.ui.groups.GroupEditPanel;
import org.netbeans.modules.project.ui.groups.SubprojectsGroup;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Group {
    private static final Logger LOG = Logger.getLogger(Group.class.getName());
    private static final Logger UILOG = Logger.getLogger("org.netbeans.ui.project.groups");
    protected static final Preferences NODE = NbPreferences.forModule(Group.class).node("groups");
    private static final String KEY_ACTIVE = "active";
    protected static final String KEY_NAME = "name";
    protected static final String KEY_KIND = "kind";
    protected static final String KEY_PATH = "path";
    protected static final String KEY_MAIN = "main";
    protected final String id;

    private static Group load(String string) {
        if (string == null) {
            return null;
        }
        String string2 = NODE.node(string).get(KEY_KIND, null);
        if ("adHoc".equals(string2)) {
            return new AdHocGroup(string);
        }
        if ("subprojects".equals(string2)) {
            return new SubprojectsGroup(string);
        }
        if ("directory".equals(string2)) {
            return new DirectoryGroup(string);
        }
        LOG.log(Level.WARNING, "Cannot find project group kind for id={0}", string);
        return null;
    }

    public static SortedSet<Group> allGroups() {
        TreeSet<Group> treeSet = new TreeSet<Group>(Group.displayNameComparator());
        try {
            for (String string : NODE.childrenNames()) {
                LOG.log(Level.FINER, "Considering project group id={0}", string);
                Group group = Group.load(string);
                if (group == null) continue;
                treeSet.add(group);
            }
        }
        catch (BackingStoreException backingStoreException) {
            Exceptions.printStackTrace((Throwable)backingStoreException);
        }
        return treeSet;
    }

    public static Group getActiveGroup() {
        return Group.load(NODE.get(KEY_ACTIVE, null));
    }

    public static void setActiveGroup(Group group) {
        Object object;
        LOG.log(Level.FINE, "set active group: {0}", group);
        if (UILOG.isLoggable(Level.FINER)) {
            object = new LogRecord(Level.FINER, "Group.UI.setActiveGroup");
            ((LogRecord)object).setParameters(new Object[]{group != null ? group.toString(true) : null});
            ((LogRecord)object).setResourceBundle(NbBundle.getBundle(Group.class));
            ((LogRecord)object).setLoggerName(UILOG.getName());
            UILOG.log((LogRecord)object);
        }
        if ((object = Group.getActiveGroup()) != null) {
            ((Group)object).closed();
        }
        if (group != null) {
            NODE.put(KEY_ACTIVE, group.id);
        } else {
            if (object == null) {
                return;
            }
            NODE.remove(KEY_ACTIVE);
        }
        Group.open(group);
    }

    protected static String sanitizeNameAndUniquifyForId(String string) {
        HashSet<String> hashSet;
        String string2 = string.replaceAll("[^a-zA-Z0-9_.-]+", "_");
        try {
            hashSet = new HashSet<String>(Arrays.asList(NODE.childrenNames()));
        }
        catch (BackingStoreException backingStoreException) {
            Exceptions.printStackTrace((Throwable)backingStoreException);
            return string2;
        }
        if (hashSet.contains(string2)) {
            int n = 2;
            while (true) {
                String string3;
                if (!hashSet.contains(string3 = string2 + "_" + n)) {
                    return string3;
                }
                ++n;
            }
        }
        return string2;
    }

    protected Group(String string) {
        this.id = string;
        assert (string.indexOf(47) == -1);
    }

    protected Preferences prefs() {
        return NODE.node(this.id);
    }

    public String getName() {
        String string = this.getNameOrNull();
        if (string == null) {
            string = this.id;
        }
        return string;
    }

    protected String getNameOrNull() {
        return this.prefs().get(KEY_NAME, null);
    }

    public void setName(String string) {
        this.prefs().put(KEY_NAME, string);
        if (this.equals(Group.getActiveGroup())) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ProjectTab.findDefault("projectTabLogical_tc").setGroup(Group.this);
                }
            });
        }
    }

    protected static Project projectForPath(String string) {
        if (string != null) {
            try {
                FileObject fileObject = URLMapper.findFileObject((URL)new URL(string));
                if (fileObject != null && fileObject.isFolder()) {
                    return ProjectManager.getDefault().findProject(fileObject);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return null;
    }

    public Set<Project> getProjects() {
        return this.getProjects(null, 0, 0);
    }

    private Set<Project> getProjects(ProgressHandle progressHandle, int n, int n2) {
        if (progressHandle != null) {
            progressHandle.progress("", n);
        }
        HashSet<Project> hashSet = new HashSet<Project>();
        this.findProjects(hashSet, progressHandle, n, n2);
        if (progressHandle != null) {
            progressHandle.progress("", n2);
        }
        assert (!hashSet.contains(null)) : "Found null in " + hashSet + " from " + this;
        return hashSet;
    }

    protected abstract void findProjects(Set<Project> var1, ProgressHandle var2, int var3, int var4);

    protected static String progressMessage(Project project) {
        return NbBundle.getMessage(Group.class, (String)"Group.progress_project", (Object)ProjectUtils.getInformation((Project)project).getDisplayName());
    }

    public Project getMainProject() {
        return Group.projectForPath(this.prefs().get(KEY_MAIN, null));
    }

    public void setMainProject(Project project) throws IllegalArgumentException {
        LOG.log(Level.FINE, "updating main project for {0} to {1}", new Object[]{this.id, project});
        URL uRL = null;
        if (project != null && this.getProjects().contains(project)) {
            try {
                uRL = project.getProjectDirectory().getURL();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                LOG.log(Level.WARNING, null, fileStateInvalidException);
            }
        }
        if (uRL != null) {
            this.prefs().put(KEY_MAIN, uRL.toExternalForm());
        } else {
            if (project != null) {
                LOG.log(Level.WARNING, "...but not an open project or disk path not found");
            }
            this.prefs().remove(KEY_MAIN);
        }
    }

    private static void open(final Group group) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ProjectTab.findDefault("projectTabLogical_tc").setGroup(group);
            }
        });
        String string = group != null ? NbBundle.getMessage(Group.class, (String)"Group.open_handle", (Object)group.getName()) : NbBundle.getMessage(Group.class, (String)"Group.close_handle");
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string);
        progressHandle.start(200);
        OpenProjects openProjects = OpenProjects.getDefault();
        HashSet<Project> hashSet = new HashSet<Project>(Arrays.asList(openProjects.getOpenProjects()));
        Set set = group != null ? group.getProjects(progressHandle, 10, 100) : Collections.emptySet();
        HashSet<Project> hashSet2 = new HashSet<Project>(hashSet);
        hashSet2.removeAll(set);
        HashSet<Project> hashSet3 = new HashSet<Project>(set);
        hashSet3.removeAll(hashSet);
        assert (!hashSet2.contains(null)) : hashSet2;
        assert (!hashSet3.contains(null)) : hashSet3;
        progressHandle.progress(NbBundle.getMessage(Group.class, (String)"Group.progress_closing", (Object)hashSet2.size()), 120);
        openProjects.close(hashSet2.toArray(new Project[hashSet2.size()]));
        progressHandle.progress(NbBundle.getMessage(Group.class, (String)"Group.progress_opening", (Object)hashSet3.size()), 140);
        openProjects.open(hashSet3.toArray(new Project[hashSet3.size()]), false);
        if (group != null) {
            openProjects.setMainProject(group.getMainProject());
        }
        progressHandle.finish();
    }

    protected void closed() {
        this.setMainProject(OpenProjects.getDefault().getMainProject());
    }

    public void destroy() {
        LOG.log(Level.FINE, "destroying: {0}", this.id);
        if (this.equals(Group.getActiveGroup())) {
            Group.setActiveGroup(null);
        }
        try {
            Preferences preferences = this.prefs();
            preferences.removeNode();
            assert (!preferences.nodeExists("")) : "failed to destroy " + this.id;
        }
        catch (BackingStoreException backingStoreException) {
            Exceptions.printStackTrace((Throwable)backingStoreException);
        }
    }

    public abstract GroupEditPanel createPropertiesPanel();

    public static Comparator<Group> displayNameComparator() {
        return new Comparator<Group>(){
            Collator COLLATOR = Collator.getInstance();

            @Override
            public int compare(Group group, Group group2) {
                return this.COLLATOR.compare(group.getName(), group2.getName());
            }
        };
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof Group && this.id.equals(((Group)object).id);
    }

    public String toString() {
        return this.toString(false);
    }

    protected String toString(boolean bl) {
        return this.getClass().getName().replaceFirst("^.+\\.", "") + "[id=" + (bl ? "#" + this.id.hashCode() : this.id) + ",|projects|=" + this.getProjects().size() + "]";
    }

    public boolean isPristine() {
        return ((Object)this.getProjects()).equals(new HashSet<Project>(Arrays.asList(OpenProjects.getDefault().getOpenProjects())));
    }
}

