/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.inputcontrols.impl;

import com.jaspersoft.ireport.jasperserver.ui.inputcontrols.impl.InputControlUI;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.InputControlQueryDataRow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class TableListInputControlUI
extends JPanel
implements InputControlUI {
    private List<ActionListener> listeners = new ArrayList<ActionListener>();
    private List itemValues = new ArrayList();
    private ButtonGroup buttonGroup1;
    private JLabel jLabelName;
    private JPanel jPanelList;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public TableListInputControlUI() {
        this.initComponents();
        this.jTable1.getParent().setBackground(this.jTable1.getBackground());
        this.jTable1.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                for (ActionListener listener : TableListInputControlUI.this.listeners) {
                    try {
                        listener.actionPerformed(new ActionEvent(this, 0, ""));
                    }
                    catch (Exception ex) {}
                }
            }
        });
    }

    public Object getValue() {
        ArrayList list = new ArrayList();
        int[] selection = this.jTable1.getSelectedRows();
        for (int i = 0; i < selection.length; ++i) {
            list.add(this.itemValues.get(selection[i]));
        }
        return list;
    }

    public void setValue(Object v) {
        if (v != null && v instanceof Collection) {
            this.jTable1.clearSelection();
            for (Object val : (Collection)v) {
                int row = this.itemValues.indexOf(val);
                if (row < 0) continue;
                this.jTable1.addRowSelectionInterval(row, row);
            }
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabelName = new JLabel();
        this.jPanelList = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.setLayout(new GridBagLayout());
        this.setMinimumSize(new Dimension(42, 150));
        this.setPreferredSize(new Dimension(250, 150));
        this.jLabelName.setText("jLabel1");
        this.jLabelName.setMinimumSize(new Dimension(34, 14));
        this.jLabelName.setPreferredSize(new Dimension(34, 14));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.jLabelName, gridBagConstraints);
        this.jPanelList.setLayout(new GridBagLayout());
        this.jPanelList.setBackground(new Color(255, 255, 255));
        this.jScrollPane1.setBackground(new Color(255, 255, 255));
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable1.setGridColor(new Color(255, 255, 255));
        this.jTable1.setIntercellSpacing(new Dimension(0, 0));
        this.jTable1.setOpaque(false);
        this.jTable1.setRowMargin(0);
        this.jTable1.setShowHorizontalLines(false);
        this.jTable1.setShowVerticalLines(false);
        this.jTable1.setTableHeader(null);
        this.jScrollPane1.setViewportView(this.jTable1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelList.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 14, 4, 4);
        this.add((Component)this.jPanelList, gridBagConstraints);
    }

    public void setLabel(String lbl) {
        this.jLabelName.setText(lbl);
    }

    public void setHistory(List values) {
        if (values == null) {
            return;
        }
        int maxColumns = 1;
        Object[][] rowValues = new Object[values.size()][];
        for (int i = 0; i < values.size(); ++i) {
            InputControlQueryDataRow qd = (InputControlQueryDataRow)values.get(i);
            maxColumns = qd.getColumnValues().size() > maxColumns ? qd.getColumnValues().size() : maxColumns;
            rowValues[i] = new Object[qd.getColumnValues().size()];
            for (int k = 0; k < qd.getColumnValues().size(); ++k) {
                rowValues[i][k] = qd.getColumnValues().get(k);
            }
            this.itemValues.add(qd.getValue());
        }
        Object[] columnNames = new String[maxColumns];
        for (int i = 0; i < maxColumns; ++i) {
            columnNames[i] = "" + i;
        }
        DefaultTableModel dtm = new DefaultTableModel(rowValues, columnNames){

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        };
        this.jTable1.setModel(dtm);
        this.jTable1.setTableHeader(null);
        this.jTable1.updateUI();
        this.jPanelList.updateUI();
        this.updateUI();
    }

    public void setReadOnly(boolean b) {
        for (int i = 0; i < this.jPanelList.getComponentCount(); ++i) {
            Component c = this.jPanelList.getComponent(i);
            if (!(c instanceof JCheckBox)) continue;
            ((JCheckBox)c).setEnabled(!b);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }
}

