/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.standalone.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.standalone.actions.ImportSettingsStatusJDialog;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.openide.util.NbPreferences;

public class ImportSettingsJob
implements Runnable {
    private File dir = null;
    private ImportSettingsStatusJDialog dialog = null;
    private Thread thread = null;
    private Exception result = null;

    public ImportSettingsJob(File dir, boolean showDialog) {
        this.dir = dir;
        this.thread = new Thread(this);
        if (showDialog) {
            this.dialog = new ImportSettingsStatusJDialog(Misc.getMainFrame(), true);
            this.dialog.setImportSettingsJob(this);
        }
    }

    public void start() {
        if (this.dialog != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ImportSettingsJob.this.dialog.setVisible(true);
                }
            });
        }
        this.getThread().start();
    }

    public void cleanUp() {
        if (this.dialog != null) {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ImportSettingsJob.this.dialog.setVisible(false);
                        ImportSettingsJob.this.dialog.dispose();
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void importSettings(File dir, boolean showDialog) throws Exception {
        ImportSettingsJob job = new ImportSettingsJob(dir, showDialog);
        job.start();
        if (job.getResult() != null) {
            throw new Exception(job.getResult());
        }
    }

    public void run() {
        try {
            final File iReportSettingsFile = new File(this.getDir(), "config/Preferences/com/jaspersoft/ireport.properties");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (ImportSettingsJob.this.dialog != null) {
                        ImportSettingsJob.this.dialog.setTextFile(iReportSettingsFile.getPath());
                    }
                }
            });
            int count = 0;
            Preferences prefs = NbPreferences.forModule(IReportManager.class);
            if (iReportSettingsFile.exists()) {
                Properties props = new Properties();
                props.load(new FileInputStream(iReportSettingsFile));
                final int total = props.size();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (ImportSettingsJob.this.dialog != null) {
                            JProgressBar bar = ImportSettingsJob.this.dialog.getProgressBar();
                            bar.setMinimum(0);
                            bar.setMaximum(total);
                            bar.setValue(0);
                        }
                    }
                });
                Enumeration<Object> enumer = props.keys();
                while (enumer.hasMoreElements()) {
                    ++count;
                    String key = (String)enumer.nextElement();
                    if (key.equals("UUID")) continue;
                    prefs.put(key, props.getProperty(key));
                    final int value = count;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (ImportSettingsJob.this.dialog != null) {
                                JProgressBar bar = ImportSettingsJob.this.dialog.getProgressBar();
                                bar.setValue(value);
                            }
                        }
                    });
                }
            } else {
                System.out.println(iReportSettingsFile + "  does not exist");
                System.out.flush();
            }
            File jasperPluginSettingsFile = new File(this.getDir(), "config/Preferences/com/jaspersoft/ireport/jasperserver.properties");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (ImportSettingsJob.this.dialog != null) {
                        ImportSettingsJob.this.dialog.setTextFile(iReportSettingsFile.getPath());
                    }
                }
            });
            prefs = NbPreferences.forModule(JasperServerManager.class);
            if (jasperPluginSettingsFile.exists()) {
                Properties props = new Properties();
                props.load(new FileInputStream(jasperPluginSettingsFile));
                final int total = props.size();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (ImportSettingsJob.this.dialog != null) {
                            JProgressBar bar = ImportSettingsJob.this.dialog.getProgressBar();
                            bar.setMinimum(0);
                            bar.setMaximum(total);
                            bar.setValue(0);
                        }
                    }
                });
                Enumeration<Object> enumer = props.keys();
                while (enumer.hasMoreElements()) {
                    String key = (String)enumer.nextElement();
                    prefs.put(key, props.getProperty(key));
                    final int value = ++count;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (ImportSettingsJob.this.dialog != null) {
                                JProgressBar bar = ImportSettingsJob.this.dialog.getProgressBar();
                                bar.setValue(value);
                            }
                        }
                    });
                }
            } else {
                System.out.println(jasperPluginSettingsFile + "  does not exist");
                System.out.flush();
            }
        }
        catch (Exception ex) {
            this.setResult(ex);
        }
        this.cleanUp();
    }

    public Exception getResult() {
        return this.result;
    }

    public void setResult(Exception result) {
        this.result = result;
    }

    public File getDir() {
        return this.dir;
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public ImportSettingsStatusJDialog getDialog() {
        return this.dialog;
    }

    public void setDialog(ImportSettingsStatusJDialog dialog) {
        this.dialog = dialog;
    }

    public Thread getThread() {
        return this.thread;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }
}

