/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.addons.callouts;

import com.jaspersoft.ireport.addons.callouts.CalloutInplaceEditorProvider;
import com.jaspersoft.ireport.addons.callouts.CalloutsLayer;
import com.jaspersoft.ireport.addons.callouts.CalloutsUtility;
import com.jaspersoft.ireport.addons.callouts.PinWidget;
import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.widgets.JRDesignElementWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.ConnectProvider;
import org.netbeans.api.visual.action.ConnectorState;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.ResizeControlPointResolver;
import org.netbeans.api.visual.action.ResizeProvider;
import org.netbeans.api.visual.action.ResizeStrategy;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.AnchorFactory;
import org.netbeans.api.visual.anchor.AnchorShape;
import org.netbeans.api.visual.anchor.PointShape;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.openide.util.ImageUtilities;

public class CalloutWidget
extends Widget
implements PopupMenuProvider {
    private JTextArea field = null;
    private String text = "";
    private RenderingHints hints = null;
    private JPopupMenu popupMenu = null;
    final WidgetAction inplaceEditorAction = ActionFactory.createInplaceEditorAction((InplaceEditorProvider)new CalloutInplaceEditorProvider(new TextFieldInplaceEditor(){

        public boolean isEnabled(Widget widget) {
            return true;
        }

        public String getText(Widget widget) {
            return ((CalloutWidget)widget).getText();
        }

        public void setText(Widget widget, String text) {
            CalloutsUtility.saveCallouts((AbstractReportObjectScene)CalloutWidget.this.getScene());
        }
    }));

    public CalloutWidget(AbstractReportObjectScene scene) {
        super((Scene)scene);
        this.field = new JTextArea(this.getText());
        this.field.setWrapStyleWord(true);
        this.field.setLineWrap(true);
        this.field.setBorder(new EmptyBorder(new Insets(0, 2, 0, 2)));
        this.field.setBackground(new Color(252, 255, 0, 128));
        this.field.setOpaque(false);
        this.setBackground(new Color(252, 255, 0, 128));
        this.setOpaque(true);
        this.setBorder(BorderFactory.createImageBorder((Insets)new Insets(6, 7, 12, 12), (Insets)new Insets(16, 16, 22, 21), (Image)ImageUtilities.loadImage((String)"/com/jaspersoft/ireport/addons/callouts/borders.png")));
        this.addDependency(new Widget.Dependency(){
            boolean validating = false;

            public void revalidateDependency() {
                if (this.validating) {
                    return;
                }
                if (CalloutWidget.this.getField() == null) {
                    return;
                }
                if (CalloutWidget.this.getBounds() == null && CalloutWidget.this.getPreferredBounds() == null) {
                    return;
                }
                Rectangle bounds = CalloutWidget.this.getBounds();
                if (bounds == null) {
                    bounds = CalloutWidget.this.getPreferredBounds();
                }
                if (bounds == null) {
                    return;
                }
                CalloutWidget.this.getField().setSize(bounds.width - CalloutWidget.this.getBorder().getInsets().left - CalloutWidget.this.getBorder().getInsets().right, CalloutWidget.this.field.getHeight());
                CalloutWidget.this.recalculateFieldSize(false);
                this.validating = true;
                CalloutWidget.this.revalidate();
                CalloutWidget.this.getScene().validate();
                this.validating = false;
            }
        });
        this.setText(System.getProperty("user.name") + " " + new SimpleDateFormat().format(new Date()));
        this.getActions().addAction(ActionFactory.createExtendedConnectAction((LayerWidget)CalloutsUtility.getCalloutsLayer(scene, true), (ConnectProvider)new ConnectProvider(){

            public boolean isSourceWidget(Widget sourceWidget) {
                return sourceWidget == CalloutWidget.this;
            }

            public ConnectorState isTargetWidget(Widget sourceWidget, Widget targetWidget) {
                if (targetWidget instanceof JRDesignElementWidget) {
                    return ConnectorState.ACCEPT;
                }
                return ConnectorState.REJECT;
            }

            public boolean hasCustomTargetWidgetResolver(Scene scene) {
                return false;
            }

            public Widget resolveTargetWidget(Scene scene, Point sceneLocation) {
                return null;
            }

            public void createConnection(Widget sourceWidget, Widget targetWidget) {
                CalloutWidget.this.createPinConnection(new Point(targetWidget.getLocation().x + (targetWidget.getBounds().width + targetWidget.getBounds().x) / 2, targetWidget.getLocation().y + (targetWidget.getBounds().height + targetWidget.getBounds().y) / 2));
            }
        }));
        this.getActions().addAction(ActionFactory.createResizeAction((ResizeStrategy)ActionFactory.createFreeResizeStategy(), (ResizeControlPointResolver)new ResizeControlPointResolver(){

            public ResizeProvider.ControlPoint resolveControlPoint(Widget widget, Point point) {
                Rectangle bounds = widget.getBounds();
                Insets insets = widget.getBorder().getInsets();
                Rectangle spotArea = new Rectangle(bounds.x + bounds.width - insets.right - 10, bounds.y + bounds.height - insets.bottom - 10, 10, 10);
                if (spotArea.contains(point)) {
                    return ResizeProvider.ControlPoint.BOTTOM_RIGHT;
                }
                return null;
            }
        }, (ResizeProvider)new ResizeProvider(){
            Rectangle bounds = null;

            public void resizingStarted(Widget widget) {
                this.bounds = widget.getBounds();
            }

            public void resizingFinished(Widget widget) {
                if (!this.bounds.equals(widget.getBounds())) {
                    CalloutsUtility.saveCallouts((AbstractReportObjectScene)CalloutWidget.this.getScene());
                }
            }
        }));
        this.getActions().addAction(ActionFactory.createMoveAction((MoveStrategy)ActionFactory.createFreeMoveStrategy(), (MoveProvider)new MoveProvider(){
            boolean changed = false;

            public void movementStarted(Widget widget) {
                this.changed = false;
            }

            public void movementFinished(Widget widget) {
                if (this.changed) {
                    CalloutsUtility.saveCallouts((AbstractReportObjectScene)CalloutWidget.this.getScene());
                }
            }

            public Point getOriginalLocation(Widget widget) {
                return widget.getPreferredLocation();
            }

            public void setNewLocation(Widget widget, Point location) {
                if (!location.equals(widget.getPreferredLocation())) {
                    this.changed = true;
                }
                widget.setPreferredLocation(location);
            }
        }));
        this.getActions().addAction(this.inplaceEditorAction);
        this.getActions().addAction(ActionFactory.createPopupMenuAction((PopupMenuProvider)this));
        this.setPreferredBounds(new Rectangle(0, 0, 150, 75));
        this.field.setSize(150 - this.getBorder().getInsets().left - -this.getBorder().getInsets().right, this.field.getHeight());
        this.field.setSize(this.field.getPreferredSize());
        this.recalculateFieldSize(false);
    }

    public JPopupMenu getPopupMenu(Widget widget, Point localLocation) {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            JMenuItem showAllTextCallout = new JMenuItem("Show all text");
            showAllTextCallout.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CalloutWidget.this.recalculateFieldSize(true);
                    CalloutWidget.this.revalidate();
                    CalloutWidget.this.getScene().validate();
                }
            });
            this.popupMenu.add(showAllTextCallout);
            JMenuItem addPin = new JMenuItem("Add pin");
            addPin.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"com/jaspersoft/ireport/addons/callouts/pin-16.png")));
            addPin.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CalloutWidget.this.createPinConnection(null);
                }
            });
            this.popupMenu.add(addPin);
            this.popupMenu.add(new JSeparator());
            JMenuItem deleteCalloutChanges = new JMenuItem("Delete");
            deleteCalloutChanges.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CalloutWidget.this.removeFromParent();
                    CalloutsLayer layer = CalloutsUtility.getCalloutsLayer((AbstractReportObjectScene)CalloutWidget.this.getScene(), true);
                    List connections = layer.getChildren();
                    ArrayList<ConnectionWidget> toBeRemoved = new ArrayList<ConnectionWidget>();
                    for (Widget widget : connections) {
                        ConnectionWidget cw;
                        if (!(widget instanceof ConnectionWidget) || (cw = (ConnectionWidget)widget).getSourceAnchor().getRelatedWidget() != CalloutWidget.this) continue;
                        toBeRemoved.add(cw);
                    }
                    for (ConnectionWidget connectionWidget : toBeRemoved) {
                        connectionWidget.getTargetAnchor().getRelatedWidget().removeFromParent();
                        connectionWidget.removeFromParent();
                    }
                    CalloutsUtility.saveCallouts((AbstractReportObjectScene)CalloutWidget.this.getScene());
                }
            });
            this.popupMenu.add(deleteCalloutChanges);
        }
        return this.popupMenu;
    }

    public JPopupMenu getConnectionPopupMenu(Widget widget, Point localLocation) {
        final Widget connectionWidget = widget;
        JPopupMenu connectionPopupMenu = new JPopupMenu();
        JMenuItem removeConnection = new JMenuItem("Delete connection");
        removeConnection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (connectionWidget instanceof ConnectionWidget) {
                    ((ConnectionWidget)connectionWidget).getTargetAnchor().getRelatedWidget().removeFromParent();
                    connectionWidget.removeFromParent();
                }
            }
        });
        connectionPopupMenu.add(removeConnection);
        return connectionPopupMenu;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        if (text.equals(this.text)) {
            return;
        }
        this.text = text;
        this.recalculateFieldSize(false);
        this.revalidate();
    }

    protected void recalculateFieldSize(boolean force) {
        Dimension oldPreferredSize = this.getField().getPreferredSize();
        this.getField().setText(this.getText());
        Dimension newPreferredSize = this.getField().getPreferredSize();
        if (!newPreferredSize.equals(oldPreferredSize) || force) {
            this.getField().setSize(this.getField().getPreferredSize());
            Rectangle bounds = this.getBounds();
            if (bounds == null) {
                bounds = this.getPreferredBounds();
            }
            int w = this.getField().getPreferredSize().width + this.getBorder().getInsets().left + this.getBorder().getInsets().left;
            int h = this.getField().getPreferredSize().height + this.getBorder().getInsets().top + this.getBorder().getInsets().bottom;
            if (bounds != null) {
                if (w < bounds.width) {
                    w = bounds.width;
                }
                if (h < bounds.height) {
                    h = bounds.height;
                }
            }
            this.setPreferredBounds(new Rectangle(w, h));
        }
    }

    public void createPinConnection(Point p) {
        CalloutsLayer layer = CalloutsUtility.getCalloutsLayer((AbstractReportObjectScene)this.getScene(), true);
        if (p == null) {
            p = new Point(this.getBounds().width / 2 + this.getPreferredLocation().x, this.getPreferredLocation().y + this.getBounds().height + 30);
        }
        this.getScene().validate();
        PinWidget pinWidget = new PinWidget(this.getScene());
        this.getScene().validate();
        pinWidget.setPreferredLocation(p);
        this.getScene().validate();
        layer.addChild((Widget)pinWidget);
        this.getScene().validate();
        ConnectionWidget connection = new ConnectionWidget(this.getScene());
        this.getScene().validate();
        pinWidget.setConnectionWidget(connection);
        connection.setTargetAnchorShape(AnchorShape.NONE);
        connection.setEndPointShape(PointShape.NONE);
        connection.setSourceAnchor(AnchorFactory.createRectangularAnchor((Widget)this));
        connection.setTargetAnchor(AnchorFactory.createRectangularAnchor((Widget)pinWidget));
        connection.getActions().addAction(ActionFactory.createPopupMenuAction((PopupMenuProvider)new PopupMenuProvider(){

            public JPopupMenu getPopupMenu(Widget widget, Point point) {
                return CalloutWidget.this.getConnectionPopupMenu(widget, point);
            }
        }));
        layer.addChild((Widget)connection);
        this.getScene().validate();
        this.getScene().repaint();
    }

    public void paintWidget() {
        if (this.getField() == null) {
            return;
        }
        AffineTransform t = this.getGraphics().getTransform();
        this.getGraphics().translate(this.getBorder().getInsets().left, this.getBorder().getInsets().top);
        Shape clip = this.getGraphics().getClip();
        Area shape = new Area(clip);
        shape.intersect(new Area(new Rectangle2D.Float(0.0f, 0.0f, this.getBounds().width - this.getBorder().getInsets().left - this.getBorder().getInsets().right, this.getBounds().height - this.getBorder().getInsets().top - this.getBorder().getInsets().bottom)));
        this.getGraphics().setClip(shape);
        this.getField().paint(this.getGraphics());
        this.getGraphics().setClip(clip);
        this.getGraphics().setTransform(t);
    }

    public JTextArea getField() {
        return this.field;
    }

    public void setField(JTextArea field) {
        this.field = field;
    }
}

