/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.heartbeat.options;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.heartbeat.options.HeartbeatOptionsPanelController;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class HeartbeatPanel
extends JPanel {
    private final HeartbeatOptionsPanelController controller;
    private boolean init = false;
    private JCheckBox jCheckBoxDisableVersionChecking;
    private JCheckBox jCheckBoxShowDialog;

    HeartbeatPanel(HeartbeatOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
    }

    public boolean setInit(boolean b) {
        boolean old = this.init;
        this.init = b;
        return old;
    }

    public boolean isInit() {
        return this.init;
    }

    public void notifyChange() {
        if (this.controller != null && !this.isInit()) {
            this.controller.changed();
        }
    }

    private void initComponents() {
        this.jCheckBoxShowDialog = new JCheckBox();
        this.jCheckBoxDisableVersionChecking = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxShowDialog, (String)NbBundle.getMessage(HeartbeatPanel.class, (String)"HeartbeatPanel.jCheckBoxShowDialog.text"));
        this.jCheckBoxShowDialog.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxDisableVersionChecking, (String)NbBundle.getMessage(HeartbeatPanel.class, (String)"HeartbeatPanel.jCheckBoxDisableVersionChecking.text"));
        this.jCheckBoxDisableVersionChecking.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HeartbeatPanel.this.jCheckBoxDisableVersionCheckingActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jCheckBoxShowDialog, -1, 297, Short.MAX_VALUE).add((Component)this.jCheckBoxDisableVersionChecking, -1, 297, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jCheckBoxDisableVersionChecking).addPreferredGap(0).add((Component)this.jCheckBoxShowDialog).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jCheckBoxDisableVersionCheckingActionPerformed(ActionEvent evt) {
        this.jCheckBoxShowDialog.setEnabled(!this.jCheckBoxDisableVersionChecking.isSelected());
    }

    void load() {
        this.setInit(true);
        this.jCheckBoxDisableVersionChecking.setSelected(IReportManager.getPreferences().getBoolean("disable_heartbeat", false));
        this.jCheckBoxShowDialog.setSelected(IReportManager.getPreferences().getBoolean("show_update_dialog", true));
        this.jCheckBoxShowDialog.setEnabled(!this.jCheckBoxDisableVersionChecking.isSelected());
        this.setInit(false);
    }

    void store() {
        IReportManager.getPreferences().putBoolean("disable_heartbeat", this.jCheckBoxDisableVersionChecking.isSelected());
        IReportManager.getPreferences().putBoolean("show_update_dialog", this.jCheckBoxShowDialog.isSelected());
    }

    boolean valid() {
        return true;
    }
}

