/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.editor.MultiKeyBinding;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Lookup;

public class MultiKeymap
implements Keymap {
    private static final boolean compatibleIgnoreNextTyped = Boolean.getBoolean("netbeans.editor.keymap.compatible");
    public static final Action EMPTY_ACTION = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
        }
    };
    public static final Action BEEP_ACTION = new DefaultEditorKit.BeepAction();
    private Keymap delegate;
    private Keymap context;
    private boolean ignoreNextTyped = false;
    private Action contextKeyNotFoundAction = BEEP_ACTION;
    private List contextKeys;

    public MultiKeymap(String string) {
        this.delegate = JTextComponent.addKeymap(string, null);
        this.contextKeys = new ArrayList();
    }

    void setContext(Keymap keymap) {
        this.context = keymap;
    }

    private static String getKeyText(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return "";
        }
        String string = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
        if ("".equals(string)) {
            return KeyEvent.getKeyText(keyStroke.getKeyCode());
        }
        return string + "+" + KeyEvent.getKeyText(keyStroke.getKeyCode());
    }

    public void resetContext() {
        this.context = null;
        this.contextKeys.clear();
    }

    private void shiftGlobalContext(KeyStroke keyStroke) {
        List list = this.getGlobalContextList();
        if (list != null) {
            list.add(keyStroke);
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(MultiKeymap.getKeyText((KeyStroke)iterator.next())).append(' ');
            }
            StatusDisplayer.getDefault().setStatusText(stringBuffer.toString());
        }
        this.contextKeys.add(keyStroke);
    }

    private void resetGlobalContext() {
        List list = this.getGlobalContextList();
        if (list != null) {
            list.clear();
            StatusDisplayer.getDefault().setStatusText("");
        }
    }

    private List getGlobalContextList() {
        List list;
        try {
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            Class<?> clazz = Class.forName("org.netbeans.core.NbKeymap", true, classLoader);
            Field field = clazz.getDeclaredField("context");
            field.setAccessible(true);
            list = (List)field.get(null);
        }
        catch (Exception exception) {
            list = null;
        }
        return list;
    }

    public void setContextKeyNotFoundAction(Action action) {
        this.contextKeyNotFoundAction = action;
    }

    public void load(JTextComponent.KeyBinding[] keyBindingArray, Action[] actionArray) {
        HashMap<String, Action> hashMap = new HashMap<String, Action>(keyBindingArray.length);
        for (int i = 0; i < actionArray.length; ++i) {
            Action action = actionArray[i];
            String string = (String)action.getValue("Name");
            hashMap.put(string != null ? string : "", action);
        }
        this.load(keyBindingArray, hashMap);
    }

    public void load(JTextComponent.KeyBinding[] keyBindingArray, Map map) {
        for (int i = 0; i < keyBindingArray.length; ++i) {
            Action action = (Action)map.get(keyBindingArray[i].actionName);
            if (action == null) continue;
            boolean bl = false;
            if (keyBindingArray[i] instanceof MultiKeyBinding) {
                MultiKeyBinding multiKeyBinding = (MultiKeyBinding)keyBindingArray[i];
                if (multiKeyBinding.keys != null) {
                    Keymap keymap = this.delegate;
                    for (int j = 0; j < multiKeyBinding.keys.length; ++j) {
                        if (j == multiKeyBinding.keys.length - 1) {
                            keymap.addActionForKeyStroke(multiKeyBinding.keys[j], action);
                            continue;
                        }
                        Action action2 = keymap.getAction(multiKeyBinding.keys[j]);
                        if (!(action2 instanceof KeymapSetContextAction)) {
                            action2 = new KeymapSetContextAction(JTextComponent.addKeymap(null, null));
                            keymap.addActionForKeyStroke(multiKeyBinding.keys[j], action2);
                        }
                        keymap = ((KeymapSetContextAction)action2).contextKeymap;
                    }
                    bl = true;
                }
            }
            if (bl) continue;
            if (keyBindingArray[i].key != null) {
                this.delegate.addActionForKeyStroke(keyBindingArray[i].key, action);
                continue;
            }
            this.setDefaultAction(action);
        }
    }

    public String getName() {
        return this.context != null ? this.context.getName() : this.delegate.getName();
    }

    public Action getDefaultAction() {
        return this.delegate.getDefaultAction();
    }

    public void setDefaultAction(Action action) {
        if (this.context != null) {
            this.context.setDefaultAction(action);
        } else {
            this.delegate.setDefaultAction(action);
        }
    }

    private Action getActionImpl(KeyStroke keyStroke) {
        Action action = null;
        action = this.context != null ? this.context.getAction(keyStroke) : this.delegate.getAction(keyStroke);
        return action;
    }

    private boolean contextKeysEqual(List list) {
        if (list.size() != this.contextKeys.size()) {
            return false;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            if (this.contextKeys.get(i).equals(list.get(i))) continue;
            return false;
        }
        return true;
    }

    public Action getAction(KeyStroke keyStroke) {
        Object object;
        int n;
        Action action = null;
        List list = this.getGlobalContextList();
        if (list != null && list.size() > 0 && !this.contextKeysEqual(list)) {
            this.resetContext();
            for (n = 0; n < list.size(); ++n) {
                object = this.getActionImpl((KeyStroke)list.get(n));
                if (!(object instanceof KeymapSetContextAction)) {
                    this.resetContext();
                    break;
                }
                object.actionPerformed(null);
            }
            if (n != list.size()) {
                return null;
            }
        }
        if (this.ignoreNextTyped) {
            if (keyStroke.isOnKeyRelease()) {
                action = EMPTY_ACTION;
            } else {
                this.ignoreNextTyped = false;
            }
            if (keyStroke.getKeyChar() != '\u0000' && keyStroke.getKeyChar() != '\uffff') {
                action = EMPTY_ACTION;
            }
        }
        if (action == null) {
            action = this.getActionImpl(keyStroke);
            if (action instanceof KeymapSetContextAction) {
                this.shiftGlobalContext(keyStroke);
            } else {
                if (this.context != null) {
                    this.ignoreNextTyped = true;
                } else if (compatibleIgnoreNextTyped) {
                    if ((keyStroke.getModifiers() & 8) != 0 && (keyStroke.getModifiers() & 2) == 0) {
                        n = 1;
                        if (keyStroke.getKeyChar() == '\u0000' || keyStroke.getKeyChar() == '\uffff') {
                            switch (keyStroke.getKeyCode()) {
                                case 18: 
                                case 25: 
                                case 96: 
                                case 97: 
                                case 98: 
                                case 99: 
                                case 100: 
                                case 101: 
                                case 102: 
                                case 103: 
                                case 104: 
                                case 105: 
                                case 241: 
                                case 242: 
                                case 259: 
                                case 260: 
                                case 263: {
                                    n = 0;
                                }
                            }
                        }
                        if (n != 0) {
                            this.ignoreNextTyped = true;
                        }
                    } else if ((keyStroke.getModifiers() & 4) != 0) {
                        this.ignoreNextTyped = true;
                    } else if ((keyStroke.getModifiers() & 2) != 0 && (keyStroke.getModifiers() & 1) != 0 && (keyStroke.getKeyCode() == 107 || keyStroke.getKeyCode() == 109)) {
                        this.ignoreNextTyped = true;
                    }
                }
                this.resetContext();
            }
            if (this.context == null || action == null) {
                // empty if block
            }
        }
        if (action != null && !(action instanceof KeymapSetContextAction) && action != EMPTY_ACTION) {
            StringBuilder stringBuilder = new StringBuilder();
            object = this.getGlobalContextList();
            if (object != null) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    KeyStroke keyStroke2 = (KeyStroke)iterator.next();
                    stringBuilder.append(MultiKeymap.getKeyText(keyStroke2)).append(" ");
                }
            }
            stringBuilder.append(MultiKeymap.getKeyText(keyStroke));
            action.putValue("ActionCommandKey", stringBuilder.toString());
            this.resetGlobalContext();
        }
        if (compatibleIgnoreNextTyped && keyStroke == KeyStroke.getKeyStroke(32, 2)) {
            this.ignoreNextTyped = true;
        }
        return action;
    }

    public KeyStroke[] getBoundKeyStrokes() {
        return this.context != null ? this.context.getBoundKeyStrokes() : this.delegate.getBoundKeyStrokes();
    }

    public Action[] getBoundActions() {
        return this.context != null ? this.context.getBoundActions() : this.delegate.getBoundActions();
    }

    public KeyStroke[] getKeyStrokesForAction(Action action) {
        return this.context != null ? this.context.getKeyStrokesForAction(action) : this.delegate.getKeyStrokesForAction(action);
    }

    public boolean isLocallyDefined(KeyStroke keyStroke) {
        return this.context != null ? this.context.isLocallyDefined(keyStroke) : this.delegate.isLocallyDefined(keyStroke);
    }

    public void addActionForKeyStroke(KeyStroke keyStroke, Action action) {
        if (this.context != null) {
            this.context.addActionForKeyStroke(keyStroke, action);
        } else {
            this.delegate.addActionForKeyStroke(keyStroke, action);
        }
    }

    public void removeKeyStrokeBinding(KeyStroke keyStroke) {
        if (this.context != null) {
            this.context.removeKeyStrokeBinding(keyStroke);
        } else {
            this.delegate.removeKeyStrokeBinding(keyStroke);
        }
    }

    public void removeBindings() {
        if (this.context != null) {
            this.context.removeBindings();
        } else {
            this.delegate.removeBindings();
        }
    }

    public Keymap getResolveParent() {
        return this.context != null ? this.context.getResolveParent() : this.delegate.getResolveParent();
    }

    public void setResolveParent(Keymap keymap) {
        if (this.context != null) {
            this.context.setResolveParent(keymap);
        } else {
            this.delegate.setResolveParent(keymap);
        }
    }

    public String toString() {
        return "MK: name=" + this.getName();
    }

    class KeymapSetContextAction
    extends AbstractAction {
        Keymap contextKeymap;
        static final long serialVersionUID = 1034848289049566148L;

        KeymapSetContextAction(Keymap keymap) {
            this.contextKeymap = keymap;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MultiKeymap.this.setContext(this.contextKeymap);
        }
    }
}

