/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.ui.PropertiesDialog;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class StartManager {
    private static final StartManager DEFAULT = new StartManager();
    private static final Logger LOGGER = Logger.getLogger(StartManager.class.getName());
    private final PropertyChangeListener listener = new StartPropertyChangeListener();
    private final AtomicBoolean isStarting = new AtomicBoolean(false);
    private final AtomicBoolean startRequested = new AtomicBoolean(false);
    private volatile DatabaseServer server;
    private volatile String errorMessage;

    private StartManager() {
    }

    public static StartManager getDefault() {
        return DEFAULT;
    }

    public PropertyChangeListener getStartListener() {
        return this.listener;
    }

    public boolean isStartRequested() {
        return this.startRequested.get();
    }

    private synchronized void setIsStarting(boolean bl) {
        this.isStarting.set(bl);
    }

    public void start(final DatabaseServer databaseServer) {
        this.server = databaseServer;
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    StartManager.this.startRequested.set(true);
                    boolean bl = StartManager.this.isStarting.getAndSet(true);
                    if (bl) {
                        LOGGER.log(Level.FINE, "Server is already starting");
                        return;
                    }
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(StartManager.class, (String)"MSG_StartingMySQL"));
                    databaseServer.start();
                    StartManager.this.waitForStartAndConnect();
                }
                catch (DatabaseException databaseException) {
                    Utils.displayError(Utils.getMessage("MSG_UnableToStartServer", new Object[0]), (Exception)((Object)databaseException));
                }
                finally {
                    StartManager.this.setIsStarting(false);
                }
            }
        });
    }

    private void waitForStartAndConnect() {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(StartManager.class, (String)"MSG_WaitingForServerToStart"));
                progressHandle.start();
                progressHandle.switchToIndeterminate();
                try {
                    boolean bl;
                    do {
                        if (!StartManager.this.waitForStart()) continue;
                        StartManager.this.startRequested.set(false);
                        return;
                    } while (bl = StartManager.this.displayServerNotRunning());
                }
                catch (DatabaseException databaseException) {
                    LOGGER.log(Level.INFO, null, databaseException);
                    Utils.displayErrorMessage(NbBundle.getMessage(StartManager.class, (String)"MSG_ConnectFailedAfterStart", (Object)databaseException.getMessage()));
                }
                finally {
                    progressHandle.finish();
                }
            }
        });
    }

    private boolean displayServerNotRunning() {
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(StartManager.class, (String)"StartManager.CancelButton"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(StartManager.class, (String)"StartManager.CancelButtonA11yDesc"));
        JButton jButton2 = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)NbBundle.getMessage(StartManager.class, (String)"StartManager.KeepWaitingButton"));
        jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(StartManager.class, (String)"StartManager.KeepWaitingButtonA11yDesc"));
        JButton jButton3 = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton3, (String)NbBundle.getMessage(StartManager.class, (String)"StartManager.PropsButton"));
        jButton3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(StartManager.class, (String)"StartManager.PropsButtonA11yDesc"));
        String string = NbBundle.getMessage(StartManager.class, (String)"MSG_ServerDoesNotAppearToHaveStarted", (Object)this.errorMessage);
        final NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string, NbBundle.getMessage(StartManager.class, (String)"StartManager.ServerNotRunningTitle"), 1, 3, new Object[]{jButton2, jButton3, jButton}, NotifyDescriptor.CANCEL_OPTION);
        Object object = Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Object>(){

            public Object run() {
                return DialogDisplayer.getDefault().notify(notifyDescriptor);
            }
        });
        if (jButton.equals(object)) {
            this.startRequested.set(false);
            return false;
        }
        if (jButton2.equals(object)) {
            return true;
        }
        this.displayAdminProperties(this.server);
        return false;
    }

    private void displayAdminProperties(final DatabaseServer databaseServer) {
        Mutex.EVENT.postReadRequest(new Runnable(){

            public void run() {
                new PropertiesDialog(databaseServer).displayDialog();
            }
        });
    }

    private boolean waitForStart() throws DatabaseException {
        for (int i = 0; i <= 5; ++i) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.log(Level.INFO, "Interrupted waiting for server to start", interruptedException);
                Thread.currentThread().interrupt();
                return false;
            }
            try {
                this.server.reconnect();
                return true;
            }
            catch (DatabaseException databaseException) {
                this.errorMessage = databaseException.getMessage();
                LOGGER.log(Level.INFO, null, databaseException);
                continue;
            }
            catch (TimeoutException timeoutException) {
                this.errorMessage = timeoutException.getMessage();
                LOGGER.log(Level.INFO, null, timeoutException);
                continue;
            }
        }
        return false;
    }

    private class StartPropertyChangeListener
    implements PropertyChangeListener {
        private StartPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DatabaseServer databaseServer = (DatabaseServer)propertyChangeEvent.getSource();
            if (("start-args".equals(propertyChangeEvent.getPropertyName()) || "start-path".equals(propertyChangeEvent.getPropertyName())) && StartManager.this.startRequested.get()) {
                StartManager.this.start(databaseServer);
            }
        }
    }
}

