/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.resgen;

import java.io.File;
import java.io.PrintWriter;
import org.eigenbase.resgen.AbstractGenerator;
import org.eigenbase.resgen.ResourceDef;
import org.eigenbase.resgen.ResourceDefinition;
import org.eigenbase.resgen.ResourceGen;

class CppGenerator
extends AbstractGenerator {
    private final String className;
    private final String defaultExceptionClassName;
    private final String headerFilename;
    private final String baseClassName;
    private static final String CPP_STRING = "const std::string &";
    private static final String CPP_NUMBER = "int";
    private static final String CPP_DATE_TIME = "time_t";
    private static final String[] CPP_TYPE_NAMES;
    static final /* synthetic */ boolean $assertionsDisabled;

    CppGenerator(File file, File file2, String string, String string2, String string3, String string4) {
        super(file, file2);
        if (!$assertionsDisabled && string.indexOf(46) >= 0) {
            throw new AssertionError((Object)("C++ class name must not contain '.': " + string));
        }
        this.className = string;
        this.defaultExceptionClassName = string3;
        this.headerFilename = string4;
        if (!$assertionsDisabled && string2 == null) {
            throw new AssertionError();
        }
        this.baseClassName = string2;
    }

    protected String getClassName() {
        return this.className;
    }

    protected String getBaseClassName() {
        return this.baseClassName;
    }

    protected String[] getArgTypes(String string) {
        return ResourceDefinition.getArgTypes(string, CPP_TYPE_NAMES);
    }

    public void generateModule(ResourceGen resourceGen, ResourceDef.ResourceBundle resourceBundle, PrintWriter printWriter) {
        int n;
        this.generateDoNotModifyHeader(printWriter);
        this.generateGeneratedByBlock(printWriter);
        String string = this.getClassName();
        String string2 = string + "BundleCache";
        String string3 = this.getBaseClassName();
        if (resourceBundle.cppCommonInclude != null) {
            printWriter.println("// begin common include specified by " + this.getSrcFileForComment());
            printWriter.println("#include \"" + resourceBundle.cppCommonInclude + "\"");
            printWriter.println("// end common include specified by " + this.getSrcFileForComment());
        }
        printWriter.println("#include \"" + this.headerFilename + "\"");
        printWriter.println("#include \"ResourceBundle.h\"");
        printWriter.println("#include \"Locale.h\"");
        printWriter.println();
        printWriter.println("#include <map>");
        printWriter.println("#include <string>");
        printWriter.println();
        if (resourceBundle.cppNamespace != null) {
            printWriter.println("namespace " + resourceBundle.cppNamespace + " {");
            printWriter.println();
        }
        printWriter.println("using namespace std;");
        printWriter.println();
        printWriter.println("#define BASENAME (\"" + string + "\")");
        printWriter.println();
        printWriter.println("static " + string2 + " bundleCache;");
        printWriter.println("static string bundleLocation(\"\");");
        printWriter.println();
        printWriter.println("const " + string + " &" + string + "::instance()");
        printWriter.println("{");
        printWriter.println("    return " + string + "::instance(Locale::getDefault());");
        printWriter.println("}");
        printWriter.println();
        printWriter.println("const " + string + " &" + string + "::instance(const Locale &locale)");
        printWriter.println("{");
        printWriter.println("    return *makeInstance<" + string + ", " + string2 + ", " + string2 + "::iterator>(bundleCache, locale);");
        printWriter.println("}");
        printWriter.println();
        printWriter.println("void " + string + "::setResourceFileLocation(const string &location)");
        printWriter.println("{");
        printWriter.println("    bundleLocation = location;");
        printWriter.println("}");
        printWriter.println();
        printWriter.println("" + string + "::" + string + "(Locale locale)");
        printWriter.println("    : " + string3 + "(BASENAME, locale, bundleLocation),");
        for (n = 0; n < resourceBundle.resources.length; ++n) {
            ResourceDef.Resource resource = resourceBundle.resources[n];
            printWriter.print("      _" + resource.name + "(this, \"" + resource.name + "\")");
            if (n + 1 < resourceBundle.resources.length) {
                printWriter.println(',');
                continue;
            }
            printWriter.println();
        }
        printWriter.println("{ }");
        printWriter.println();
        for (n = 0; n < resourceBundle.resources.length; ++n) {
            this.generateResource(resourceBundle.resources[n], printWriter);
        }
        if (resourceBundle.cppNamespace != null) {
            printWriter.println();
            printWriter.println("} // end namespace " + resourceBundle.cppNamespace);
        }
    }

    public void generateResource(ResourceDef.Resource resource, PrintWriter printWriter) {
        String string = resource.text.cdata;
        String string2 = ResourceGen.getResourceInitcap(resource);
        String string3 = this.getParameterList(string);
        String string4 = this.getArgumentList(string);
        printWriter.println("string " + this.className + "::" + resource.name + "(" + string3 + ") const");
        printWriter.println("{");
        printWriter.println("    return _" + resource.name + ".format(" + string4 + ");");
        printWriter.println("}");
        if (resource instanceof ResourceDef.Exception) {
            boolean bl;
            ResourceDef.Exception exception = (ResourceDef.Exception)resource;
            String string5 = exception.cppClassName;
            if (string5 == null) {
                string5 = this.defaultExceptionClassName;
            }
            printWriter.println(string5 + "* " + this.className + "::new" + string2 + "(" + string3 + ") const");
            printWriter.println("{");
            printWriter.println("    return new " + string5 + "(" + resource.name + "(" + string4 + "));");
            printWriter.println("}");
            printWriter.println();
            boolean bl2 = bl = exception.cppChainExceptions != null && exception.cppChainExceptions.equalsIgnoreCase("true");
            if (bl) {
                if (string3.length() > 0) {
                    printWriter.println(string5 + "* " + this.className + "::new" + string2 + "(" + string3 + ", const " + string5 + " * const prev) const");
                } else {
                    printWriter.println(string5 + " " + this.className + "::new" + string2 + "(const " + string5 + " * const prev) const");
                }
                printWriter.println("{");
                printWriter.println("    return new " + string5 + "(" + resource.name + "(" + string4 + "), prev);");
                printWriter.println("}");
                printWriter.println();
            }
        }
    }

    static {
        $assertionsDisabled = !CppGenerator.class.desiredAssertionStatus();
        CPP_TYPE_NAMES = new String[]{CPP_STRING, CPP_NUMBER, CPP_DATE_TIME, CPP_DATE_TIME};
    }
}

