/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.resgen;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eigenbase.resgen.FileTask;
import org.eigenbase.resgen.ResourceGen;

public class ResourceGenTask
extends Task {
    private ArrayList resources = new ArrayList();
    int mode = 1;
    File src;
    File dest;
    File res;
    int style = 1;
    String locales;
    boolean force;
    int commentStyle = 1;
    private static final int MODE_UNKNOWN = -1;
    private static final int MODE_JAVA = 1;
    private static final int MODE_CPP = 2;
    private static final int MODE_ALL = 3;
    public static final int STYLE_DYNAMIC = 1;
    public static final int STYLE_FUNCTOR = 2;
    public static final int COMMENT_STYLE_NORMAL = 1;
    public static final int COMMENT_STYLE_SCM_SAFE = 2;

    public void execute() throws BuildException {
        this.validate();
        try {
            new ResourceGen().run(this);
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
    }

    public void addInclude(Include include) {
        this.resources.add(include);
        include.root = this;
    }

    void validate() {
        if (this.mode != 1 && this.mode != 2 && this.mode != 3) {
            throw new BuildException("You must specify a value mode: java, c++, or all");
        }
        if (this.src == null) {
            throw new BuildException("You must specify 'srcdir'");
        }
        if (this.dest == null) {
            this.dest = this.src;
        }
        if (this.res == null) {
            this.res = this.dest;
        }
        Include[] includeArray = this.getIncludes();
        for (int i = 0; i < includeArray.length; ++i) {
            includeArray[i].validate();
        }
    }

    Include[] getIncludes() {
        return this.resources.toArray(new Include[0]);
    }

    public void setMode(String string) throws BuildException {
        this.mode = "java".equals(string) ? 1 : ("c++".equals(string) ? 2 : ("all".equals(string) ? 3 : -1));
    }

    public void setSrcdir(File file) {
        this.src = file;
    }

    public File getSrcdir() {
        return this.src;
    }

    public void setDestdir(File file) {
        this.dest = file;
    }

    public File getDestdir() {
        return this.dest;
    }

    public void setResdir(File file) {
        this.res = file;
    }

    public void setStyle(String string) throws BuildException {
        if (string.equals("dynamic")) {
            this.style = 1;
        } else if (string.equals("functor")) {
            this.style = 2;
        } else {
            throw new BuildException("Invalid style '" + string + "'");
        }
    }

    public void setLocales(String string) throws BuildException {
        this.locales = string;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public void setCommentStyle(String string) throws BuildException {
        if (string.equals("normal")) {
            this.commentStyle = 1;
        } else if (string.equals("scm-safe")) {
            this.commentStyle = 2;
        } else {
            throw new BuildException("Invalid commentstyle '" + string + "'");
        }
    }

    public static class Include {
        ResourceGenTask root;
        String fileName;
        String className;
        String baseClassName;
        String cppClassName;
        String cppBaseClassName;

        void validate() throws BuildException {
            if (this.fileName == null) {
                throw new BuildException("You must specify attribute 'name'");
            }
        }

        void process(ResourceGen resourceGen) throws BuildException {
            FileTask fileTask;
            boolean bl;
            boolean bl2 = this.root.mode != 2;
            boolean bl3 = bl = this.root.mode != 1;
            if (this.fileName.endsWith(".xml")) {
                fileTask = resourceGen.createXmlTask(this, this.fileName, this.className, this.baseClassName, bl2, this.cppClassName, this.cppBaseClassName, bl);
            } else if (this.fileName.endsWith(".properties")) {
                fileTask = resourceGen.createPropertiesTask(this, this.fileName);
            } else {
                throw new BuildException("File '" + this.fileName + "' is not of a supported " + "type (.java or .properties)");
            }
            try {
                fileTask.process(resourceGen);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new BuildException("Failed while processing '" + this.fileName + "'", (Throwable)iOException);
            }
        }

        public void setName(String string) {
            this.fileName = string;
        }

        public void setClassName(String string) {
            this.className = string;
        }

        public void setBaseClassName(String string) {
            this.baseClassName = string;
        }

        String getBaseClassName() {
            return this.baseClassName;
        }

        public void setCppClassName(String string) {
            this.cppClassName = string;
        }

        public void setCppBaseClassName(String string) {
            this.cppBaseClassName = string;
        }

        String getCppBaseClassName() {
            return this.cppBaseClassName;
        }
    }
}

