/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import mondrian.calc.ResultStyle;
import mondrian.olap.DelegatingSchemaReader;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.ResultStyleException;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.HighCardSqlTupleReader;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapNative;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.SqlTupleReader;
import mondrian.rolap.TupleReader;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.cache.HardSmartCache;
import mondrian.rolap.cache.SmartCache;
import mondrian.rolap.cache.SoftSmartCache;
import mondrian.rolap.sql.CrossJoinArg;
import mondrian.rolap.sql.CrossJoinArgFactory;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.MemberListCrossJoinArg;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.TupleConstraint;
import org.apache.log4j.Logger;

public abstract class RolapNativeSet
extends RolapNative {
    protected static final Logger LOGGER = Logger.getLogger(RolapNativeSet.class);
    private SmartCache<Object, List<List<RolapMember>>> cache = new SoftSmartCache<Object, List<List<RolapMember>>>();

    protected abstract boolean restrictMemberTypes();

    protected CrossJoinArgFactory crossJoinArgFactory() {
        return new CrossJoinArgFactory(this.restrictMemberTypes());
    }

    protected boolean isPreferInterpreter(CrossJoinArg[] args, boolean joinArg) {
        for (CrossJoinArg arg : args) {
            if (arg.isPreferInterpreter(joinArg)) continue;
            return false;
        }
        return true;
    }

    void useHardCache(boolean hard) {
        this.cache = hard ? new HardSmartCache<Object, List<List<RolapMember>>>() : new SoftSmartCache<Object, List<List<RolapMember>>>();
    }

    protected RolapEvaluator overrideContext(RolapEvaluator evaluator, CrossJoinArg[] cargs, RolapStoredMeasure storedMeasure) {
        SchemaReader schemaReader = evaluator.getSchemaReader();
        RolapEvaluator newEvaluator = evaluator.push();
        for (CrossJoinArg carg : cargs) {
            RolapLevel level = carg.getLevel();
            if (level == null) continue;
            RolapHierarchy hierarchy = level.getHierarchy();
            Member defaultMember = schemaReader.getHierarchyDefaultMember(hierarchy);
            newEvaluator.setContext(defaultMember);
        }
        if (storedMeasure != null) {
            newEvaluator.setContext(storedMeasure);
        }
        return newEvaluator;
    }

    private static class SchemaReaderWithMemberReaderCache
    extends DelegatingSchemaReader
    implements SchemaReaderWithMemberReaderAvailable {
        private final Map<Hierarchy, MemberReader> hierarchyReaders = new HashMap<Hierarchy, MemberReader>();

        SchemaReaderWithMemberReaderCache(SchemaReader schemaReader) {
            super(schemaReader);
        }

        public synchronized MemberReader getMemberReader(Hierarchy hierarchy) {
            MemberReader memberReader = this.hierarchyReaders.get(hierarchy);
            if (memberReader == null) {
                memberReader = ((RolapHierarchy)hierarchy).createMemberReader(this.schemaReader.getRole());
                this.hierarchyReaders.put(hierarchy, memberReader);
            }
            return memberReader;
        }
    }

    public static interface SchemaReaderWithMemberReaderAvailable
    extends SchemaReader {
        public MemberReader getMemberReader(Hierarchy var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SetEvaluator
    implements NativeEvaluator {
        private final CrossJoinArg[] args;
        private final SchemaReaderWithMemberReaderAvailable schemaReader;
        private final TupleConstraint constraint;
        private int maxRows = 0;

        public SetEvaluator(CrossJoinArg[] args, SchemaReader schemaReader, TupleConstraint constraint) {
            this.args = args;
            this.schemaReader = schemaReader instanceof SchemaReaderWithMemberReaderAvailable ? (SchemaReaderWithMemberReaderAvailable)schemaReader : new SchemaReaderWithMemberReaderCache(schemaReader);
            this.constraint = constraint;
        }

        @Override
        public Object execute(ResultStyle desiredResultStyle) {
            switch (desiredResultStyle) {
                case ITERABLE: {
                    return this.executeList(new HighCardSqlTupleReader(this.constraint));
                }
                case MUTABLE_LIST: 
                case LIST: {
                    return this.executeList(new SqlTupleReader(this.constraint));
                }
            }
            throw ResultStyleException.generate(ResultStyle.ITERABLE_MUTABLELIST_LIST, Collections.singletonList(desiredResultStyle));
        }

        protected List executeList(SqlTupleReader tr) {
            RolapNative.TupleEvent e;
            boolean hasEnumTargets;
            tr.setMaxRows(this.maxRows);
            for (CrossJoinArg arg : this.args) {
                this.addLevel(tr, arg);
            }
            Object key = tr.getCacheKey();
            List<Object> result = (List<RolapMember>)RolapNativeSet.this.cache.get(key);
            boolean bl = hasEnumTargets = tr.getEnumTargetCount() > 0;
            if (result != null && !hasEnumTargets) {
                if (RolapNativeSet.this.listener != null) {
                    e = new RolapNative.TupleEvent(this, tr);
                    RolapNativeSet.this.listener.foundInCache(e);
                }
                return this.copy(result);
            }
            if (result == null && RolapNativeSet.this.listener != null) {
                e = new RolapNative.TupleEvent(this, tr);
                RolapNativeSet.this.listener.executingSql(e);
            }
            List<RolapMember> partialResult = result;
            result = null;
            ArrayList<List<RolapMember>> newPartialResult = null;
            if (hasEnumTargets && partialResult == null) {
                newPartialResult = new ArrayList<List<RolapMember>>();
            }
            DataSource dataSource = this.schemaReader.getDataSource();
            result = this.args.length == 1 ? tr.readMembers(dataSource, (List<List<RolapMember>>)partialResult, newPartialResult) : tr.readTuples(dataSource, (List<List<RolapMember>>)partialResult, newPartialResult);
            if (hasEnumTargets) {
                if (newPartialResult != null) {
                    RolapNativeSet.this.cache.put(key, newPartialResult);
                }
            } else {
                RolapNativeSet.this.cache.put(key, result);
            }
            return this.copy(result);
        }

        private <T> List<T> copy(List<T> list) {
            return list;
        }

        private void addLevel(TupleReader tr, CrossJoinArg arg) {
            RolapLevel level = arg.getLevel();
            if (level == null) {
                return;
            }
            RolapHierarchy hierarchy = level.getHierarchy();
            MemberReader mr = this.schemaReader.getMemberReader(hierarchy);
            TupleReader.MemberBuilder mb = mr.getMemberBuilder();
            Util.assertTrue(mb != null, "MemberBuilder not found");
            if (arg instanceof MemberListCrossJoinArg && ((MemberListCrossJoinArg)arg).hasCalcMembers()) {
                tr.addLevelMembers(level, mb, arg.getMembers());
            } else {
                tr.addLevelMembers(level, mb, null);
            }
        }

        int getMaxRows() {
            return this.maxRows;
        }

        void setMaxRows(int maxRows) {
            this.maxRows = maxRows;
        }
    }

    protected static abstract class SetConstraint
    extends SqlContextConstraint {
        CrossJoinArg[] args;

        SetConstraint(CrossJoinArg[] args, RolapEvaluator evaluator, boolean strict) {
            super(evaluator, strict);
            this.args = args;
        }

        protected boolean isJoinRequired() {
            return this.args.length > 1 || super.isJoinRequired();
        }

        public void addConstraint(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar) {
            super.addConstraint(sqlQuery, baseCube, aggStar);
            for (CrossJoinArg arg : this.args) {
                RolapLevel level;
                if (arg instanceof MemberListCrossJoinArg && ((MemberListCrossJoinArg)arg).hasCalcMembers() || (level = arg.getLevel()) != null && !this.levelIsOnBaseCube(baseCube, level)) continue;
                arg.addConstraint(sqlQuery, baseCube, aggStar);
            }
        }

        private boolean levelIsOnBaseCube(RolapCube baseCube, RolapLevel level) {
            return baseCube.findBaseCubeHierarchy(level.getHierarchy()) != null;
        }

        public MemberChildrenConstraint getMemberChildrenConstraint(RolapMember parent) {
            return null;
        }

        public Object getCacheKey() {
            ArrayList<Object> key = new ArrayList<Object>();
            key.add(super.getCacheKey());
            for (CrossJoinArg arg : this.args) {
                if (arg instanceof MemberListCrossJoinArg && ((MemberListCrossJoinArg)arg).hasCalcMembers()) continue;
                key.add(arg);
            }
            return key;
        }
    }
}

