/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.ValueColumnPredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CellRequest {
    private final RolapStar.Measure measure;
    public final boolean extendedContext;
    public final boolean drillThrough;
    private final List<Integer> constrainedColumnList = new ArrayList<Integer>();
    private final List<StarColumnPredicate> columnPredicateList = new ArrayList<StarColumnPredicate>();
    private final Map<Integer, RolapStar.Column> bitToColumnMap = new HashMap<Integer, RolapStar.Column>();
    private Object[] singleValues;
    private RolapStar.Column[] columnsCache = null;
    private final BitKey constrainedColumnsBitKey;
    private Map<BitKey, StarPredicate> compoundPredicateMap = null;
    private boolean unsatisfiable;
    private boolean isDirty = true;

    public CellRequest(RolapStar.Measure measure, boolean extendedContext, boolean drillThrough) {
        this.measure = measure;
        this.extendedContext = extendedContext;
        this.drillThrough = drillThrough;
        this.constrainedColumnsBitKey = BitKey.Factory.makeBitKey(measure.getStar().getColumnCount());
    }

    public final void addConstrainedColumn(RolapStar.Column column, StarColumnPredicate predicate) {
        assert (this.columnsCache == null);
        int bitPosition = column.getBitPosition();
        if (this.constrainedColumnsBitKey.get(bitPosition)) {
            int index = this.constrainedColumnList.indexOf(bitPosition);
            assert (index >= 0);
            StarColumnPredicate prevValue = this.columnPredicateList.get(index);
            if (prevValue != null) {
                if (predicate == null) {
                    return;
                }
                if (predicate.equalConstraint(prevValue)) {
                    return;
                }
                predicate = null;
                this.unsatisfiable = true;
            }
            this.columnPredicateList.set(index, predicate);
        } else {
            this.constrainedColumnList.add(bitPosition);
            this.bitToColumnMap.put(bitPosition, column);
            this.constrainedColumnsBitKey.set(bitPosition);
            this.columnPredicateList.add(predicate);
        }
    }

    public void addAggregateList(BitKey compoundBitKey, StarPredicate compoundPredicate) {
        if (this.compoundPredicateMap == null) {
            this.compoundPredicateMap = new LinkedHashMap<BitKey, StarPredicate>();
        }
        this.compoundPredicateMap.put(compoundBitKey, compoundPredicate);
    }

    public RolapStar.Measure getMeasure() {
        return this.measure;
    }

    public RolapStar.Column[] getConstrainedColumns() {
        if (this.columnsCache == null) {
            this.check();
        }
        return this.columnsCache;
    }

    public BitKey getConstrainedColumnsBitKey() {
        return this.constrainedColumnsBitKey;
    }

    Map<BitKey, StarPredicate> getCompoundPredicateMap() {
        return this.compoundPredicateMap;
    }

    private void check() {
        if (this.isDirty) {
            int size = this.constrainedColumnList.size();
            this.columnsCache = new RolapStar.Column[size];
            StarColumnPredicate[] oldColumnPredicates = this.columnPredicateList.toArray(new StarColumnPredicate[this.columnPredicateList.size()]);
            this.columnPredicateList.clear();
            int i = 0;
            int bitPos = this.constrainedColumnsBitKey.nextSetBit(0);
            while (bitPos >= 0) {
                int index = this.constrainedColumnList.indexOf(bitPos);
                if (index >= 0) {
                    StarColumnPredicate value = oldColumnPredicates[index];
                    this.columnPredicateList.add(value);
                    this.columnsCache[i++] = this.bitToColumnMap.get(bitPos);
                }
                bitPos = this.constrainedColumnsBitKey.nextSetBit(bitPos + 1);
            }
            this.isDirty = false;
        }
    }

    public List<StarColumnPredicate> getValueList() {
        this.check();
        return this.columnPredicateList;
    }

    public Object[] getSingleValues() {
        assert (!this.unsatisfiable);
        if (this.singleValues == null) {
            this.check();
            this.singleValues = new Object[this.columnPredicateList.size()];
            int size = this.columnPredicateList.size();
            for (int i = 0; i < size; ++i) {
                ValueColumnPredicate predicate = (ValueColumnPredicate)this.columnPredicateList.get(i);
                this.singleValues[i] = predicate.getValue();
            }
        }
        return this.singleValues;
    }

    public boolean isUnsatisfiable() {
        return this.unsatisfiable;
    }
}

