/*
 * iReport - Visual Designer for JasperReports.
 * Copyright (C) 2002 - 2009 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 * 
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 * 
 * This program is part of iReport.
 * 
 * iReport is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * iReport is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with iReport. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.ireport.designer.fonts;

import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.tools.LocaleSelectorDialog;
import java.awt.Dialog;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;


public final class InstallFontVisualPanel3Locales extends JPanel {

    /** Creates new form InstallFontVisualPanel3 */
    public InstallFontVisualPanel3Locales() {
        initComponents();
        jList1.setModel(new DefaultListModel());
        jList1.getSelectionModel().addListSelectionListener(new ListSelectionListener() {

            public void valueChanged(ListSelectionEvent e) {
                jButtonRemoveLocale.setEnabled( jList1.getSelectedIndex() >= 0 );
            }
        });
    }

    @Override
    public String getName() {
        return "Locales";
    }


    public void storeSettings(Object settings) {

        List<String> locales = new ArrayList<String>();

        DefaultListModel dlm = (DefaultListModel)jList1.getModel();

        for (int i=0; i<dlm.getSize(); ++i)
        {

            locales.add( (String)((Tag)dlm.get(i)).getValue() );
        }

        ((InstallFontWizardDescriptor)settings).putProperty("locales", locales);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList();
        jButtonAddLocale = new javax.swing.JButton();
        jButtonRemoveLocale = new javax.swing.JButton();

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(InstallFontVisualPanel3Locales.class, "InstallFontVisualPanel3Locales.jLabel1.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(InstallFontVisualPanel3Locales.class, "InstallFontVisualPanel3Locales.jLabel2.text")); // NOI18N

        jScrollPane1.setViewportView(jList1);

        org.openide.awt.Mnemonics.setLocalizedText(jButtonAddLocale, org.openide.util.NbBundle.getMessage(InstallFontVisualPanel3Locales.class, "InstallFontVisualPanel3Locales.jButtonAddLocale.text")); // NOI18N
        jButtonAddLocale.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAddLocaleActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(jButtonRemoveLocale, org.openide.util.NbBundle.getMessage(InstallFontVisualPanel3Locales.class, "InstallFontVisualPanel3Locales.jButtonRemoveLocale.text")); // NOI18N
        jButtonRemoveLocale.setEnabled(false);
        jButtonRemoveLocale.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonRemoveLocaleActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(jButtonAddLocale)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jButtonRemoveLocale)
                        .addContainerGap(283, Short.MAX_VALUE))
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 399, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, jLabel2, 0, 0, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, jLabel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 399, Short.MAX_VALUE))
                        .add(12, 12, 12))))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel1)
                .add(18, 18, 18)
                .add(jLabel2)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 106, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jButtonAddLocale)
                    .add(jButtonRemoveLocale))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonAddLocaleActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAddLocaleActionPerformed

        LocaleSelectorDialog lsd = new LocaleSelectorDialog( (Dialog)SwingUtilities.getAncestorOfClass( Dialog.class, this), true);
        lsd.setVisible(true);
        if (lsd.getDialogResult() == JOptionPane.OK_OPTION)
        {
            ((DefaultListModel)jList1.getModel()).addElement( new Tag(lsd.getSelectedLocaleId(), lsd.getSelectedLocale().getDisplayLanguage() + " (" + lsd.getSelectedLocaleId() + ")" ));
        }

    }//GEN-LAST:event_jButtonAddLocaleActionPerformed

    private void jButtonRemoveLocaleActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonRemoveLocaleActionPerformed

        while (jList1.getSelectedIndex() >= 0)
        {
            ((DefaultListModel)jList1.getModel()).remove(jList1.getSelectedIndex());
        }
        
    }//GEN-LAST:event_jButtonRemoveLocaleActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonAddLocale;
    private javax.swing.JButton jButtonRemoveLocale;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JList jList1;
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables
}

