/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage.fontscolors;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.settings.storage.EditorSettingsImpl;
import org.netbeans.modules.editor.settings.storage.ProfilesTracker;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.netbeans.modules.editor.settings.storage.api.EditorSettingsStorage;
import org.netbeans.modules.editor.settings.storage.api.FontColorSettingsFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FontColorSettingsImpl
extends FontColorSettingsFactory {
    private static final Logger LOG = Logger.getLogger(FontColorSettingsImpl.class.getName());
    private static final Map<MimePath, WeakReference<FontColorSettingsImpl>> INSTANCES = new WeakHashMap<MimePath, WeakReference<FontColorSettingsImpl>>();
    private final MimePath mimePath;
    private final Map<String, Map<String, AttributeSet>> colorings = new HashMap<String, Map<String, AttributeSet>>();

    public static synchronized FontColorSettingsImpl get(MimePath mimePath) {
        FontColorSettingsImpl fontColorSettingsImpl;
        WeakReference<FontColorSettingsImpl> weakReference = INSTANCES.get(mimePath);
        FontColorSettingsImpl fontColorSettingsImpl2 = fontColorSettingsImpl = weakReference == null ? null : (FontColorSettingsImpl)weakReference.get();
        if (fontColorSettingsImpl == null) {
            fontColorSettingsImpl = new FontColorSettingsImpl(mimePath);
            INSTANCES.put(mimePath, new WeakReference<FontColorSettingsImpl>(fontColorSettingsImpl));
        }
        return fontColorSettingsImpl;
    }

    private FontColorSettingsImpl(MimePath mimePath) {
        this.mimePath = mimePath;
    }

    public MimePath getMimePath() {
        return this.mimePath;
    }

    public String getInternalFontColorProfile(String string) {
        ProfilesTracker profilesTracker = ProfilesTracker.get("FontsColors", "Editors");
        ProfilesTracker.ProfileDescription profileDescription = profilesTracker.getProfileByDisplayName(string);
        return profileDescription == null ? string : profileDescription.getId();
    }

    @Override
    public Collection<AttributeSet> getAllFontColors(String string) {
        string = this.getInternalFontColorProfile(string);
        Map<String, AttributeSet> map = this.getColorings(string);
        return Collections.unmodifiableCollection(map.values());
    }

    @Override
    public Collection<AttributeSet> getAllFontColorDefaults(String string) {
        string = this.getInternalFontColorProfile(string);
        return this.getDefaultColorings(string).values();
    }

    @Override
    public void setAllFontColors(String string, Collection<AttributeSet> collection) {
        EditorSettingsStorage<String, AttributeSet> editorSettingsStorage = EditorSettingsStorage.get("FontsColors");
        boolean bl = string.startsWith("test");
        string = this.getInternalFontColorProfile(string);
        if (collection == null) {
            try {
                editorSettingsStorage.delete(this.mimePath, string, false);
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, null, iOException);
            }
            this.colorings.remove(string);
        } else {
            Map<String, AttributeSet> map = Utils.immutize(collection);
            if (!bl) {
                try {
                    editorSettingsStorage.save(this.mimePath, string, false, map);
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, null, iOException);
                }
            }
            this.colorings.put(string, map);
        }
        EditorSettingsImpl.getInstance().notifyTokenFontColorChange(this.mimePath, string);
    }

    @Override
    public void setAllFontColorsDefaults(String string, Collection<AttributeSet> collection) {
        EditorSettingsStorage<String, AttributeSet> editorSettingsStorage = EditorSettingsStorage.get("FontsColors");
        boolean bl = string.startsWith("test");
        string = this.getInternalFontColorProfile(string);
        try {
            if (collection == null) {
                editorSettingsStorage.delete(this.mimePath, string, true);
            } else {
                editorSettingsStorage.save(this.mimePath, string, true, Utils.immutize(collection));
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, null, iOException);
        }
        EditorSettingsImpl.getInstance().notifyTokenFontColorChange(this.mimePath, string);
    }

    Map<String, AttributeSet> getColorings(String string) {
        Map<String, AttributeSet> map;
        if (!this.colorings.containsKey(string)) {
            boolean bl = string.startsWith("test");
            EditorSettingsStorage editorSettingsStorage = EditorSettingsStorage.get("FontsColors");
            Map map2 = null;
            try {
                map2 = editorSettingsStorage.load(this.mimePath, bl ? "NetBeans" : string, false);
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, null, iOException);
            }
            Map map3 = null;
            if (!bl && !"NetBeans".equals(string)) {
                try {
                    map3 = editorSettingsStorage.load(this.mimePath, "NetBeans", false);
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, null, iOException);
                }
            }
            HashMap hashMap = new HashMap();
            if (map3 != null) {
                hashMap.putAll(map3);
            }
            if (map2 != null) {
                hashMap.putAll(map2);
            }
            map2 = Collections.unmodifiableMap(hashMap);
            this.colorings.put(string, map2);
        }
        return (map = this.colorings.get(string)) == null ? Collections.emptyMap() : map;
    }

    Map<String, AttributeSet> getDefaultColorings(String string) {
        EditorSettingsStorage editorSettingsStorage = EditorSettingsStorage.get("FontsColors");
        try {
            return editorSettingsStorage.load(this.mimePath, string, true);
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, null, iOException);
            return Collections.emptyMap();
        }
    }
}

