/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.sort;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import net.sf.jasperreports.components.BaseElementHtmlHandler;
import net.sf.jasperreports.components.sort.SortElementUtils;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.base.JRBasePrintHyperlink;
import net.sf.jasperreports.engine.export.JRHtmlExporterContext;
import net.sf.jasperreports.engine.export.JRXhtmlExporter;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRProperties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class SortElementHtmlHandler
extends BaseElementHtmlHandler {
    private static final String RESOURCE_SORT_JS = "net/sf/jasperreports/components/sort/resources/sort.js";
    private static final String RESOURCE_IMAGE_CLOSE = "net/sf/jasperreports/components/sort/resources/images/delete_edit.gif";
    private static final String SORT_ELEMENT_HTML_TEMPLATE = "net/sf/jasperreports/components/sort/resources/SortElementHtmlTemplate.vm";
    protected static final String HTML_VERTICAL_ALIGN_TOP = "top";
    protected static final String CSS_TEXT_ALIGN_LEFT = "left";
    protected static final String ASCENDING_SORT_SYMBOL = "&#9650;";
    protected static final String DESCENDING_SORT_SYMBOL = "&#9660;";

    public String getHtmlFragment(JRHtmlExporterContext context, JRGenericPrintElement element) {
        String htmlFragment = null;
        ReportContext reportContext = context.getExporter().getReportContext();
        if (reportContext != null) {
            String sortField;
            String sortColumnName = (String)element.getParameterValue("sortColumnName");
            String sortColumnType = (String)element.getParameterValue("sortColumnType");
            String sortHandlerColor = (String)element.getParameterValue("sortHandlerColor");
            String sortHandlerFontSize = (String)element.getParameterValue("sortHandlerFontSize");
            String sortHandlerVAlign = (String)element.getParameterValue("sortHandlerVerticalAlign");
            String sortHandlerHAlign = (String)element.getParameterValue("sortHandlerHorizontalAlign");
            String sortTableName = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.jr.dsr");
            String isFilterable = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.jr.filterable");
            Template template = this.getVelocityEngine().getTemplate(SORT_ELEMENT_HTML_TEMPLATE);
            String appContextPath = (String)reportContext.getParameterValue("net.sf.jasperreports.web.app.context.path");
            VelocityContext velocityContext = new VelocityContext();
            String webResourcesBasePath = JRProperties.getProperty("net.sf.jasperreports.web.resources.base.path");
            if (webResourcesBasePath == null) {
                webResourcesBasePath = "/servlets/resource?resource.uri=";
            }
            velocityContext.put("resourceSortJs", (Object)(webResourcesBasePath + RESOURCE_SORT_JS));
            velocityContext.put("elementX", (Object)((JRXhtmlExporter)context.getExporter()).toSizeUnit(element.getX()));
            velocityContext.put("elementY", (Object)((JRXhtmlExporter)context.getExporter()).toSizeUnit(element.getY()));
            velocityContext.put("elementWidth", (Object)element.getWidth());
            velocityContext.put("elementHeight", (Object)element.getHeight());
            velocityContext.put("sortHandlerHAlign", (Object)(sortHandlerHAlign != null ? sortHandlerHAlign : CSS_TEXT_ALIGN_LEFT));
            velocityContext.put("sortHandlerVAlign", (Object)(sortHandlerVAlign != null ? sortHandlerVAlign : HTML_VERTICAL_ALIGN_TOP));
            velocityContext.put("sortHandlerColor", (Object)(sortHandlerColor != null ? sortHandlerColor : "white"));
            velocityContext.put("sortHandlerFontSize", (Object)(sortHandlerFontSize != null ? sortHandlerFontSize : "10"));
            velocityContext.put("isFilterable", (Object)(isFilterable != null && isFilterable.equalsIgnoreCase("true") ? 1 : 0));
            velocityContext.put("filterDivId", (Object)("filter_" + sortTableName + "_" + sortColumnName));
            velocityContext.put("filterFormAction", (Object)this.getFilterFormActionLink(context));
            velocityContext.put("filterReportUriParamName", (Object)"jr.uri");
            velocityContext.put("filterReportUriParamValue", reportContext.getParameterValue("jr.uri"));
            velocityContext.put("filterFieldParamName", (Object)"jr.fltrFld");
            velocityContext.put("filterValueParamName", (Object)"jr.fltrVl");
            velocityContext.put("filterColumnName", (Object)sortColumnName);
            velocityContext.put("filterTableNameParam", (Object)"jr.dsr");
            velocityContext.put("filterTableNameValue", (Object)sortTableName);
            velocityContext.put("filterCloseDialogImageResource", (Object)((appContextPath == null ? "" : appContextPath) + webResourcesBasePath + RESOURCE_IMAGE_CLOSE));
            if (element.getModeValue() == ModeEnum.OPAQUE) {
                velocityContext.put("backgroundColor", (Object)JRColorUtil.getColorHexa(element.getBackcolor()));
            }
            if ((sortField = this.getCurrentSortField(reportContext, sortColumnName, sortColumnType)) == null) {
                velocityContext.put("href", (Object)this.getSortLink(context, sortColumnName, sortColumnType, "Asc", sortTableName));
                velocityContext.put("sortSymbol", (Object)"");
            } else {
                String[] sortActionData = SortElementUtils.extractColumnInfo(sortField);
                boolean isAscending = !"Asc".equals(sortActionData[2]);
                String sortOrder = isAscending ? "Asc" : "Dsc";
                velocityContext.put("href", (Object)this.getSortLink(context, sortColumnName, sortColumnType, sortOrder, sortTableName));
                velocityContext.put("sortSymbol", (Object)(isAscending ? ASCENDING_SORT_SYMBOL : DESCENDING_SORT_SYMBOL));
            }
            StringWriter writer = new StringWriter(128);
            template.merge((Context)velocityContext, (Writer)writer);
            writer.flush();
            try {
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            htmlFragment = writer.getBuffer().toString();
        }
        return htmlFragment;
    }

    private String getSortLink(JRHtmlExporterContext context, String sortColumnName, String sortColumnType, String sortOrder, String sortTableName) {
        JRBasePrintHyperlink hyperlink = new JRBasePrintHyperlink();
        hyperlink.setLinkType("ReportExecution");
        JRPrintHyperlinkParameters parameters = new JRPrintHyperlinkParameters();
        parameters.addParameter(new JRPrintHyperlinkParameter("jr.sort", String.class.getName(), SortElementUtils.packSortColumnInfo(sortColumnName, sortColumnType, sortOrder)));
        parameters.addParameter(new JRPrintHyperlinkParameter("jr.dsr", String.class.getName(), sortTableName));
        hyperlink.setHyperlinkParameters(parameters);
        return context.getHyperlinkURL(hyperlink);
    }

    private String getFilterFormActionLink(JRHtmlExporterContext context) {
        JRBasePrintHyperlink hyperlink = new JRBasePrintHyperlink();
        hyperlink.setLinkType("ReportExecution");
        return context.getHyperlinkURL(hyperlink);
    }

    private String getCurrentSortField(ReportContext reportContext, String sortColumnName, String sortColumnType) {
        String sortField = null;
        String sortData = (String)reportContext.getParameterValue("jr.sort");
        if (SortElementUtils.isValidSortData(sortData)) {
            String[] tokens = sortData.split(",");
            for (int i = 0; i < tokens.length; ++i) {
                String token = tokens[i];
                String[] sortActionData = SortElementUtils.extractColumnInfo(token);
                if (sortActionData.length <= 1 || !sortActionData[0].equals(sortColumnName) || !sortActionData[1].equals(sortColumnType)) continue;
                sortField = token;
                break;
            }
        }
        return sortField;
    }

    public boolean toExport(JRGenericPrintElement element) {
        return true;
    }
}

