/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.sort;

import java.util.ArrayList;
import java.util.Map;
import net.sf.jasperreports.components.sort.SortElementUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.ParameterContributor;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.design.JRDesignSortField;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortParameterContributor
implements ParameterContributor {
    private static final Log log = LogFactory.getLog(SortParameterContributor.class);

    @Override
    public void contributeParameters(Map<String, Object> parameterValues) throws JRException {
        ReportContext reportContext = (ReportContext)parameterValues.get("REPORT_CONTEXT");
        if (reportContext != null) {
            String reportActionData = (String)reportContext.getParameterValue("jr.sort");
            String paramTableName = (String)reportContext.getParameterValue("jr.dsr");
            if (reportActionData != null && paramTableName != null) {
                ArrayList<JRDesignSortField> sortFields = new ArrayList<JRDesignSortField>();
                String[] tokens = reportActionData.split(",");
                for (int i = 0; i < tokens.length; ++i) {
                    String token = tokens[i];
                    String[] chunks = SortElementUtils.extractColumnInfo(token);
                    sortFields.add(new JRDesignSortField(chunks[0], SortFieldTypeEnum.getByName(chunks[1]), SortElementUtils.getSortOrder(chunks[2])));
                }
                parameterValues.put("SORT_FIELDS", sortFields);
            }
            if (paramTableName != null) {
                String paramFieldName = (String)reportContext.getParameterValue("jr.fltrFld");
                String paramFieldValue = (String)reportContext.getParameterValue("jr.fltrVl");
                if (paramFieldName != null && paramFieldValue != null) {
                    reportContext.setParameterValue(paramTableName + "." + "jr.fltrFld", paramFieldName);
                    reportContext.setParameterValue(paramTableName + "." + "jr.fltrVl", paramFieldValue);
                }
            }
        }
    }
}

