/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.table.fill;

import java.util.Map;
import net.sf.jasperreports.components.table.fill.BuiltinExpressionEvaluator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.component.FillContext;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.type.WhenResourceMissingTypeEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableFilterExpressionEvaluator
implements BuiltinExpressionEvaluator {
    private Map<String, JRFillField> fieldsMap;
    private JRExpression originalFilterExpression;
    private FillContext fillContext;
    private ReportContext reportContext;
    private String tableReportName;

    public TableFilterExpressionEvaluator(String tableReportName, ReportContext reportContext, FillContext fillContext, JRExpression originalFilterExpression) {
        this.tableReportName = tableReportName;
        this.fillContext = fillContext;
        this.reportContext = reportContext;
        this.originalFilterExpression = originalFilterExpression;
    }

    @Override
    public <T, U, V> void init(Map<String, T> parametersMap, Map<String, U> fieldsMap, Map<String, V> variablesMap, WhenResourceMissingTypeEnum resourceMissingType) throws JRException {
        this.fieldsMap = fieldsMap;
    }

    @Override
    public Object evaluate() throws JRExpressionEvalException {
        Boolean originalEvaluationResult = null;
        Boolean result = Boolean.TRUE;
        try {
            originalEvaluationResult = (Boolean)this.fillContext.evaluate(this.originalFilterExpression, (byte)3);
        }
        catch (JRException e) {
            throw new JRExpressionEvalException(this.originalFilterExpression, (Throwable)e);
        }
        if (originalEvaluationResult == null) {
            originalEvaluationResult = Boolean.TRUE;
        }
        if (this.reportContext != null) {
            String paramFilterField = (String)this.reportContext.getParameterValue(this.tableReportName + "." + "jr.fltrFld");
            String paramFilterValue = (String)this.reportContext.getParameterValue(this.tableReportName + "." + "jr.fltrVl");
            if (this.fieldsMap != null && paramFilterField != null && paramFilterValue != null) {
                JRFillField field = this.fieldsMap.get(paramFilterField);
                if (String.class.getName().equals(field.getValueClassName())) {
                    String fieldValue = (String)field.getValue();
                    result = fieldValue != null && fieldValue.toLowerCase(this.fillContext.getReportLocale()).contains(paramFilterValue.toLowerCase(this.fillContext.getReportLocale()));
                }
            }
        }
        return originalEvaluationResult != false && result != false;
    }

    @Override
    public Object evaluateEstimated() throws JRExpressionEvalException {
        return this.evaluate();
    }

    @Override
    public Object evaluateOld() throws JRExpressionEvalException {
        return this.evaluate();
    }
}

