/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.lib;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.openide.util.NbBundle;

public class EncodingHelper {
    private static final int EXPECTED_PROLOG_LENGTH = 1000;
    private static final Logger logger = Logger.getLogger(EncodingHelper.class.getName());
    static final Map<String, String> encodingIANA2JavaMap = new TreeMap<String, String>();
    static final Map<String, String> encodingIANADescriptionMap = new TreeMap<String, String>();
    static final Map<String, String> encodingIANAAliasesMap = new TreeMap<String, String>();
    static final Map<String, String> encodingJava2IANAMap = new TreeMap<String, String>();

    public static String getIANA2JavaMapping(String string) {
        String string2 = encodingIANA2JavaMap.get(string.toUpperCase());
        return string2 == null ? string : string2;
    }

    public static String getJava2IANAMapping(String string) {
        String string2 = encodingJava2IANAMap.get(string);
        return string2 == null ? string : string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String detectEncoding(InputStream inputStream) throws IOException {
        if (!inputStream.markSupported()) {
            logger.log(Level.WARNING, "EncodingHelper got unmarkable stream: " + inputStream.getClass());
            return null;
        }
        try {
            String string;
            inputStream.mark(1000);
            byte[] byArray = new byte[1000];
            for (int i = 0; i < byArray.length; ++i) {
                try {
                    int n = inputStream.read();
                    if (n == -1) break;
                    byArray[i] = (byte)n;
                    continue;
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
            }
            if ((string = EncodingHelper.autoDetectEncoding(byArray)) == null) {
                String string2 = null;
                return string2;
            }
            if ((string = EncodingHelper.detectDeclaredEncoding(byArray, string)) == null) {
                String string3 = null;
                return string3;
            }
            String string4 = EncodingHelper.getIANA2JavaMapping(string);
            return string4;
        }
        finally {
            inputStream.reset();
        }
    }

    public static String autoDetectEncoding(byte[] byArray) throws IOException {
        if (byArray.length >= 4) {
            switch (byArray[0]) {
                case 0: {
                    if (byArray[1] != 60 || byArray[2] != 0 || byArray[3] != 63) break;
                    return "UnicodeBigUnmarked";
                }
                case 60: {
                    switch (byArray[1]) {
                        case 0: {
                            if (byArray[2] != 63 || byArray[3] != 0) break;
                            return "UnicodeLittleUnmarked";
                        }
                        case 63: {
                            if (byArray[2] != 120 || byArray[3] != 109) break;
                            return "UTF8";
                        }
                    }
                    break;
                }
                case 76: {
                    if (byArray[1] != 111 || byArray[2] != -89 || byArray[3] != -108) break;
                    return "Cp037";
                }
                case -2: {
                    if (byArray[1] != -1 || byArray[2] == 0 && byArray[3] == 0) break;
                    return "UnicodeBig";
                }
                case -1: {
                    if (byArray[1] != -2 || byArray[2] == 0 && byArray[3] == 0) break;
                    return "UnicodeLittle";
                }
                case -17: {
                    if (byArray[1] != -69 || byArray[2] != -65) break;
                    return "UTF8";
                }
            }
        }
        return null;
    }

    public static String detectDeclaredEncoding(byte[] byArray, String string) throws IOException {
        int n;
        String string2;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        char c = '\"';
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), string);
        try {
            int n3 = ((Reader)inputStreamReader).read();
            while (n3 != -1) {
                stringBuffer.append((char)n3);
                n3 = ((Reader)inputStreamReader).read();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        n2 = (n2 = (string2 = stringBuffer.toString()).indexOf("?>")) == -1 ? string2.length() : n2;
        int n4 = string2.indexOf("encoding");
        if (n4 == -1 || n4 > n2) {
            return null;
        }
        char[] cArray = string2.toCharArray();
        for (n = n4; n < n2 && cArray[n] != '='; ++n) {
        }
        while (n < n2) {
            if (cArray[n] == '\'' || cArray[n] == '\"') {
                c = cArray[n];
                break;
            }
            ++n;
        }
        int n5 = ++n;
        while (n < n2) {
            if (cArray[n] == c) {
                return new String(cArray, n5, n - n5);
            }
            ++n;
        }
        return null;
    }

    public static String parseMIMECharSet(String string) {
        int n;
        if (string != null && (n = (string = string.toLowerCase()).indexOf(59)) != -1) {
            String string2 = string.substring(n + 1);
            string = string.substring(0, n);
            n = string2.indexOf("charset");
            if (n != -1) {
                if ((n = (string2 = string2.substring(n + "charset".length())).indexOf(59)) != -1) {
                    string2 = string2.substring(0, n);
                }
                if ((n = string2.indexOf(61)) != -1) {
                    if ((n = (string2 = string2.substring(n + 1)).indexOf(40)) != -1) {
                        string2 = string2.substring(0, n);
                    }
                    if ((n = string2.indexOf(34)) != -1) {
                        string2 = string2.substring(n + 1);
                        string2 = string2.substring(0, string2.indexOf(34));
                    }
                    return string2.trim();
                }
            }
        }
        return null;
    }

    public static String detectEncoding(Document document) throws IOException {
        if (document == null) {
            return null;
        }
        try {
            String string = document.getText(0, document.getLength() > 1000 ? 1000 : document.getLength());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            return EncodingHelper.detectEncoding(byteArrayInputStream);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException(badLocationException.toString());
        }
    }

    static {
        encodingIANA2JavaMap.put("BIG5", "Big5");
        encodingIANADescriptionMap.put("BIG5", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_BIG5"));
        encodingIANAAliasesMap.put("BIG5", "BIG5");
        encodingIANA2JavaMap.put("IBM037", "CP037");
        encodingIANADescriptionMap.put("IBM037", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_IBM037"));
        encodingIANAAliasesMap.put("IBM037", "IBM037");
        encodingIANAAliasesMap.put("EBCDIC-CP-US", "IBM037");
        encodingIANAAliasesMap.put("EBCDIC-CP-CA", "IBM037");
        encodingIANAAliasesMap.put("EBCDIC-CP-NL", "IBM037");
        encodingIANAAliasesMap.put("EBCDIC-CP-WT", "IBM037");
        encodingIANA2JavaMap.put("IBM277", "CP277");
        encodingIANADescriptionMap.put("IBM277", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_IBM277"));
        encodingIANAAliasesMap.put("IBM277", "IBM277");
        encodingIANAAliasesMap.put("EBCDIC-CP-DK", "IBM277");
        encodingIANAAliasesMap.put("EBCDIC-CP-NO", "IBM277");
        encodingIANA2JavaMap.put("IBM278", "CP278");
        encodingIANADescriptionMap.put("IBM278", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_IBM277"));
        encodingIANAAliasesMap.put("IBM278", "IBM278");
        encodingIANAAliasesMap.put("EBCDIC-CP-FI", "IBM278");
        encodingIANAAliasesMap.put("EBCDIC-CP-SE", "IBM278");
        encodingIANA2JavaMap.put("IBM280", "CP280");
        encodingIANADescriptionMap.put("IBM280", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_IBM280"));
        encodingIANAAliasesMap.put("IBM280", "IBM280");
        encodingIANAAliasesMap.put("EBCDIC-CP-IT", "IBM280");
        encodingIANA2JavaMap.put("IBM284", "CP284");
        encodingIANADescriptionMap.put("IBM284", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_IBM284"));
        encodingIANAAliasesMap.put("IBM284", "IBM284");
        encodingIANAAliasesMap.put("EBCDIC-CP-ES", "IBM284");
        encodingIANA2JavaMap.put("IBM285", "CP285");
        encodingIANADescriptionMap.put("IBM285", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_IBM285"));
        encodingIANAAliasesMap.put("IBM285", "IBM285");
        encodingIANAAliasesMap.put("EBCDIC-CP-GB", "IBM285");
        encodingIANA2JavaMap.put("IBM297", "CP297");
        encodingIANADescriptionMap.put("IBM297", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_IBM297"));
        encodingIANAAliasesMap.put("IBM297", "IBM297");
        encodingIANAAliasesMap.put("EBCDIC-CP-FR", "IBM297");
        encodingIANA2JavaMap.put("IBM424", "CP424");
        encodingIANADescriptionMap.put("IBM424", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_IBM424"));
        encodingIANAAliasesMap.put("IBM424", "IBM424");
        encodingIANAAliasesMap.put("EBCDIC-CP-HE", "IBM424");
        encodingIANA2JavaMap.put("IBM500", "CP500");
        encodingIANADescriptionMap.put("IBM500", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_IBM500"));
        encodingIANAAliasesMap.put("IBM500", "IBM500");
        encodingIANAAliasesMap.put("EBCDIC-CP-CH", "IBM500");
        encodingIANAAliasesMap.put("EBCDIC-CP-BE", "IBM500");
        encodingIANA2JavaMap.put("IBM870", "CP870");
        encodingIANADescriptionMap.put("IBM870", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_IBM870"));
        encodingIANAAliasesMap.put("IBM870", "IBM870");
        encodingIANAAliasesMap.put("EBCDIC-CP-ROECE", "IBM870");
        encodingIANAAliasesMap.put("EBCDIC-CP-YU", "IBM870");
        encodingIANA2JavaMap.put("IBM871", "CP871");
        encodingIANADescriptionMap.put("IBM871", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_IBM871"));
        encodingIANAAliasesMap.put("IBM871", "IBM871");
        encodingIANAAliasesMap.put("EBCDIC-CP-IS", "IBM871");
        encodingIANA2JavaMap.put("IBM918", "CP918");
        encodingIANADescriptionMap.put("IBM918", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_IBM918"));
        encodingIANAAliasesMap.put("IBM918", "IBM918");
        encodingIANAAliasesMap.put("EBCDIC-CP-AR2", "IBM918");
        encodingIANA2JavaMap.put("EUC-JP", "EUCJIS");
        encodingIANADescriptionMap.put("EUC-JP", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_EUC-JP"));
        encodingIANAAliasesMap.put("EUC-JP", "EUC-JP");
        encodingIANA2JavaMap.put("EUC-KR", "KSC5601");
        encodingIANADescriptionMap.put("EUC-KR", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_EUC-KR"));
        encodingIANAAliasesMap.put("EUC-KR", "EUC-KR");
        encodingIANA2JavaMap.put("GB2312", "GB2312");
        encodingIANADescriptionMap.put("GB2312", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_GB2312"));
        encodingIANAAliasesMap.put("GB2312", "GB2312");
        encodingIANA2JavaMap.put("ISO-2022-JP", "JIS");
        encodingIANADescriptionMap.put("ISO-2022-JP", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_ISO-2022-JP"));
        encodingIANAAliasesMap.put("ISO-2022-JP", "ISO-2022-JP");
        encodingIANA2JavaMap.put("ISO-2022-KR", "ISO2022KR");
        encodingIANADescriptionMap.put("ISO-2022-KR", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_ISO-2022-KR"));
        encodingIANAAliasesMap.put("ISO-2022-KR", "ISO-2022-KR");
        encodingIANA2JavaMap.put("ISO-8859-1", "8859_1");
        encodingIANADescriptionMap.put("ISO-8859-1", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_ISO-8859-1"));
        encodingIANAAliasesMap.put("ISO-8859-1", "ISO-8859-1");
        encodingIANAAliasesMap.put("LATIN1", "ISO-8859-1");
        encodingIANAAliasesMap.put("L1", "ISO-8859-1");
        encodingIANAAliasesMap.put("IBM819", "ISO-8859-1");
        encodingIANAAliasesMap.put("CP819", "ISO-8859-1");
        encodingIANA2JavaMap.put("ISO-8859-2", "8859_2");
        encodingIANADescriptionMap.put("ISO-8859-2", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_ISO-8859-2"));
        encodingIANAAliasesMap.put("ISO-8859-2", "ISO-8859-2");
        encodingIANAAliasesMap.put("LATIN2", "ISO-8859-2");
        encodingIANAAliasesMap.put("L2", "ISO-8859-2");
        encodingIANA2JavaMap.put("ISO-8859-3", "8859_3");
        encodingIANADescriptionMap.put("ISO-8859-3", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_ISO-8859-3"));
        encodingIANAAliasesMap.put("ISO-8859-3", "ISO-8859-3");
        encodingIANAAliasesMap.put("LATIN3", "ISO-8859-3");
        encodingIANAAliasesMap.put("L3", "ISO-8859-3");
        encodingIANA2JavaMap.put("ISO-8859-4", "8859_4");
        encodingIANADescriptionMap.put("ISO-8859-4", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_ISO-8859-4"));
        encodingIANAAliasesMap.put("ISO-8859-4", "ISO-8859-4");
        encodingIANAAliasesMap.put("LATIN4", "ISO-8859-4");
        encodingIANAAliasesMap.put("L4", "ISO-8859-4");
        encodingIANA2JavaMap.put("ISO-8859-5", "8859_5");
        encodingIANADescriptionMap.put("ISO-8859-5", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_ISO-8859-5"));
        encodingIANAAliasesMap.put("ISO-8859-5", "ISO-8859-5");
        encodingIANAAliasesMap.put("CYRILLIC", "ISO-8859-5");
        encodingIANA2JavaMap.put("ISO-8859-6", "8859_6");
        encodingIANADescriptionMap.put("ISO-8859-6", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_ISO-8859-6"));
        encodingIANAAliasesMap.put("ISO-8859-6", "ISO-8859-6");
        encodingIANA2JavaMap.put("ISO-8859-7", "8859_7");
        encodingIANADescriptionMap.put("ISO-8859-7", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_ISO-8859-7"));
        encodingIANAAliasesMap.put("ISO-8859-7", "ISO-8859-7");
        encodingIANAAliasesMap.put("GREEK", "ISO-8859-7");
        encodingIANAAliasesMap.put("GREEK8", "ISO-8859-7");
        encodingIANA2JavaMap.put("ISO-8859-8", "8859_8");
        encodingIANADescriptionMap.put("ISO-8859-8", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_ISO-8859-8"));
        encodingIANAAliasesMap.put("ISO-8859-8", "ISO-8859-8");
        encodingIANAAliasesMap.put("HEBREW", "ISO-8859-8");
        encodingIANA2JavaMap.put("ISO-8859-9", "8859_9");
        encodingIANADescriptionMap.put("ISO-8859-9", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_ISO-8859-9"));
        encodingIANAAliasesMap.put("ISO-8859-9", "ISO-8859-9");
        encodingIANAAliasesMap.put("LATIN5", "ISO-8859-9");
        encodingIANAAliasesMap.put("L5", "ISO-8859-9");
        encodingIANA2JavaMap.put("KOI8-R", "KOI8_R");
        encodingIANADescriptionMap.put("KOI8-R", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_KOI8-R"));
        encodingIANAAliasesMap.put("KOI8-R", "KOI8-R");
        encodingIANADescriptionMap.put("US-ASCII", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_ASCII"));
        encodingIANAAliasesMap.put("ASCII", "US-ASCII");
        encodingIANAAliasesMap.put("US-ASCII", "US-ASCII");
        encodingIANAAliasesMap.put("ISO646-US", "US-ASCII");
        encodingIANAAliasesMap.put("IBM367", "US-ASCII");
        encodingIANAAliasesMap.put("CP367", "US-ASCII");
        encodingIANA2JavaMap.put("UTF-8", "UTF8");
        encodingIANADescriptionMap.put("UTF-8", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_UTF-8"));
        encodingIANAAliasesMap.put("UTF-8", "UTF-8");
        encodingIANA2JavaMap.put("UTF-16", "Unicode");
        encodingIANADescriptionMap.put("UTF-16", NbBundle.getMessage(EncodingHelper.class, (String)"NAME_UTF-16"));
        encodingIANAAliasesMap.put("UTF-16", "UTF-16");
        for (String string : encodingIANA2JavaMap.keySet()) {
            encodingJava2IANAMap.put(encodingIANA2JavaMap.get(string), string);
        }
        encodingIANA2JavaMap.put("US-ASCII", "8859_1");
    }
}

