/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.connection;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.connection.gui.JavaBeanDataSourceConnectionEditor;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.data.JRBeanArrayDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;

public class JavaBeanDataSourceConnection
extends IReportConnection {
    public static String BEAN_ARRAY = "BEAN_ARRAY";
    public static String BEAN_COLLECTION = "BEAN_COLLECTION";
    private String factoryClass;
    private String methodToCall;
    private boolean useFieldDescription;
    private String type = "BEAN_COLLECTION";

    public Connection getConnection() {
        return null;
    }

    public boolean isJDBCConnection() {
        return false;
    }

    public HashMap getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("FactoryClass", Misc.nvl(this.getFactoryClass(), ""));
        map.put("MethodToCall", Misc.nvl(this.getMethodToCall(), ""));
        map.put("Type", Misc.nvl(this.getType(), ""));
        map.put("UseFieldDescription", "" + this.isUseFieldDescription());
        return map;
    }

    public void loadProperties(HashMap map) {
        this.setFactoryClass((String)map.get("FactoryClass"));
        this.setMethodToCall((String)map.get("MethodToCall"));
        if (map.containsKey("UseFieldDescription")) {
            this.setUseFieldDescription(((String)map.get("UseFieldDescription")).equals("true"));
        }
        if (map.containsKey("Type")) {
            this.setType((String)map.get("Type"));
        }
    }

    public String getMethodToCall() {
        return this.methodToCall;
    }

    public void setMethodToCall(String methodToCall) {
        this.methodToCall = methodToCall;
    }

    public String getFactoryClass() {
        return this.factoryClass;
    }

    public void setFactoryClass(String factoryClass) {
        this.factoryClass = factoryClass;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public JRDataSource getJRDataSource() {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.factoryClass);
            Object obj = clazz.newInstance();
            Object return_obj = obj.getClass().getMethod(this.methodToCall, new Class[0]).invoke(null, new Object[0]);
            if (return_obj != null) {
                if (Misc.nvl(this.getType(), "").equals(BEAN_ARRAY)) {
                    return new JRBeanArrayDataSource((Object[])return_obj, this.isUseFieldDescription());
                }
                if (Misc.nvl(this.getType(), "").equals(BEAN_COLLECTION)) {
                    return new JRBeanCollectionDataSource((Collection)return_obj, this.isUseFieldDescription());
                }
            }
            return new JREmptyDataSource();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return super.getJRDataSource();
        }
    }

    public boolean isUseFieldDescription() {
        return this.useFieldDescription;
    }

    public void setUseFieldDescription(boolean useFieldDescription) {
        this.useFieldDescription = useFieldDescription;
    }

    public String getDescription() {
        return "JavaBeans set datasource";
    }

    public IReportConnectionEditor getIReportConnectionEditor() {
        return new JavaBeanDataSourceConnectionEditor();
    }

    public void test() throws Exception {
        try {
            String string = this.getFactoryClass();
            IReportManager.getInstance();
            Object obj = Class.forName(string, true, IReportManager.getReportClassLoader()).newInstance();
            Object ret_obj = obj.getClass().getMethod(this.getMethodToCall(), new Class[0]).invoke(null, new Object[0]);
            if (ret_obj != null && this.getType().equals(BEAN_COLLECTION) && ret_obj instanceof Collection) {
                JOptionPane.showMessageDialog(Misc.getMainWindow(), "Connection test successful!", "", 1);
            } else if (ret_obj != null && this.getType().equals(BEAN_ARRAY) && ret_obj instanceof Object[]) {
                JOptionPane.showMessageDialog(Misc.getMainWindow(), "Connection test successful!", "", 1);
            } else {
                JOptionPane.showMessageDialog(Misc.getMainWindow(), "The method don't return a valid Array or java.util.Collection!\n", "Error", 0);
            }
        }
        catch (NoClassDefFoundError ex) {
            JOptionPane.showMessageDialog(Misc.getMainWindow(), Misc.formatString("{0}\nNoClassDefFoundError!!\nCheck your classpath!\n{1}", new Object[]{"", "" + ex.getMessage()}), "Exception", 0);
            throw ex;
        }
        catch (ClassNotFoundException ex) {
            JOptionPane.showMessageDialog(Misc.getMainWindow(), Misc.formatString("{0}\nClassNotFoundError!\nMsg: {1}\nPossible not found class: {2}\nCheck your classpath!", new Object[]{"", "" + ex.getMessage(), "" + this.getFactoryClass()}), "Exception", 0);
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(Misc.getMainWindow(), Misc.formatString("{0}\nGeneral problem:\n {1}", new Object[]{"", "" + ex.getMessage()}), "Exception", 0);
            throw ex;
        }
    }
}

