/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class DelegateAction
extends AbstractAction {
    protected Action delegate;
    private PropertyChangeListener pcl;

    public DelegateAction() {
        this((Action)null);
    }

    public DelegateAction(Action action) {
        this.delegate = action;
        this.pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent != null) {
                    if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                        DelegateAction.this.setEnabled((Boolean)propertyChangeEvent.getNewValue());
                    } else {
                        DelegateAction.this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                    }
                }
            }
        };
    }

    protected final Action getDelegate() {
        return this.delegate;
    }

    protected void setDelegate(Action action) {
        if (this.delegate == action) {
            return;
        }
        if (action == this) {
            throw new IllegalStateException("Cannot delegate on the same action");
        }
        if (this.delegate != null) {
            this.delegate.removePropertyChangeListener(this.pcl);
        }
        if (action != null) {
            action.addPropertyChangeListener(this.pcl);
        }
        this.delegate = action;
        this.setEnabled(action != null ? action.isEnabled() : false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.delegate != null) {
            this.delegate.actionPerformed(actionEvent);
        }
    }

    public Object getValue(String string) {
        if (this.delegate != null) {
            return this.delegate.getValue(string);
        }
        return super.getValue(string);
    }

    public void putValue(String string, Object object) {
        if (this.delegate != null) {
            this.delegate.putValue(string, object);
        } else {
            super.putValue(string, object);
        }
    }
}

