/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.sql.DataSource;
import mondrian.olap.Util;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DataSourceConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

class RolapConnectionPool {
    private static final RolapConnectionPool instance = new RolapConnectionPool();
    private final Map<Object, ObjectPool> mapConnectKeyToPool = new HashMap<Object, ObjectPool>();
    private final Map<Object, DataSource> dataSourceMap = new WeakHashMap<Object, DataSource>();

    public static RolapConnectionPool instance() {
        return instance;
    }

    private RolapConnectionPool() {
    }

    public synchronized DataSource getPoolingDataSource(Object key, ConnectionFactory connectionFactory) {
        ObjectPool connectionPool = this.getPool(key, connectionFactory);
        return new PoolingDataSource(connectionPool);
    }

    void clearPool() {
        this.mapConnectKeyToPool.clear();
    }

    public synchronized DataSource getDriverManagerPoolingDataSource(String jdbcConnectString, Properties jdbcProperties) {
        List<Object> key = Arrays.asList("DriverManagerPoolingDataSource", jdbcConnectString, jdbcProperties);
        DataSource dataSource = this.dataSourceMap.get(key);
        if (dataSource != null) {
            return dataSource;
        }
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(jdbcConnectString, jdbcProperties);
        try {
            String propertyString = jdbcProperties.toString();
            dataSource = this.getPoolingDataSource(jdbcConnectString + propertyString, (ConnectionFactory)connectionFactory);
        }
        catch (Throwable e) {
            throw Util.newInternal(e, "Error while creating connection pool (with URI " + jdbcConnectString + ")");
        }
        this.dataSourceMap.put(key, dataSource);
        return dataSource;
    }

    public synchronized DataSource getDataSourcePoolingDataSource(DataSource dataSource, String dataSourceName, String jdbcUser, String jdbcPassword) {
        List<Object> key = Arrays.asList("DataSourcePoolingDataSource", dataSource, jdbcUser, jdbcPassword);
        DataSource pooledDataSource = this.dataSourceMap.get(key);
        if (pooledDataSource != null) {
            return pooledDataSource;
        }
        DataSourceConnectionFactory connectionFactory = jdbcUser != null || jdbcPassword != null ? new DataSourceConnectionFactory(dataSource, jdbcUser, jdbcPassword) : new DataSourceConnectionFactory(dataSource);
        try {
            pooledDataSource = this.getPoolingDataSource(dataSourceName, (ConnectionFactory)connectionFactory);
        }
        catch (Exception e) {
            throw Util.newInternal(e, "Error while creating connection pool (with URI " + dataSourceName + ")");
        }
        this.dataSourceMap.put(key, pooledDataSource);
        return dataSource;
    }

    private synchronized ObjectPool getPool(Object key, ConnectionFactory connectionFactory) {
        ObjectPool connectionPool = this.mapConnectKeyToPool.get(key);
        if (connectionPool == null) {
            connectionPool = new GenericObjectPool(null, 50, 1, 3000L, 10, false, false, 60000L, 5, 30000L, true);
            AbandonedConfig abandonedConfig = new AbandonedConfig();
            abandonedConfig.setRemoveAbandoned(true);
            abandonedConfig.setRemoveAbandonedTimeout(300);
            abandonedConfig.setLogAbandoned(true);
            PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory(connectionFactory, connectionPool, null, null, false, true, abandonedConfig);
            Util.discard((Object)poolableConnectionFactory);
            this.mapConnectKeyToPool.put(key, connectionPool);
        }
        return connectionPool;
    }
}

