/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.widgets.JRDesignElementWidget;
import com.jaspersoft.ireport.designer.widgets.SelectionWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.EnumSet;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportTextElementInplaceEditorProvider
implements InplaceEditorProvider<JTextArea> {
    private TextFieldInplaceEditor editor;
    private EnumSet<InplaceEditorProvider.ExpansionDirection> expansionDirections;
    private KeyListener keyListener;
    private FocusListener focusListener;
    private DocumentListener documentListener;

    public ReportTextElementInplaceEditorProvider(TextFieldInplaceEditor editor) {
        this.editor = editor;
        this.expansionDirections = null;
    }

    public JTextArea createEditorComponent(InplaceEditorProvider.EditorController controller, Widget widget) {
        if (!this.editor.isEnabled(widget)) {
            return null;
        }
        JTextArea field = new JTextArea(this.editor.getText(widget));
        field.setBorder(new LineBorder(Color.GRAY, 1));
        field.selectAll();
        Font font = this.getElementFont(widget);
        if (font != null) {
            field.setFont(font);
        }
        field.setAlignmentY(this.getElementHorizontalAlignment(widget));
        field.setAlignmentX(this.getElementVerticalAlignment(widget));
        return field;
    }

    private Font getElementFont(Widget widget) {
        JRDesignTextElement element = this.getTextElement(widget);
        Scene scene = widget.getScene();
        if (element != null) {
            float size;
            int style = 0;
            if (element.isBold()) {
                style |= 1;
            }
            if (element.isItalic()) {
                style |= 2;
            }
            if ((size = (float)element.getFontSize() * (float)scene.getZoomFactor()) < 5.0f) {
                size = 5.0f;
            }
            Font textFont = new Font(element.getFontName(), style, (int)size);
            textFont = textFont.deriveFont(size);
            return textFont;
        }
        if (scene.getZoomFactor() > 1.0) {
            Font font = scene.getDefaultFont();
            font = font.deriveFont((float)((double)font.getSize2D() * scene.getZoomFactor()));
        }
        return null;
    }

    private float getElementHorizontalAlignment(Widget widget) {
        JRDesignTextElement element = this.getTextElement(widget);
        if (element != null) {
            switch (element.getHorizontalAlignmentValue()) {
                case CENTER: {
                    return 0.5f;
                }
                case LEFT: {
                    return 0.0f;
                }
                case RIGHT: {
                    return 1.0f;
                }
            }
        }
        return 0.0f;
    }

    private float getElementVerticalAlignment(Widget widget) {
        JRDesignTextElement element = this.getTextElement(widget);
        if (element != null) {
            switch (element.getVerticalAlignmentValue()) {
                case MIDDLE: {
                    return 0.5f;
                }
                case TOP: {
                    return 0.0f;
                }
                case BOTTOM: {
                    return 1.0f;
                }
            }
        }
        return 0.0f;
    }

    private JRDesignTextElement getTextElement(Widget widget) {
        if (widget instanceof JRDesignElementWidget) {
            JRDesignElement element = ((JRDesignElementWidget)widget).getElement();
            if (element instanceof JRDesignTextElement) {
                return (JRDesignTextElement)element;
            }
        } else if (widget instanceof SelectionWidget) {
            return this.getTextElement(((SelectionWidget)widget).getRealWidget());
        }
        return null;
    }

    public void notifyOpened(final InplaceEditorProvider.EditorController controller, Widget widget, JTextArea editor) {
        editor.setMinimumSize(new Dimension(64, 19));
        this.keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.getKeyChar()) {
                    case '\u001b': {
                        e.consume();
                        controller.closeEditor(false);
                        break;
                    }
                    case '\n': {
                        if (e.isMetaDown() || e.isAltDown()) {
                            e.setModifiers(0);
                            break;
                        }
                        e.consume();
                        controller.closeEditor(true);
                    }
                }
            }
        };
        this.focusListener = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                controller.closeEditor(true);
            }
        };
        this.documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                controller.notifyEditorComponentBoundsChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                controller.notifyEditorComponentBoundsChanged();
            }

            public void changedUpdate(DocumentEvent e) {
                controller.notifyEditorComponentBoundsChanged();
            }
        };
        editor.addKeyListener(this.keyListener);
        editor.addFocusListener(this.focusListener);
        editor.getDocument().addDocumentListener(this.documentListener);
        editor.selectAll();
    }

    public void notifyClosing(InplaceEditorProvider.EditorController controller, Widget widget, JTextArea editor, boolean commit) {
        editor.getDocument().removeDocumentListener(this.documentListener);
        editor.removeFocusListener(this.focusListener);
        editor.removeKeyListener(this.keyListener);
        if (commit) {
            this.editor.setText(widget, editor.getText());
            if (widget != null) {
                widget.getScene().validate();
            }
        }
    }

    public Rectangle getInitialEditorComponentBounds(InplaceEditorProvider.EditorController controller, Widget widget, JTextArea editor, Rectangle viewBounds) {
        return null;
    }

    public EnumSet<InplaceEditorProvider.ExpansionDirection> getExpansionDirections(InplaceEditorProvider.EditorController controller, Widget widget, JTextArea editor) {
        return this.expansionDirections;
    }
}

