/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.palette.actions.tools;

import com.jaspersoft.ireport.designer.editor.ExpObjectCellRenderer;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.ResetTypeEnum;
import org.jdesktop.layout.GroupLayout;

public class FieldPercentageDialog
extends JDialog {
    private JasperDesign jasperDesign = null;
    private int dialogResult = 2;
    private JButton jButtonCancel;
    private JButton jButtonOk;
    private JComboBox jComboBoxFields;
    private JComboBox jComboBoxResetType;
    private JLabel jLabel1;
    private JLabel jLabelField;
    private JLabel jLabelResetType;
    private JSeparator jSeparator1;

    public FieldPercentageDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.setLocationRelativeTo(null);
        this.jComboBoxFields.setRenderer(new ExpObjectCellRenderer());
        this.setTitle(I18n.getString("FieldPercentageDialog.title"));
        this.jLabelField.setText(I18n.getString("FieldPercentageDialog.jLabelField.text"));
        this.jLabelResetType.setText(I18n.getString("FieldPercentageDialog.jLabelResetType.text"));
        this.jLabel1.setText(I18n.getString("FieldPercentageDialog.jLabel1.text"));
        this.jButtonOk.setText(I18n.getString("FieldPercentageDialog.jButtonOk.text"));
        this.jButtonCancel.setText(I18n.getString("FieldPercentageDialog.jButtonCancel.text"));
        this.pack();
    }

    public JRField getSelectedField() {
        return (JRField)this.jComboBoxFields.getSelectedItem();
    }

    public ResetTypeEnum getSelectedResetTypeValue() {
        Tag selectedTag = (Tag)this.jComboBoxResetType.getSelectedItem();
        if (selectedTag != null && selectedTag.getValue() instanceof ResetTypeEnum) {
            return (ResetTypeEnum)selectedTag.getValue();
        }
        if (selectedTag != null && selectedTag.getValue() instanceof JRGroup) {
            return ResetTypeEnum.GROUP;
        }
        return null;
    }

    public JRGroup getSelectedGroup() {
        Tag selectedTag = (Tag)this.jComboBoxResetType.getSelectedItem();
        if (selectedTag != null && selectedTag.getValue() instanceof JRGroup) {
            return (JRGroup)selectedTag.getValue();
        }
        return null;
    }

    private void initComponents() {
        this.jLabelField = new JLabel();
        this.jComboBoxFields = new JComboBox();
        this.jLabelResetType = new JLabel();
        this.jComboBoxResetType = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jButtonOk = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Percentage");
        this.jLabelField.setText("Field");
        this.jLabelResetType.setText("Reset type");
        this.jLabel1.setText("<html>This tool is used to create a textfield to display the percentage of the total sum of a particular numeric field.");
        this.jButtonOk.setMnemonic('o');
        this.jButtonOk.setText("Ok");
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FieldPercentageDialog.this.jButtonOkActionPerformed(evt);
            }
        });
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FieldPercentageDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1, -1, 354, Short.MAX_VALUE).add((Component)this.jComboBoxFields, 0, 354, Short.MAX_VALUE).add((Component)this.jLabelResetType, -1, 354, Short.MAX_VALUE).add((Component)this.jComboBoxResetType, 0, 354, Short.MAX_VALUE).add((Component)this.jSeparator1, -1, 354, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOk).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jLabelField, -1, 354, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1, -2, 37, -2).add(11, 11, 11).add((Component)this.jLabelField).addPreferredGap(0).add((Component)this.jComboBoxFields, -2, -1, -2).addPreferredGap(1).add((Component)this.jLabelResetType).addPreferredGap(0).add((Component)this.jComboBoxResetType, -2, -1, -2).addPreferredGap(1).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOk)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dialogResult = 2;
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        this.dialogResult = 0;
        this.setVisible(false);
        this.dispose();
    }

    public JasperDesign getJasperDesign() {
        return this.jasperDesign;
    }

    public void setJasperDesign(JasperDesign jasperDesign) {
        this.jasperDesign = jasperDesign;
        this.jComboBoxFields.removeAllItems();
        JRField[] fields = jasperDesign.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!Misc.isNumeric(fields[i].getValueClassName())) continue;
            this.jComboBoxFields.addItem(fields[i]);
        }
        this.jButtonOk.setEnabled(this.jComboBoxFields.getItemCount() > 0);
        if (this.jComboBoxFields.getItemCount() > 0) {
            this.jComboBoxFields.setSelectedIndex(0);
        }
        this.jComboBoxResetType.removeAllItems();
        this.jComboBoxResetType.addItem(new Tag(ResetTypeEnum.REPORT, I18n.getString("VariableNode.Property.Report")));
        this.jComboBoxResetType.addItem(new Tag(ResetTypeEnum.COLUMN, I18n.getString("VariableNode.Property.Column")));
        JRGroup[] groups = jasperDesign.getGroups();
        for (int i = 0; i < groups.length; ++i) {
            this.jComboBoxResetType.addItem(new Tag(groups[i], I18n.getString("FieldPercentageDialog.group.label", (Object)groups[i].getName())));
        }
        this.jComboBoxResetType.addItem(new Tag(ResetTypeEnum.PAGE, I18n.getString("VariableNode.Property.Page")));
        this.jComboBoxResetType.setSelectedIndex(0);
    }

    public int getDialogResult() {
        return this.dialogResult;
    }
}

