/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.properties.style;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import org.openide.ErrorManager;
import org.openide.nodes.PropertySupport;

public final class RadiusProperty
extends PropertySupport {
    private final JRBaseStyle style;

    public RadiusProperty(JRBaseStyle style) {
        super("radius", Integer.class, I18n.getString("RadiusPropertyRadius.Property.Radius"), I18n.getString("RadiusPropertyRadius.Property.Radiusdetail"), true, true);
        this.style = style;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return this.style.getRadius();
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (val == null || val instanceof Integer) {
            Integer oldValue = this.style.getOwnRadius();
            Integer newValue = (Integer)val;
            if (newValue != null && newValue < 0) {
                IllegalArgumentException iae = this.annotateException(I18n.getString("RadiusPropertyRadius.Property.Message"));
                throw iae;
            }
            this.style.setRadius(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "Radius", Integer.TYPE, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    public IllegalArgumentException annotateException(String msg) {
        IllegalArgumentException iae = new IllegalArgumentException(msg);
        ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
        return iae;
    }

    public boolean isDefaultValue() {
        return this.style.getOwnRadius() == null;
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setValue(null);
    }

    public boolean supportsDefaultValue() {
        return true;
    }
}

