/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.lexer;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.lexer.Language;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LanguagePath {
    private static final LanguagePath EMPTY = new LanguagePath();
    private final Language<?>[] languages;
    private Map<Object, Reference<LanguagePath>> language2path;
    private String mimePath;
    private LanguagePath parent;

    public static LanguagePath get(Language<?> language) {
        return LanguagePath.get(null, language);
    }

    public static LanguagePath get(LanguagePath languagePath, Language<?> language) {
        if (languagePath == null) {
            languagePath = EMPTY;
        }
        return languagePath.embedded(language);
    }

    private LanguagePath(LanguagePath languagePath, Language<?> language) {
        int n = languagePath.size();
        this.languages = this.allocateLanguageArray(n + 1);
        System.arraycopy(languagePath.languages, 0, this.languages, 0, n);
        this.languages[n] = language;
        this.parent = languagePath == EMPTY ? null : languagePath;
    }

    private LanguagePath() {
        this.languages = this.allocateLanguageArray(0);
    }

    public int size() {
        return this.languages.length;
    }

    public Language<?> language(int n) {
        return this.languages[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LanguagePath embedded(Language<?> language) {
        if (language == null) {
            throw new IllegalArgumentException("language cannot be null");
        }
        Language<?>[] languageArray = this.languages;
        synchronized (this.languages) {
            LanguagePath languagePath;
            this.initLanguage2path();
            Reference<LanguagePath> reference = this.language2path.get(language);
            if (reference == null || (languagePath = reference.get()) == null) {
                languagePath = new LanguagePath(this, language);
                this.language2path.put(language, new SoftReference<LanguagePath>(languagePath));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return languagePath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LanguagePath embedded(LanguagePath languagePath) {
        if (languagePath == null) {
            throw new IllegalArgumentException("suffix cannot be null");
        }
        Language<?>[] languageArray = this.languages;
        synchronized (this.languages) {
            LanguagePath languagePath2;
            this.initLanguage2path();
            Reference<LanguagePath> reference = this.language2path.get(languagePath);
            if (reference == null || (languagePath2 = reference.get()) == null) {
                languagePath2 = this;
                for (int i = 0; i < languagePath.size(); ++i) {
                    languagePath2 = languagePath2.embedded(languagePath.language(i));
                }
                this.language2path.put(languagePath, new SoftReference<LanguagePath>(languagePath2));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return languagePath2;
        }
    }

    public LanguagePath parent() {
        return this.parent;
    }

    public Language<?> topLanguage() {
        return this.language(0);
    }

    public Language<?> innerLanguage() {
        return this.language(this.size() - 1);
    }

    public boolean endsWith(LanguagePath languagePath) {
        if (languagePath == this || languagePath == EMPTY) {
            return true;
        }
        int n = languagePath.size();
        if (n <= this.size()) {
            for (int i = 1; i <= n; ++i) {
                if (this.language(this.size() - i) == languagePath.language(n - i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public LanguagePath subPath(int n) {
        return this.subPath(n, this.size());
    }

    public LanguagePath subPath(int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("startIndex=" + n + " < 0");
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("endIndex=" + n2 + " > size()=" + this.size());
        }
        if (n >= n2) {
            throw new IndexOutOfBoundsException("startIndex=" + n + " >= endIndex=" + n2);
        }
        if (n == 0 && n2 == this.size()) {
            return this;
        }
        LanguagePath languagePath = LanguagePath.get(this.language(n++));
        while (n < n2) {
            languagePath = LanguagePath.get(languagePath, this.language(n++));
        }
        return languagePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String mimePath() {
        Language<?>[] languageArray = this.languages;
        synchronized (this.languages) {
            if (this.mimePath == null) {
                StringBuilder stringBuilder = new StringBuilder(15 * this.languages.length);
                for (Language<?> language : this.languages) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('/');
                    }
                    stringBuilder.append(language.mimeType());
                }
                this.mimePath = stringBuilder.toString().intern();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mimePath;
        }
    }

    private void initLanguage2path() {
        if (this.language2path == null) {
            this.language2path = new WeakHashMap<Object, Reference<LanguagePath>>();
        }
    }

    private Language<?>[] allocateLanguageArray(int n) {
        return new Language[n];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("LanguagePath: size=").append(this.size());
        stringBuilder.append(", IHC=").append(System.identityHashCode(this));
        stringBuilder.append('\n');
        for (int i = 0; i < this.size(); ++i) {
            stringBuilder.append('[').append(i).append("]: ");
            stringBuilder.append(this.language(i)).append('\n');
        }
        return stringBuilder.toString();
    }
}

