/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map;

import net.sf.jasperreports.components.map.MapPrintElement;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.export.GenericElementHtmlHandler;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterContext;
import net.sf.jasperreports.engine.export.JRXhtmlExporter;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.web.util.VelocityUtil;
import org.apache.velocity.VelocityContext;

public class MapElementHtmlHandler
implements GenericElementHtmlHandler {
    private static final MapElementHtmlHandler INSTANCE = new MapElementHtmlHandler();
    private static final String RESOURCE_MAP_JS = "net/sf/jasperreports/components/map/resources/map.js";
    private static final String MAP_ELEMENT_HTML_TEMPLATE = "net/sf/jasperreports/components/map/resources/templates/MapElementHtmlTemplate.vm";

    public static MapElementHtmlHandler getInstance() {
        return INSTANCE;
    }

    public String getHtmlFragment(JRHtmlExporterContext context, JRGenericPrintElement element) {
        Float latitude = (Float)element.getParameterValue("latitude");
        latitude = latitude == null ? MapPrintElement.DEFAULT_LATITUDE : latitude;
        Float longitude = (Float)element.getParameterValue("longitude");
        longitude = longitude == null ? MapPrintElement.DEFAULT_LONGITUDE : longitude;
        Integer zoom = (Integer)element.getParameterValue("zoom");
        zoom = zoom == null ? MapPrintElement.DEFAULT_ZOOM : zoom;
        VelocityContext velocityContext = new VelocityContext();
        ReportContext reportContext = context.getExporter().getReportContext();
        if (reportContext != null) {
            String webResourcesBasePath = JRProperties.getProperty("net.sf.jasperreports.web.resources.base.path");
            if (webResourcesBasePath == null) {
                webResourcesBasePath = "/servlets/resource?resource.uri=";
            }
            velocityContext.put("resourceMapJs", (Object)(webResourcesBasePath + RESOURCE_MAP_JS));
        }
        velocityContext.put("gotReportContext", (Object)(reportContext != null ? 1 : 0));
        velocityContext.put("latitude", (Object)latitude);
        velocityContext.put("longitude", (Object)longitude);
        velocityContext.put("zoom", (Object)zoom);
        if (context.getExporter() instanceof JRXhtmlExporter) {
            velocityContext.put("xhtml", (Object)"xhtml");
            velocityContext.put("elementX", (Object)((JRXhtmlExporter)context.getExporter()).toSizeUnit(element.getX()));
            velocityContext.put("elementY", (Object)((JRXhtmlExporter)context.getExporter()).toSizeUnit(element.getY()));
        } else {
            velocityContext.put("elementX", (Object)((JRHtmlExporter)context.getExporter()).toSizeUnit(element.getX()));
            velocityContext.put("elementY", (Object)((JRHtmlExporter)context.getExporter()).toSizeUnit(element.getY()));
        }
        velocityContext.put("elementWidth", (Object)element.getWidth());
        velocityContext.put("elementHeight", (Object)element.getHeight());
        if (element.getModeValue() == ModeEnum.OPAQUE) {
            velocityContext.put("backgroundColor", (Object)JRColorUtil.getColorHexa(element.getBackcolor()));
        }
        return VelocityUtil.processTemplate(MAP_ELEMENT_HTML_TEMPLATE, velocityContext);
    }

    public boolean toExport(JRGenericPrintElement element) {
        return true;
    }
}

