/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.sort;

import java.io.IOException;
import net.sf.jasperreports.components.sort.SortComponent;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.component.ComponentXmlWriter;
import net.sf.jasperreports.engine.component.ComponentsEnvironment;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.util.XmlNamespace;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class SortComponentXmlWriter
implements ComponentXmlWriter {
    public void writeToXml(ComponentKey componentKey, Component component, JRXmlWriter reportWriter) throws IOException {
        if (component instanceof SortComponent) {
            SortComponent sortComponent = (SortComponent)component;
            this.writeSortComponent(sortComponent, componentKey, reportWriter);
        }
    }

    protected void writeSortComponent(SortComponent sortComponent, ComponentKey componentKey, JRXmlWriter reportWriter) throws IOException {
        JRXmlWriteHelper writer = reportWriter.getXmlWriteHelper();
        String namespaceURI = componentKey.getNamespace();
        String schemaLocation = ComponentsEnvironment.getComponentsBundle(namespaceURI).getXmlParser().getPublicSchemaLocation();
        XmlNamespace componentNamespace = new XmlNamespace(namespaceURI, componentKey.getNamespacePrefix(), schemaLocation);
        writer.startElement("sort", componentNamespace);
        if (sortComponent.getEvaluationTime() != EvaluationTimeEnum.NOW) {
            writer.addAttribute("evaluationTime", sortComponent.getEvaluationTime());
        }
        writer.addAttribute("evaluationGroup", sortComponent.getEvaluationGroup());
        writer.startElement("symbol");
        if (sortComponent.getHandlerColor() != null) {
            writer.addAttribute("handlerColor", sortComponent.getHandlerColor());
        }
        writer.addAttribute("sortFieldType", sortComponent.getSortFieldType());
        writer.addAttribute("sortFieldName", sortComponent.getSortFieldName());
        writer.addAttribute("handlerHorizontalAlign", sortComponent.getHandlerHorizontalAlign());
        writer.addAttribute("handlerVerticalAlign", sortComponent.getHandlerVerticalAlign());
        this.writeFont(writer, sortComponent.getSymbolFont());
        writer.closeElement();
        writer.closeElement();
    }

    private void writeFont(JRXmlWriteHelper writer, JRFont font) throws IOException {
        if (font != null) {
            writer.startElement("font");
            writer.addEncodedAttribute("fontName", font.getOwnFontName());
            writer.addAttribute("size", font.getOwnFontSize());
            writer.addAttribute("isBold", font.isOwnBold());
            writer.addAttribute("isItalic", font.isOwnItalic());
            writer.addAttribute("isUnderline", font.isOwnUnderline());
            writer.addAttribute("isStrikeThrough", font.isOwnStrikeThrough());
            writer.addEncodedAttribute("pdfFontName", font.getOwnPdfFontName());
            writer.addEncodedAttribute("pdfEncoding", font.getOwnPdfEncoding());
            writer.addAttribute("isPdfEmbedded", font.isOwnPdfEmbedded());
            writer.closeElement(true);
        }
    }
}

